/*
 * Decompiled with CFR 0.152.
 */
package ij.plugin.filter;

import ij.IJ;
import ij.ImagePlus;
import ij.ImageStack;
import ij.gui.Plot;
import ij.gui.ProfilePlot;
import ij.gui.Roi;
import ij.measure.Calibration;
import ij.measure.Measurements;
import ij.plugin.filter.Analyzer;
import ij.plugin.filter.PlugInFilter;
import ij.process.ImageProcessor;
import ij.process.ImageStatistics;
import ij.util.Tools;
import java.awt.Rectangle;

public class ZAxisProfiler
implements PlugInFilter,
Measurements {
    ImagePlus imp;

    @Override
    public int setup(String string, ImagePlus imagePlus) {
        this.imp = imagePlus;
        return 159;
    }

    @Override
    public void run(ImageProcessor imageProcessor) {
        double d;
        if (this.imp.getStackSize() < 2) {
            IJ.error("ZAxisProfiler", "This command requires a stack.");
            return;
        }
        Roi roi = this.imp.getRoi();
        if (roi != null && roi.isLine()) {
            IJ.error("ZAxisProfiler", "This command does not work with line selections.");
            return;
        }
        double d2 = imageProcessor.getMinThreshold();
        float[] fArray = this.getZAxisProfile(roi, d2, d = imageProcessor.getMaxThreshold());
        if (fArray != null) {
            String string;
            Object object;
            float[] fArray2 = new float[fArray.length];
            for (int i = 0; i < fArray2.length; ++i) {
                fArray2[i] = i + 1;
            }
            if (roi != null) {
                object = this.imp.getRoi().getBounds();
                string = this.imp.getTitle() + "-" + ((Rectangle)object).x + "-" + ((Rectangle)object).y;
            } else {
                string = this.imp.getTitle() + "-0-0";
            }
            object = new Plot(string, "Slice", "Mean", fArray2, fArray);
            double d3 = ProfilePlot.getFixedMin();
            double d4 = ProfilePlot.getFixedMax();
            if (d3 != 0.0 || d4 != 0.0) {
                double[] dArray = Tools.getMinMax(fArray2);
                double d5 = dArray[0];
                double d6 = dArray[1];
                ((Plot)object).setLimits(d5, d6, d3, d4);
            }
            ((Plot)object).show();
        }
    }

    float[] getZAxisProfile(Roi roi, double d, double d2) {
        ImageStack imageStack = this.imp.getStack();
        int n = imageStack.getSize();
        float[] fArray = new float[n];
        Calibration calibration = this.imp.getCalibration();
        Analyzer analyzer = new Analyzer(this.imp);
        int n2 = analyzer.getMeasurements();
        boolean bl = n2 != 0 && n2 != 256;
        boolean bl2 = (n2 & 0x400) != 0 || (n2 & 0x100000) != 0;
        n2 |= 2;
        if (bl) {
            if (!analyzer.resetCounter()) {
                return null;
            }
        }
        int n3 = this.imp.getCurrentSlice();
        for (int i = 1; i <= n; ++i) {
            if (bl2) {
                this.imp.setSlice(i);
            }
            ImageProcessor imageProcessor = imageStack.getProcessor(i);
            if (d != -808080.0) {
                imageProcessor.setThreshold(d, d2, 2);
            }
            imageProcessor.setRoi(roi);
            ImageStatistics imageStatistics = ImageStatistics.getStatistics(imageProcessor, n2, calibration);
            analyzer.saveResults(imageStatistics, roi);
            if (bl) {
                analyzer.displayResults();
            }
            fArray[i - 1] = (float)imageStatistics.mean;
        }
        if (bl2) {
            this.imp.setSlice(n3);
        }
        return fArray;
    }
}

