/*
 * Decompiled with CFR 0.152.
 */
package ij.plugin.frame;

import ij.IJ;
import ij.ImagePlus;
import ij.gui.Roi;
import ij.measure.Calibration;
import ij.measure.Measurements;
import ij.plugin.filter.Analyzer;
import ij.process.ByteProcessor;
import ij.process.FloatProcessor;
import ij.process.ImageProcessor;
import ij.process.ImageStatistics;
import ij.process.StackStatistics;
import java.awt.Canvas;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Image;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.image.ColorModel;
import java.awt.image.IndexColorModel;

class ThresholdPlot
extends Canvas
implements Measurements,
MouseListener {
    static final int WIDTH = 256;
    static final int HEIGHT = 48;
    double minThreshold = 85.0;
    double maxThreshold = 170.0;
    ImageStatistics stats;
    int[] histogram;
    Color[] hColors;
    int hmax;
    Image os;
    Graphics osg;
    int mode;
    int originalModeCount;
    double stackMin;
    double stackMax;
    int imageID2;
    boolean entireStack2;
    double mean2;

    public ThresholdPlot() {
        this.addMouseListener(this);
        this.setSize(257, 49);
    }

    @Override
    public Dimension getPreferredSize() {
        return new Dimension(257, 49);
    }

    ImageStatistics setHistogram(ImagePlus imagePlus, boolean bl) {
        int n;
        Cloneable cloneable;
        double d;
        double d2 = d = bl ? imagePlus.getProcessor().getStatistics().mean : 0.0;
        if (bl && this.stats != null && imagePlus.getID() == this.imageID2 && bl == this.entireStack2 && d == this.mean2) {
            return this.stats;
        }
        this.mean2 = d;
        ImageProcessor imageProcessor = imagePlus.getProcessor();
        this.stats = null;
        if (bl) {
            this.stats = new StackStatistics(imagePlus);
        }
        if (!(imageProcessor instanceof ByteProcessor)) {
            if (bl) {
                if (imagePlus.getLocalCalibration().isSigned16Bit()) {
                    this.stats.min += 32768.0;
                    this.stats.max += 32768.0;
                }
                this.stackMin = this.stats.min;
                this.stackMax = this.stats.max;
                imageProcessor.setMinAndMax(this.stackMin, this.stackMax);
                imagePlus.updateAndDraw();
            } else {
                this.stackMax = 0.0;
                this.stackMin = 0.0;
                if (this.entireStack2) {
                    imageProcessor.resetMinAndMax();
                    imagePlus.updateAndDraw();
                }
            }
            cloneable = imagePlus.getCalibration();
            if (imageProcessor instanceof FloatProcessor) {
                n = Math.max(Analyzer.getPrecision(), 2);
                IJ.showStatus("min=" + IJ.d2s(imageProcessor.getMin(), n) + ", max=" + IJ.d2s(imageProcessor.getMax(), n));
            } else {
                IJ.showStatus("min=" + (int)((Calibration)cloneable).getCValue(imageProcessor.getMin()) + ", max=" + (int)((Calibration)cloneable).getCValue(imageProcessor.getMax()));
            }
            imageProcessor = imageProcessor.convertToByte(true);
            imageProcessor.setColorModel(imageProcessor.getDefaultColorModel());
        }
        if ((cloneable = imagePlus.getRoi()) != null && !((Roi)cloneable).isArea()) {
            cloneable = null;
        }
        imageProcessor.setRoi((Roi)cloneable);
        if (this.stats == null) {
            this.stats = ImageStatistics.getStatistics(imageProcessor, 25, null);
        }
        n = 0;
        this.histogram = this.stats.histogram;
        this.originalModeCount = this.histogram[this.stats.mode];
        for (int i = 0; i < this.stats.nBins; ++i) {
            if (this.histogram[i] <= n || i == this.stats.mode) continue;
            n = this.histogram[i];
        }
        this.hmax = this.stats.maxCount;
        if (this.hmax > n * 2 && n != 0) {
            this.histogram[this.stats.mode] = this.hmax = (int)((double)n * 1.5);
        }
        this.os = null;
        ColorModel colorModel = imageProcessor.getColorModel();
        if (!(colorModel instanceof IndexColorModel)) {
            return null;
        }
        IndexColorModel indexColorModel = (IndexColorModel)colorModel;
        int n2 = indexColorModel.getMapSize();
        if (n2 != 256) {
            return null;
        }
        byte[] byArray = new byte[256];
        byte[] byArray2 = new byte[256];
        byte[] byArray3 = new byte[256];
        indexColorModel.getReds(byArray);
        indexColorModel.getGreens(byArray2);
        indexColorModel.getBlues(byArray3);
        this.hColors = new Color[256];
        for (int i = 0; i < 256; ++i) {
            this.hColors[i] = new Color(byArray[i] & 0xFF, byArray2[i] & 0xFF, byArray3[i] & 0xFF);
        }
        this.imageID2 = imagePlus.getID();
        this.entireStack2 = bl;
        return this.stats;
    }

    @Override
    public void update(Graphics graphics) {
        this.paint(graphics);
    }

    @Override
    public void paint(Graphics graphics) {
        if (graphics == null) {
            return;
        }
        if (this.histogram != null) {
            if (this.os == null && this.hmax > 0) {
                this.os = this.createImage(256, 48);
                this.osg = this.os.getGraphics();
                this.osg.setColor(Color.white);
                this.osg.fillRect(0, 0, 256, 48);
                this.osg.setColor(Color.gray);
                for (int i = 0; i < 256; ++i) {
                    if (this.hColors != null) {
                        this.osg.setColor(this.hColors[i]);
                    }
                    this.osg.drawLine(i, 48, i, 48 - 48 * this.histogram[i] / this.hmax);
                }
                this.osg.dispose();
            }
            if (this.os == null) {
                return;
            }
            graphics.drawImage(this.os, 0, 0, this);
        } else {
            graphics.setColor(Color.white);
            graphics.fillRect(0, 0, 256, 48);
        }
        graphics.setColor(Color.black);
        graphics.drawRect(0, 0, 256, 48);
        if (this.mode == 0) {
            graphics.setColor(Color.red);
        } else if (this.mode == 2) {
            graphics.setColor(Color.blue);
            graphics.drawRect(1, 1, (int)this.minThreshold - 2, 48);
            graphics.drawRect(1, 0, (int)this.minThreshold - 2, 0);
            graphics.setColor(Color.green);
            graphics.drawRect((int)this.maxThreshold + 1, 1, 256 - (int)this.maxThreshold, 48);
            graphics.drawRect((int)this.maxThreshold + 1, 0, 256 - (int)this.maxThreshold, 0);
            return;
        }
        graphics.drawRect((int)this.minThreshold, 1, (int)(this.maxThreshold - this.minThreshold), 48);
        graphics.drawLine((int)this.minThreshold, 0, (int)this.maxThreshold, 0);
    }

    @Override
    public void mousePressed(MouseEvent mouseEvent) {
    }

    @Override
    public void mouseReleased(MouseEvent mouseEvent) {
    }

    @Override
    public void mouseExited(MouseEvent mouseEvent) {
    }

    @Override
    public void mouseClicked(MouseEvent mouseEvent) {
    }

    @Override
    public void mouseEntered(MouseEvent mouseEvent) {
    }
}

