/*
 * Decompiled with CFR 0.152.
 */
package ij.process;

import ij.IJ;

public class AutoThresholder {
    private static String[] mStrings;

    public static String[] getMethods() {
        if (mStrings == null) {
            Method[] methodArray = Method.values();
            mStrings = new String[methodArray.length];
            for (int i = 0; i < methodArray.length; ++i) {
                AutoThresholder.mStrings[i] = methodArray[i].name();
            }
        }
        return mStrings;
    }

    public int getThreshold(Method method, int[] nArray) {
        int n = 0;
        switch (method) {
            case Default: {
                n = this.defaultIsoData(nArray);
                break;
            }
            case IJ_IsoData: {
                n = this.IJIsoData(nArray);
                break;
            }
            case Huang: {
                n = this.Huang(nArray);
                break;
            }
            case Intermodes: {
                n = this.Intermodes(nArray);
                break;
            }
            case IsoData: {
                n = this.IsoData(nArray);
                break;
            }
            case Li: {
                n = this.Li(nArray);
                break;
            }
            case MaxEntropy: {
                n = this.MaxEntropy(nArray);
                break;
            }
            case Mean: {
                n = this.Mean(nArray);
                break;
            }
            case MinError: {
                n = this.MinErrorI(nArray);
                break;
            }
            case Minimum: {
                n = this.Minimum(nArray);
                break;
            }
            case Moments: {
                n = this.Moments(nArray);
                break;
            }
            case Otsu: {
                n = this.Otsu(nArray);
                break;
            }
            case Percentile: {
                n = this.Percentile(nArray);
                break;
            }
            case RenyiEntropy: {
                n = this.RenyiEntropy(nArray);
                break;
            }
            case Shanbhag: {
                n = this.Shanbhag(nArray);
                break;
            }
            case Triangle: {
                n = this.Triangle(nArray);
                break;
            }
            case Yen: {
                n = this.Yen(nArray);
            }
        }
        if (n == -1) {
            n = 0;
        }
        return n;
    }

    public int getThreshold(String string, int[] nArray) {
        int n = string.indexOf(" ");
        if (n != -1) {
            string = string.substring(0, n);
        }
        Method method = Method.valueOf(Method.class, string);
        return this.getThreshold(method, nArray);
    }

    int Huang(int[] nArray) {
        int n;
        int n2 = -1;
        int n3 = 0;
        for (n = 0; n < 256; ++n) {
            if (nArray[n] == 0) continue;
            n3 = n;
            break;
        }
        int n4 = 255;
        for (n = 255; n >= n3; --n) {
            if (nArray[n] == 0) continue;
            n4 = n;
            break;
        }
        double d = 1.0 / (double)(n4 - n3);
        double[] dArray = new double[256];
        double d2 = 0.0;
        double d3 = 0.0;
        for (n = n3; n < 256; ++n) {
            dArray[n] = (d3 += (double)n * (double)nArray[n]) / (d2 += (double)nArray[n]);
        }
        double[] dArray2 = new double[256];
        d2 = 0.0;
        d3 = 0.0;
        for (n = n4; n > 0; --n) {
            dArray2[n - 1] = (d3 += (double)n * (double)nArray[n]) / (d2 += (double)nArray[n]);
        }
        n2 = -1;
        double d4 = Double.MAX_VALUE;
        for (int i = 0; i < 256; ++i) {
            double d5;
            double d6 = 0.0;
            for (n = 0; n <= i; ++n) {
                d5 = 1.0 / (1.0 + d * Math.abs((double)n - dArray[i]));
                if (d5 < 1.0E-6 || d5 > 0.999999) continue;
                d6 += (double)nArray[n] * (-d5 * Math.log(d5) - (1.0 - d5) * Math.log(1.0 - d5));
            }
            for (n = i + 1; n < 256; ++n) {
                d5 = 1.0 / (1.0 + d * Math.abs((double)n - dArray2[i]));
                if (d5 < 1.0E-6 || d5 > 0.999999) continue;
                d6 += (double)nArray[n] * (-d5 * Math.log(d5) - (1.0 - d5) * Math.log(1.0 - d5));
            }
            if (!(d6 < d4)) continue;
            d4 = d6;
            n2 = i;
        }
        return n2;
    }

    boolean bimodalTest(double[] dArray) {
        int n = dArray.length;
        boolean bl = false;
        int n2 = 0;
        for (int i = 1; i < n - 1; ++i) {
            if (!(dArray[i - 1] < dArray[i]) || !(dArray[i + 1] < dArray[i]) || ++n2 <= 2) continue;
            return false;
        }
        if (n2 == 2) {
            bl = true;
        }
        return bl;
    }

    int Intermodes(int[] nArray) {
        int n;
        double[] dArray = new double[256];
        int n2 = 0;
        int n3 = -1;
        for (int i = 0; i < 256; ++i) {
            dArray[i] = nArray[i];
        }
        double[] dArray2 = dArray;
        while (!this.bimodalTest(dArray)) {
            for (n = 1; n < 255; ++n) {
                dArray2[n] = (dArray[n - 1] + dArray[n] + dArray[n + 1]) / 3.0;
            }
            dArray2[0] = (dArray[0] + dArray[1]) / 3.0;
            dArray2[255] = (dArray[254] + dArray[255]) / 3.0;
            dArray = dArray2;
            if (++n2 <= 10000) continue;
            n3 = -1;
            IJ.log("Intermodes: threshold not found after 10000 iterations.");
            return n3;
        }
        n = 0;
        for (int i = 1; i < 255; ++i) {
            if (!(dArray[i - 1] < dArray[i]) || !(dArray[i + 1] < dArray[i])) continue;
            n += i;
        }
        n3 = (int)Math.floor((double)n / 2.0);
        return n3;
    }

    int IsoData(int[] nArray) {
        int n;
        block4: {
            int n2;
            n = 0;
            for (n2 = 1; n2 < 256; ++n2) {
                if (nArray[n2] <= 0) continue;
                n = n2 + 1;
                break;
            }
            do {
                int n3 = 0;
                int n4 = 0;
                for (n2 = 0; n2 < n; ++n2) {
                    n4 += nArray[n2];
                    n3 += nArray[n2] * n2;
                }
                double d = 0.0;
                double d2 = 0.0;
                for (n2 = n + 1; n2 < 256; ++n2) {
                    d2 += (double)nArray[n2];
                    d += (double)nArray[n2] * (double)n2;
                }
                if (n4 > 0 && d2 > 0.0 && n == (int)Math.round(((double)(n3 /= n4) + (d /= d2)) / 2.0)) break block4;
            } while (++n <= 254);
            return -1;
        }
        return n;
    }

    int defaultIsoData(int[] nArray) {
        int n;
        int n2;
        int n3 = nArray.length;
        int[] nArray2 = new int[n3];
        int n4 = 0;
        int n5 = 0;
        for (n2 = 0; n2 < n3; ++n2) {
            n = nArray[n2];
            nArray2[n2] = nArray[n2];
            if (nArray2[n2] <= n5) continue;
            n5 = nArray2[n2];
            n4 = n2;
        }
        n2 = 0;
        for (n = 0; n < n3; ++n) {
            if (nArray2[n] <= n2 || n == n4) continue;
            n2 = nArray2[n];
        }
        n = n5;
        if (n > n2 * 2 && n2 != 0) {
            nArray2[n4] = n = (int)((double)n2 * 1.5);
        }
        return this.IJIsoData(nArray2);
    }

    int IJIsoData(int[] nArray) {
        double d;
        double d2;
        double d3;
        double d4;
        double d5;
        int n;
        int n2;
        int n3 = nArray.length - 1;
        int n4 = nArray[0];
        nArray[0] = 0;
        int n5 = nArray[n3];
        nArray[n3] = 0;
        for (n2 = 0; nArray[n2] == 0 && n2 < n3; ++n2) {
        }
        for (n = n3; nArray[n] == 0 && n > 0; --n) {
        }
        if (n2 >= n) {
            nArray[0] = n4;
            nArray[n3] = n5;
            int n6 = nArray.length / 2;
            return n6;
        }
        int n7 = n2;
        int n8 = Math.max(n / 40, 1);
        do {
            int n9;
            d = 0.0;
            d2 = 0.0;
            d3 = 0.0;
            d4 = 0.0;
            for (n9 = n2; n9 <= n7; ++n9) {
                d4 += (double)n9 * (double)nArray[n9];
                d3 += (double)nArray[n9];
            }
            for (n9 = n7 + 1; n9 <= n; ++n9) {
                d2 += (double)n9 * (double)nArray[n9];
                d += (double)nArray[n9];
            }
        } while ((double)(++n7 + 1) <= (d5 = (d4 / d3 + d2 / d) / 2.0) && n7 < n - 1);
        nArray[0] = n4;
        nArray[n3] = n5;
        int n10 = (int)Math.round(d5);
        return n10;
    }

    int Li(int[] nArray) {
        int n;
        double d;
        double d2;
        double d3;
        double d4;
        double d5;
        double d6;
        int n2;
        double d7 = 0.5;
        double d8 = 0.0;
        for (n2 = 0; n2 < 256; ++n2) {
            d8 += (double)nArray[n2];
        }
        double d9 = 0.0;
        for (n2 = 1; n2 < 256; ++n2) {
            d9 += (double)n2 * (double)nArray[n2];
        }
        double d10 = d9 /= d8;
        do {
            d = d10;
            n = (int)(d + 0.5);
            double d11 = 0.0;
            double d12 = 0.0;
            for (n2 = 0; n2 <= n; ++n2) {
                d11 += (double)n2 * (double)nArray[n2];
                d12 += (double)nArray[n2];
            }
            d5 = d12 == 0.0 ? 0.0 : d11 / d12;
            d2 = 0.0;
            d3 = 0.0;
            for (n2 = n + 1; n2 < 256; ++n2) {
                d2 += (double)n2 * (double)nArray[n2];
                d3 += (double)nArray[n2];
            }
        } while (Math.abs((d10 = (d6 = (d5 - (d4 = d3 == 0.0 ? 0.0 : d2 / d3)) / (Math.log(d5) - Math.log(d4))) < -2.220446049250313E-16 ? (double)((int)(d6 - 0.5)) : (double)((int)(d6 + 0.5))) - d) > d7);
        return n;
    }

    int MaxEntropy(int[] nArray) {
        int n;
        int n2 = -1;
        double[] dArray = new double[256];
        double[] dArray2 = new double[256];
        double[] dArray3 = new double[256];
        double d = 0.0;
        for (n = 0; n < 256; ++n) {
            d += (double)nArray[n];
        }
        for (n = 0; n < 256; ++n) {
            dArray[n] = (double)nArray[n] / d;
        }
        dArray2[0] = dArray[0];
        dArray3[0] = 1.0 - dArray2[0];
        for (n = 1; n < 256; ++n) {
            dArray2[n] = dArray2[n - 1] + dArray[n];
            dArray3[n] = 1.0 - dArray2[n];
        }
        int n3 = 0;
        for (n = 0; n < 256; ++n) {
            if (Math.abs(dArray2[n]) < 2.220446049250313E-16) continue;
            n3 = n;
            break;
        }
        int n4 = 255;
        for (n = 255; n >= n3; --n) {
            if (Math.abs(dArray3[n]) < 2.220446049250313E-16) continue;
            n4 = n;
            break;
        }
        double d2 = Double.MIN_VALUE;
        for (int i = n3; i <= n4; ++i) {
            double d3 = 0.0;
            for (n = 0; n <= i; ++n) {
                if (nArray[n] == 0) continue;
                d3 -= dArray[n] / dArray2[i] * Math.log(dArray[n] / dArray2[i]);
            }
            double d4 = 0.0;
            for (n = i + 1; n < 256; ++n) {
                if (nArray[n] == 0) continue;
                d4 -= dArray[n] / dArray3[i] * Math.log(dArray[n] / dArray3[i]);
            }
            double d5 = d3 + d4;
            if (!(d2 < d5)) continue;
            d2 = d5;
            n2 = i;
        }
        return n2;
    }

    int Mean(int[] nArray) {
        int n = -1;
        double d = 0.0;
        double d2 = 0.0;
        for (int i = 0; i < 256; ++i) {
            d += (double)nArray[i];
            d2 += (double)i * (double)nArray[i];
        }
        n = (int)Math.floor(d2 / d);
        return n;
    }

    int MinErrorI(int[] nArray) {
        int n = this.Mean(nArray);
        int n2 = -2;
        while (n != n2) {
            double d;
            double d2;
            double d3;
            double d4 = this.B(nArray, n) / this.A(nArray, n);
            double d5 = (this.B(nArray, 255) - this.B(nArray, n)) / (this.A(nArray, 255) - this.A(nArray, n));
            double d6 = this.A(nArray, n) / this.A(nArray, 255);
            double d7 = (this.A(nArray, 255) - this.A(nArray, n)) / this.A(nArray, 255);
            double d8 = this.C(nArray, n) / this.A(nArray, n) - d4 * d4;
            double d9 = d4 / d8 - d5 / (d3 = (this.C(nArray, 255) - this.C(nArray, n)) / (this.A(nArray, 255) - this.A(nArray, n)) - d5 * d5);
            double d10 = d9 * d9 - (d2 = 1.0 / d8 - 1.0 / d3) * (d = d4 * d4 / d8 - d5 * d5 / d3 + Math.log10(d8 * (d7 * d7) / (d3 * (d6 * d6))));
            if (d10 < 0.0) {
                IJ.log("MinError(I): not converging.");
                return n;
            }
            n2 = n;
            double d11 = (d9 + Math.sqrt(d10)) / d2;
            if (Double.isNaN(d11)) {
                IJ.log("MinError(I): NaN, not converging.");
                n = n2;
                continue;
            }
            n = (int)Math.floor(d11);
        }
        return n;
    }

    double A(int[] nArray, int n) {
        double d = 0.0;
        for (int i = 0; i <= n; ++i) {
            d += (double)nArray[i];
        }
        return d;
    }

    double B(int[] nArray, int n) {
        double d = 0.0;
        for (int i = 0; i <= n; ++i) {
            d += (double)(i * nArray[i]);
        }
        return d;
    }

    double C(int[] nArray, int n) {
        double d = 0.0;
        for (int i = 0; i <= n; ++i) {
            d += (double)(i * i * nArray[i]);
        }
        return d;
    }

    int Minimum(int[] nArray) {
        int n;
        int n2 = 0;
        int n3 = -1;
        double[] dArray = new double[256];
        for (int i = 0; i < 256; ++i) {
            dArray[i] = nArray[i];
        }
        double[] dArray2 = dArray;
        while (!this.bimodalTest(dArray)) {
            for (n = 1; n < 255; ++n) {
                dArray2[n] = (dArray[n - 1] + dArray[n] + dArray[n + 1]) / 3.0;
            }
            dArray2[0] = (dArray[0] + dArray[1]) / 3.0;
            dArray2[255] = (dArray[254] + dArray[255]) / 3.0;
            dArray = dArray2;
            if (++n2 <= 10000) continue;
            n3 = -1;
            IJ.log("Minimum: threshold not found after 10000 iterations.");
            return n3;
        }
        for (n = 1; n < 255; ++n) {
            if (!(dArray[n - 1] > dArray[n]) || !(dArray[n + 1] >= dArray[n])) continue;
            n3 = n;
        }
        return n3;
    }

    int Moments(int[] nArray) {
        int n;
        double d = 0.0;
        double d2 = 1.0;
        double d3 = 0.0;
        double d4 = 0.0;
        double d5 = 0.0;
        double d6 = 0.0;
        double d7 = 0.0;
        int n2 = -1;
        double[] dArray = new double[256];
        for (n = 0; n < 256; ++n) {
            d += (double)nArray[n];
        }
        for (n = 0; n < 256; ++n) {
            dArray[n] = (double)nArray[n] / d;
        }
        for (n = 0; n < 256; ++n) {
            double d8 = n;
            d3 += d8 * dArray[n];
            d4 += d8 * d8 * dArray[n];
            d5 += d8 * d8 * d8 * dArray[n];
        }
        double d9 = d2 * d4 - d3 * d3;
        double d10 = (-d4 * d4 + d3 * d5) / d9;
        double d11 = (d2 * -d5 + d4 * d3) / d9;
        double d12 = 0.5 * (-d11 - Math.sqrt(d11 * d11 - 4.0 * d10));
        double d13 = 0.5 * (-d11 + Math.sqrt(d11 * d11 - 4.0 * d10));
        d7 = (d13 - d3) / (d13 - d12);
        d6 = 0.0;
        for (n = 0; n < 256; ++n) {
            if (!((d6 += dArray[n]) > d7)) continue;
            n2 = n;
            break;
        }
        return n2;
    }

    int Otsu(int[] nArray) {
        double d = 256.0;
        double d2 = 0.0;
        double d3 = 0.0;
        int n = 0;
        while ((double)n < d) {
            d3 += (double)n * (double)nArray[n];
            d2 += (double)nArray[n];
            ++n;
        }
        double d4 = 0.0;
        double d5 = nArray[0];
        double d6 = 0.0;
        double d7 = 0.0;
        int n2 = 0;
        n = 1;
        while ((double)n < d - 1.0) {
            double d8;
            d4 += (double)n * (double)nArray[n];
            if ((d8 = (d5 += (double)nArray[n]) * (d2 - d5)) != 0.0) {
                double d9 = d5 / d2 * d3 - d4;
                d6 = d9 * d9 / d8;
            } else {
                d6 = 0.0;
            }
            if (d6 >= d7) {
                d7 = d6;
                n2 = n;
            }
            ++n;
        }
        return n2;
    }

    int Percentile(int[] nArray) {
        boolean bl = false;
        int n = -1;
        double d = 0.5;
        double[] dArray = new double[256];
        for (int i = 0; i < 256; ++i) {
            dArray[i] = 0.0;
        }
        double d2 = this.partialSum(nArray, 255);
        double d3 = 1.0;
        for (int i = 0; i < 256; ++i) {
            dArray[i] = Math.abs(this.partialSum(nArray, i) / d2 - d);
            if (!(dArray[i] < d3)) continue;
            d3 = dArray[i];
            n = i;
        }
        return n;
    }

    double partialSum(int[] nArray, int n) {
        double d = 0.0;
        for (int i = 0; i <= n; ++i) {
            d += (double)nArray[i];
        }
        return d;
    }

    int RenyiEntropy(int[] nArray) {
        int n;
        int n2;
        int n3;
        int n4;
        double d;
        double d2;
        double d3;
        int n5;
        int n6;
        double[] dArray = new double[256];
        double[] dArray2 = new double[256];
        double[] dArray3 = new double[256];
        double d4 = 0.0;
        for (n6 = 0; n6 < 256; ++n6) {
            d4 += (double)nArray[n6];
        }
        for (n6 = 0; n6 < 256; ++n6) {
            dArray[n6] = (double)nArray[n6] / d4;
        }
        dArray2[0] = dArray[0];
        dArray3[0] = 1.0 - dArray2[0];
        for (n6 = 1; n6 < 256; ++n6) {
            dArray2[n6] = dArray2[n6 - 1] + dArray[n6];
            dArray3[n6] = 1.0 - dArray2[n6];
        }
        int n7 = 0;
        for (n6 = 0; n6 < 256; ++n6) {
            if (Math.abs(dArray2[n6]) < 2.220446049250313E-16) continue;
            n7 = n6;
            break;
        }
        int n8 = 255;
        for (n6 = 255; n6 >= n7; --n6) {
            if (Math.abs(dArray3[n6]) < 2.220446049250313E-16) continue;
            n8 = n6;
            break;
        }
        int n9 = 0;
        double d5 = 0.0;
        for (n5 = n7; n5 <= n8; ++n5) {
            d3 = 0.0;
            for (n6 = 0; n6 <= n5; ++n6) {
                if (nArray[n6] == 0) continue;
                d3 -= dArray[n6] / dArray2[n5] * Math.log(dArray[n6] / dArray2[n5]);
            }
            d2 = 0.0;
            for (n6 = n5 + 1; n6 < 256; ++n6) {
                if (nArray[n6] == 0) continue;
                d2 -= dArray[n6] / dArray3[n5] * Math.log(dArray[n6] / dArray3[n5]);
            }
            d = d3 + d2;
            if (!(d5 < d)) continue;
            d5 = d;
            n9 = n5;
        }
        int n10 = n9;
        n9 = 0;
        d5 = 0.0;
        double d6 = 0.5;
        double d7 = 1.0 / (1.0 - d6);
        for (n5 = n7; n5 <= n8; ++n5) {
            d3 = 0.0;
            for (n6 = 0; n6 <= n5; ++n6) {
                d3 += Math.sqrt(dArray[n6] / dArray2[n5]);
            }
            d2 = 0.0;
            for (n6 = n5 + 1; n6 < 256; ++n6) {
                d2 += Math.sqrt(dArray[n6] / dArray3[n5]);
            }
            d = d7 * (d3 * d2 > 0.0 ? Math.log(d3 * d2) : 0.0);
            if (!(d > d5)) continue;
            d5 = d;
            n9 = n5;
        }
        int n11 = n9;
        n9 = 0;
        d5 = 0.0;
        d6 = 2.0;
        d7 = 1.0 / (1.0 - d6);
        for (n5 = n7; n5 <= n8; ++n5) {
            d3 = 0.0;
            for (n6 = 0; n6 <= n5; ++n6) {
                d3 += dArray[n6] * dArray[n6] / (dArray2[n5] * dArray2[n5]);
            }
            d2 = 0.0;
            for (n6 = n5 + 1; n6 < 256; ++n6) {
                d2 += dArray[n6] * dArray[n6] / (dArray3[n5] * dArray3[n5]);
            }
            d = d7 * (d3 * d2 > 0.0 ? Math.log(d3 * d2) : 0.0);
            if (!(d > d5)) continue;
            d5 = d;
            n9 = n5;
        }
        int n12 = n9;
        if (n10 < n11) {
            n4 = n11;
            n11 = n10;
            n10 = n4;
        }
        if (n12 < n10) {
            n4 = n10;
            n10 = n12;
            n12 = n4;
        }
        if (n10 < n11) {
            n4 = n11;
            n11 = n10;
            n10 = n4;
        }
        if (Math.abs(n11 - n10) <= 5) {
            if (Math.abs(n10 - n12) <= 5) {
                n3 = 1;
                n2 = 2;
                n = 1;
            } else {
                n3 = 0;
                n2 = 1;
                n = 3;
            }
        } else if (Math.abs(n10 - n12) <= 5) {
            n3 = 3;
            n2 = 1;
            n = 0;
        } else {
            n3 = 1;
            n2 = 2;
            n = 1;
        }
        double d8 = dArray2[n12] - dArray2[n11];
        int n13 = (int)((double)n11 * (dArray2[n11] + 0.25 * d8 * (double)n3) + 0.25 * (double)n10 * d8 * (double)n2 + (double)n12 * (dArray3[n12] + 0.25 * d8 * (double)n));
        return n13;
    }

    int Shanbhag(int[] nArray) {
        int n;
        double[] dArray = new double[256];
        double[] dArray2 = new double[256];
        double[] dArray3 = new double[256];
        double d = 0.0;
        for (n = 0; n < 256; ++n) {
            d += (double)nArray[n];
        }
        for (n = 0; n < 256; ++n) {
            dArray[n] = (double)nArray[n] / d;
        }
        dArray2[0] = dArray[0];
        dArray3[0] = 1.0 - dArray2[0];
        for (n = 1; n < 256; ++n) {
            dArray2[n] = dArray2[n - 1] + dArray[n];
            dArray3[n] = 1.0 - dArray2[n];
        }
        int n2 = 0;
        for (n = 0; n < 256; ++n) {
            if (Math.abs(dArray2[n]) < 2.220446049250313E-16) continue;
            n2 = n;
            break;
        }
        int n3 = 255;
        for (n = 255; n >= n2; --n) {
            if (Math.abs(dArray3[n]) < 2.220446049250313E-16) continue;
            n3 = n;
            break;
        }
        int n4 = -1;
        double d2 = Double.MAX_VALUE;
        for (int i = n2; i <= n3; ++i) {
            double d3 = 0.0;
            double d4 = 0.5 / dArray2[i];
            for (n = 1; n <= i; ++n) {
                d3 -= dArray[n] * Math.log(1.0 - d4 * dArray2[n - 1]);
            }
            d3 *= d4;
            double d5 = 0.0;
            d4 = 0.5 / dArray3[i];
            for (n = i + 1; n < 256; ++n) {
                d5 -= dArray[n] * Math.log(1.0 - d4 * dArray3[n]);
            }
            double d6 = Math.abs(d3 - (d5 *= d4));
            if (!(d6 < d2)) continue;
            d2 = d6;
            n4 = i;
        }
        return n4;
    }

    int Triangle(int[] nArray) {
        int n;
        int n2;
        int n3 = 0;
        int n4 = 0;
        int n5 = 0;
        int n6 = 0;
        for (n2 = 0; n2 < nArray.length; ++n2) {
            if (nArray[n2] <= 0) continue;
            n3 = n2;
            break;
        }
        if (n3 > 0) {
            --n3;
        }
        for (n2 = 255; n2 > 0; --n2) {
            if (nArray[n2] <= 0) continue;
            n6 = n2;
            break;
        }
        if (n6 < 255) {
            ++n6;
        }
        for (n2 = 0; n2 < 256; ++n2) {
            if (nArray[n2] <= n4) continue;
            n5 = n2;
            n4 = nArray[n2];
        }
        n2 = 0;
        if (n5 - n3 < n6 - n5) {
            n2 = 1;
            int n7 = 0;
            for (int i = 255; n7 < i; ++n7, --i) {
                int n8 = nArray[n7];
                nArray[n7] = nArray[i];
                nArray[i] = n8;
            }
            n3 = 255 - n6;
            n5 = 255 - n5;
        }
        if (n3 == n5) {
            return n3;
        }
        double d = nArray[n5];
        double d2 = n3 - n5;
        double d3 = Math.sqrt(d * d + d2 * d2);
        d /= d3;
        d2 /= d3;
        d3 = d * (double)n3 + d2 * (double)nArray[n3];
        int n9 = n3;
        double d4 = 0.0;
        for (n = n3 + 1; n <= n5; ++n) {
            double d5 = d * (double)n + d2 * (double)nArray[n] - d3;
            if (!(d5 > d4)) continue;
            n9 = n;
            d4 = d5;
        }
        --n9;
        if (n2 != 0) {
            n = 0;
            for (int i = 255; n < i; ++n, --i) {
                int n10 = nArray[n];
                nArray[n] = nArray[i];
                nArray[i] = n10;
            }
            return 255 - n9;
        }
        return n9;
    }

    int Yen(int[] nArray) {
        int n;
        double[] dArray = new double[256];
        double[] dArray2 = new double[256];
        double[] dArray3 = new double[256];
        double[] dArray4 = new double[256];
        double d = 0.0;
        for (n = 0; n < 256; ++n) {
            d += (double)nArray[n];
        }
        for (n = 0; n < 256; ++n) {
            dArray[n] = (double)nArray[n] / d;
        }
        dArray2[0] = dArray[0];
        for (n = 1; n < 256; ++n) {
            dArray2[n] = dArray2[n - 1] + dArray[n];
        }
        dArray3[0] = dArray[0] * dArray[0];
        for (n = 1; n < 256; ++n) {
            dArray3[n] = dArray3[n - 1] + dArray[n] * dArray[n];
        }
        dArray4[255] = 0.0;
        for (n = 254; n >= 0; --n) {
            dArray4[n] = dArray4[n + 1] + dArray[n + 1] * dArray[n + 1];
        }
        int n2 = -1;
        double d2 = Double.MIN_VALUE;
        for (int i = 0; i < 256; ++i) {
            double d3 = -1.0 * (dArray3[i] * dArray4[i] > 0.0 ? Math.log(dArray3[i] * dArray4[i]) : 0.0) + 2.0 * (dArray2[i] * (1.0 - dArray2[i]) > 0.0 ? Math.log(dArray2[i] * (1.0 - dArray2[i])) : 0.0);
            if (!(d3 > d2)) continue;
            d2 = d3;
            n2 = i;
        }
        return n2;
    }

    public static enum Method {
        Default,
        Huang,
        Intermodes,
        IsoData,
        IJ_IsoData,
        Li,
        MaxEntropy,
        Mean,
        MinError,
        Minimum,
        Moments,
        Otsu,
        Percentile,
        RenyiEntropy,
        Shanbhag,
        Triangle,
        Yen;

    }
}

