/*
 * Decompiled with CFR 0.152.
 */
package ij.process;

import ij.measure.Calibration;
import ij.process.ColorProcessor;
import ij.process.ImageProcessor;
import ij.process.ImageStatistics;

public class ColorStatistics
extends ImageStatistics {
    public ColorStatistics(ImageProcessor imageProcessor) {
        this(imageProcessor, 27, null);
    }

    public ColorStatistics(ImageProcessor imageProcessor, int n, Calibration calibration) {
        ColorProcessor colorProcessor = (ColorProcessor)imageProcessor;
        this.histogram = colorProcessor.getHistogram();
        this.setup(imageProcessor, calibration);
        this.getRawStatistics(0, 255);
        if ((n & 0x10) != 0) {
            this.getRawMinAndMax(0, 255);
        }
        if ((n & 0x800) != 0 || (n & 0x2000) != 0) {
            this.fitEllipse(imageProcessor, n);
        } else if ((n & 0x20) != 0) {
            this.getCentroid(imageProcessor);
        }
        if ((n & 0x60040) != 0) {
            this.calculateMoments(imageProcessor);
        }
        if ((n & 0x10000) != 0) {
            this.calculateMedian(this.histogram, 0, 255, calibration);
        }
    }

    void calculateMoments(ImageProcessor imageProcessor) {
        byte[] byArray = imageProcessor.getMaskArray();
        double d = 0.0;
        double d2 = 0.0;
        double d3 = 0.0;
        double d4 = 0.0;
        double d5 = 0.0;
        double d6 = 0.0;
        int n = this.ry;
        int n2 = 0;
        while (n < this.ry + this.rh) {
            int n3 = n * this.width + this.rx;
            int n4 = n2 * this.rw;
            for (int i = this.rx; i < this.rx + this.rw; ++i) {
                if (byArray == null || byArray[n4++] != 0) {
                    double d7 = imageProcessor.getPixelValue(i, n);
                    double d8 = d7 * d7;
                    d += d7;
                    d2 += d8;
                    d3 += d7 * d8;
                    d4 += d8 * d8;
                    d5 += (double)i * d7;
                    d6 += (double)n * d7;
                }
                ++n3;
            }
            ++n;
            ++n2;
        }
        double d9 = this.mean * this.mean;
        double d10 = d2 / (double)this.pixelCount - d9;
        double d11 = Math.sqrt(d10);
        this.skewness = ((d3 - 3.0 * this.mean * d2) / (double)this.pixelCount + 2.0 * this.mean * d9) / (d10 * d11);
        this.kurtosis = ((d4 - 4.0 * this.mean * d3 + 6.0 * d9 * d2) / (double)this.pixelCount - 3.0 * d9 * d9) / (d10 * d10) - 3.0;
        this.xCenterOfMass = d5 / d + 0.5;
        this.yCenterOfMass = d6 / d + 0.5;
        if (this.cal != null) {
            this.xCenterOfMass = this.cal.getX(this.xCenterOfMass);
            this.yCenterOfMass = this.cal.getY(this.yCenterOfMass, this.height);
        }
    }
}

