/*
 * Decompiled with CFR 0.152.
 */
package ij.process;

import ij.process.ImageProcessor;
import java.util.Arrays;

public class DownsizeTable {
    public final int kernelSize;
    public final int srcStart;
    public final int srcEnd;
    public final int[] indices;
    public final float[] weights;
    private static final int[] kernelSizes = new int[]{1, 2, 4};
    private final int srcOrigin;
    private final int srcLength;
    private final double scale;
    private final int interpolationMethod;
    private static final int UNUSED = -1;

    DownsizeTable(int n, int n2, int n3, int n4, int n5) {
        int n6;
        this.srcOrigin = n2;
        this.srcLength = n3;
        this.interpolationMethod = n5;
        this.scale = (double)n3 / (double)n4;
        this.kernelSize = kernelSizes[n5];
        int n7 = (int)Math.ceil(1.0E-8 + this.srcIndex(-0.5 * (double)this.kernelSize));
        this.srcStart = n7 < 0 ? 0 : n7;
        int n8 = (int)Math.floor(1.0E-8 + this.srcIndex((double)(n4 - 1) + 0.5 * (double)this.kernelSize));
        this.srcEnd = n8 >= n ? n - 1 : n8;
        int n9 = (this.srcEnd - this.srcStart + 1) * this.kernelSize;
        this.indices = new int[n9];
        this.weights = new float[n9];
        Arrays.fill(this.indices, -1);
        for (n6 = 0; n6 < n4; ++n6) {
            int n10;
            int n11;
            int n12;
            double d = 0.0;
            int n13 = (int)Math.ceil(1.0E-8 + this.srcIndex((double)n6 - 0.5 * (double)this.kernelSize));
            int n14 = (int)Math.floor(-1.0E-8 + this.srcIndex((double)n6 + 0.5 * (double)this.kernelSize));
            for (n12 = n13; n12 <= n14; ++n12) {
                n11 = n12 < 0 ? 0 : (n12 >= n ? n - 1 : n12);
                n10 = (n11 - this.srcStart) * this.kernelSize;
                while (this.indices[n10] != -1 && this.indices[n10] != n6) {
                    ++n10;
                }
                this.indices[n10] = n6;
                float f = this.kernel((double)n6 - this.dstIndex(n12));
                d += (double)f;
                int n15 = n10;
                this.weights[n15] = this.weights[n15] + f;
            }
            n12 = (n13 - this.srcStart) * this.kernelSize;
            if (n12 < 0) {
                n12 = 0;
            }
            if ((n11 = (n14 - this.srcStart) * this.kernelSize + (this.kernelSize - 1)) >= this.indices.length) {
                n11 = this.indices.length - 1;
            }
            for (n10 = n12; n10 <= n11; ++n10) {
                if (this.indices[n10] != n6) continue;
                this.weights[n10] = (float)((double)this.weights[n10] / d);
            }
        }
        for (n6 = 0; n6 < this.indices.length; ++n6) {
            if (this.indices[n6] != -1) continue;
            this.indices[n6] = 0;
        }
    }

    private double srcIndex(double d) {
        return (double)this.srcOrigin - 0.5 + (d + 0.5) * this.scale;
    }

    private double dstIndex(int n) {
        return ((double)(n - this.srcOrigin) + 0.5) / this.scale - 0.5;
    }

    protected float kernel(double d) {
        switch (this.interpolationMethod) {
            case 0: {
                return 1.0f;
            }
            case 1: {
                return 1.0f - (float)Math.abs(d);
            }
            case 2: {
                return (float)ImageProcessor.cubic(d);
            }
        }
        return Float.NaN;
    }
}

