/*
 * Decompiled with CFR 0.152.
 */
package ij.process;

import ij.IJ;
import ij.ImagePlus;
import ij.ImageStack;
import ij.plugin.ContrastEnhancer;
import ij.plugin.FFT;
import ij.process.ByteProcessor;
import ij.process.ColorProcessor;
import ij.process.FloatProcessor;
import ij.process.ImageProcessor;
import java.awt.image.ColorModel;

public class FHT
extends FloatProcessor {
    private boolean isFrequencyDomain;
    private int maxN;
    private float[] C;
    private float[] S;
    private int[] bitrev;
    private float[] tempArr;
    private boolean showProgress = true;
    public boolean quadrantSwapNeeded;
    public ColorProcessor rgb;
    public int originalWidth;
    public int originalHeight;
    public int originalBitDepth;
    public ColorModel originalColorModel;

    public FHT(ImageProcessor imageProcessor) {
        super(imageProcessor.getWidth(), imageProcessor.getHeight(), (float[])(imageProcessor instanceof FloatProcessor ? imageProcessor.duplicate().getPixels() : imageProcessor.convertToFloat().getPixels()), null);
        this.maxN = this.getWidth();
        this.resetRoi();
    }

    public FHT() {
        super(8, 8);
    }

    public boolean powerOf2Size() {
        int n;
        for (n = 2; n < this.width; n *= 2) {
        }
        return n == this.width && this.width == this.height;
    }

    public void transform() {
        this.transform(false);
    }

    public void inverseTransform() {
        this.transform(true);
    }

    void transform(boolean bl) {
        if (!this.powerOf2Size()) {
            throw new IllegalArgumentException("Image not power of 2 size or not square: " + this.width + "x" + this.height);
        }
        this.maxN = this.width;
        if (this.S == null) {
            this.initializeTables(this.maxN);
        }
        float[] fArray = (float[])this.getPixels();
        this.rc2DFHT(fArray, bl, this.maxN);
        this.isFrequencyDomain = !bl;
    }

    void initializeTables(int n) {
        this.makeSinCosTables(n);
        this.makeBitReverseTable(n);
        this.tempArr = new float[n];
    }

    void makeSinCosTables(int n) {
        int n2 = n / 4;
        this.C = new float[n2];
        this.S = new float[n2];
        double d = 0.0;
        double d2 = Math.PI * 2 / (double)n;
        for (int i = 0; i < n2; ++i) {
            this.C[i] = (float)Math.cos(d);
            this.S[i] = (float)Math.sin(d);
            d += d2;
        }
    }

    void makeBitReverseTable(int n) {
        this.bitrev = new int[n];
        int n2 = this.log2(n);
        for (int i = 0; i < n; ++i) {
            this.bitrev[i] = this.bitRevX(i, n2);
        }
    }

    public void rc2DFHT(float[] fArray, boolean bl, int n) {
        int n2;
        if (this.S == null) {
            this.initializeTables(n);
        }
        for (n2 = 0; n2 < n; ++n2) {
            this.dfht3(fArray, n2 * n, bl, n);
        }
        this.progress(0.4);
        this.transposeR(fArray, n);
        this.progress(0.5);
        for (n2 = 0; n2 < n; ++n2) {
            this.dfht3(fArray, n2 * n, bl, n);
        }
        this.progress(0.7);
        this.transposeR(fArray, n);
        this.progress(0.8);
        for (int i = 0; i <= n / 2; ++i) {
            for (int j = 0; j <= n / 2; ++j) {
                n2 = (n - i) % n;
                int n3 = (n - j) % n;
                float f = fArray[i * n + j];
                float f2 = fArray[n2 * n + j];
                float f3 = fArray[i * n + n3];
                float f4 = fArray[n2 * n + n3];
                float f5 = (f + f4 - (f2 + f3)) / 2.0f;
                fArray[i * n + j] = f - f5;
                fArray[n2 * n + j] = f2 + f5;
                fArray[i * n + n3] = f3 + f5;
                fArray[n2 * n + n3] = f4 - f5;
            }
        }
        this.progress(0.95);
    }

    void progress(double d) {
        if (this.showProgress) {
            IJ.showProgress(d);
        }
    }

    public void dfht3(float[] fArray, int n, boolean bl, int n2) {
        float f;
        float f2;
        int n3;
        int n4;
        int n5;
        int n6;
        int n7;
        if (this.S == null) {
            this.initializeTables(n2);
        }
        int n8 = this.log2(n2);
        this.BitRevRArr(fArray, n, n8, n2);
        int n9 = 2;
        int n10 = n2 / 4;
        for (n7 = 0; n7 < n10; ++n7) {
            n6 = n7 * 4;
            n5 = n6 + 1;
            n4 = n6 + n9;
            n3 = n5 + n9;
            f2 = fArray[n + n6] + fArray[n + n5];
            f = fArray[n + n6] - fArray[n + n5];
            float f3 = fArray[n + n4] + fArray[n + n3];
            float f4 = fArray[n + n4] - fArray[n + n3];
            fArray[n + n6] = f2 + f3;
            fArray[n + n5] = f + f4;
            fArray[n + n4] = f2 - f3;
            fArray[n + n3] = f - f4;
        }
        if (n8 > 2) {
            n9 = 4;
            int n11 = 2;
            n10 /= 2;
            for (int i = 2; i < n8; ++i) {
                for (n7 = 0; n7 < n10; ++n7) {
                    int n12;
                    n6 = n12 = n7 * n9 * 2;
                    n5 = n6 + n9;
                    n4 = n6 + n9 / 2;
                    n3 = n4 + n9;
                    f2 = fArray[n + n6];
                    fArray[n + n6] = fArray[n + n6] + fArray[n + n5];
                    fArray[n + n5] = f2 - fArray[n + n5];
                    f2 = fArray[n + n4];
                    fArray[n + n4] = fArray[n + n4] + fArray[n + n3];
                    fArray[n + n3] = f2 - fArray[n + n3];
                    for (int j = 1; j < n11; ++j) {
                        n6 = j + n12;
                        n5 = n6 + n9;
                        n4 = n9 - j + n12;
                        n3 = n4 + n9;
                        int n13 = j * n10;
                        f2 = fArray[n + n5] * this.C[n13] + fArray[n + n3] * this.S[n13];
                        f = fArray[n + n3] * this.C[n13] - fArray[n + n5] * this.S[n13];
                        fArray[n + n5] = fArray[n + n6] - f2;
                        fArray[n + n6] = fArray[n + n6] + f2;
                        fArray[n + n3] = fArray[n + n4] + f;
                        fArray[n + n4] = fArray[n + n4] - f;
                    }
                }
                n9 *= 2;
                n11 *= 2;
                n10 /= 2;
            }
        }
        if (bl) {
            for (int i = 0; i < n2; ++i) {
                fArray[n + i] = fArray[n + i] / (float)n2;
            }
        }
    }

    void transposeR(float[] fArray, int n) {
        for (int i = 0; i < n; ++i) {
            for (int j = i; j < n; ++j) {
                if (i == j) continue;
                float f = fArray[i * n + j];
                fArray[i * n + j] = fArray[j * n + i];
                fArray[j * n + i] = f;
            }
        }
    }

    int log2(int n) {
        int n2 = 15;
        while (!this.btst(n, n2)) {
            --n2;
        }
        return n2;
    }

    private boolean btst(int n, int n2) {
        return (n & 1 << n2) != 0;
    }

    void BitRevRArr(float[] fArray, int n, int n2, int n3) {
        int n4;
        for (n4 = 0; n4 < n3; ++n4) {
            this.tempArr[n4] = fArray[n + this.bitrev[n4]];
        }
        for (n4 = 0; n4 < n3; ++n4) {
            fArray[n + n4] = this.tempArr[n4];
        }
    }

    private int bitRevX(int n, int n2) {
        int n3 = 0;
        for (int i = 0; i <= n2; ++i) {
            if ((n & 1 << i) == 0) continue;
            n3 |= 1 << n2 - i - 1;
        }
        return n3 & 0xFFFF;
    }

    private int bset(int n, int n2) {
        return n |= 1 << n2;
    }

    public ImageProcessor getPowerSpectrum() {
        ImagePlus imagePlus;
        float f;
        int n;
        int n2;
        int n3;
        if (!this.isFrequencyDomain) {
            throw new IllegalArgumentException("Frequency domain image required");
        }
        float f2 = Float.MAX_VALUE;
        float f3 = Float.MIN_VALUE;
        float[] fArray = new float[this.maxN * this.maxN];
        byte[] byArray = new byte[this.maxN * this.maxN];
        float[] fArray2 = (float[])this.getPixels();
        for (n3 = 0; n3 < this.maxN; ++n3) {
            this.FHTps(n3, this.maxN, fArray2, fArray);
            n2 = n3 * this.maxN;
            for (n = 0; n < this.maxN; ++n) {
                f = fArray[n2 + n];
                if (f < f2) {
                    f2 = f;
                }
                if (!(f > f3)) continue;
                f3 = f;
            }
        }
        f2 = (double)f2 < 1.0 ? 0.0f : (float)Math.log(f2);
        f3 = (float)Math.log(f3);
        float f4 = (float)(253.0 / (double)(f3 - f2));
        for (n3 = 0; n3 < this.maxN; ++n3) {
            n2 = n3 * this.maxN;
            for (n = 0; n < this.maxN; ++n) {
                f = fArray[n2 + n];
                f = f < 1.0f ? 0.0f : (float)Math.log(f);
                byArray[n2 + n] = (byte)((double)((f - f2) * f4) + 0.5 + 1.0);
            }
        }
        ByteProcessor byteProcessor = new ByteProcessor(this.maxN, this.maxN, byArray, null);
        this.swapQuadrants(byteProcessor);
        if (FFT.displayRawPS) {
            FloatProcessor floatProcessor = new FloatProcessor(this.maxN, this.maxN, fArray, null);
            this.swapQuadrants(floatProcessor);
            new ImagePlus("PS of " + FFT.fileName, floatProcessor).show();
        }
        if (FFT.displayFHT) {
            FloatProcessor floatProcessor = new FloatProcessor(this.maxN, this.maxN, fArray2, null);
            imagePlus = new ImagePlus("FHT of " + FFT.fileName, ((ImageProcessor)floatProcessor).duplicate());
            new ContrastEnhancer().stretchHistogram(imagePlus, 0.1);
            imagePlus.show();
        }
        if (FFT.displayComplex) {
            ImageStack imageStack = this.getComplexTransform();
            imagePlus = new ImagePlus("Complex of " + FFT.fileName, imageStack);
            new ContrastEnhancer().stretchHistogram(imagePlus, 0.1);
            imagePlus.setProperty("FFT width", "" + this.originalWidth);
            imagePlus.setProperty("FFT height", "" + this.originalHeight);
            imagePlus.show();
        }
        return byteProcessor;
    }

    void FHTps(int n, int n2, float[] fArray, float[] fArray2) {
        int n3 = n * n2;
        for (int i = 0; i < n2; ++i) {
            int n4 = (n2 - n) % n2 * n2 + (n2 - i) % n2;
            fArray2[n3 + i] = (this.sqr(fArray[n3 + i]) + this.sqr(fArray[n4])) / 2.0f;
        }
    }

    public ImageStack getComplexTransform() {
        if (!this.isFrequencyDomain) {
            throw new IllegalArgumentException("Frequency domain image required");
        }
        float[] fArray = (float[])this.getPixels();
        float[] fArray2 = new float[this.maxN * this.maxN];
        float[] fArray3 = new float[this.maxN * this.maxN];
        for (int i = 0; i < this.maxN; ++i) {
            this.FHTreal(i, this.maxN, fArray, fArray2);
            this.FHTimag(i, this.maxN, fArray, fArray3);
        }
        this.swapQuadrants(new FloatProcessor(this.maxN, this.maxN, fArray2, null));
        this.swapQuadrants(new FloatProcessor(this.maxN, this.maxN, fArray3, null));
        ImageStack imageStack = new ImageStack(this.maxN, this.maxN);
        imageStack.addSlice("Real", fArray2);
        imageStack.addSlice("Imaginary", fArray3);
        return imageStack;
    }

    void FHTreal(int n, int n2, float[] fArray, float[] fArray2) {
        int n3 = n * n2;
        int n4 = (n2 - n) % n2 * n2;
        for (int i = 0; i < n2; ++i) {
            fArray2[n3 + i] = (fArray[n3 + i] + fArray[n4 + (n2 - i) % n2]) * 0.5f;
        }
    }

    void FHTimag(int n, int n2, float[] fArray, float[] fArray2) {
        int n3 = n * n2;
        int n4 = (n2 - n) % n2 * n2;
        for (int i = 0; i < n2; ++i) {
            fArray2[n3 + i] = (-fArray[n3 + i] + fArray[n4 + (n2 - i) % n2]) * 0.5f;
        }
    }

    ImageProcessor calculateAmplitude(float[] fArray, int n) {
        float[] fArray2 = new float[n * n];
        for (int i = 0; i < n; ++i) {
            this.amplitude(i, n, fArray, fArray2);
        }
        FloatProcessor floatProcessor = new FloatProcessor(n, n, fArray2, null);
        this.swapQuadrants(floatProcessor);
        return floatProcessor;
    }

    void amplitude(int n, int n2, float[] fArray, float[] fArray2) {
        int n3 = n * n2;
        for (int i = 0; i < n2; ++i) {
            int n4 = (n2 - n) % n2 * n2 + (n2 - i) % n2;
            fArray2[n3 + i] = (float)Math.sqrt(this.sqr(fArray[n3 + i]) + this.sqr(fArray[n4]));
        }
    }

    float sqr(float f) {
        return f * f;
    }

    public void swapQuadrants(ImageProcessor imageProcessor) {
        int n = imageProcessor.getWidth() / 2;
        imageProcessor.setRoi(n, 0, n, n);
        ImageProcessor imageProcessor2 = imageProcessor.crop();
        imageProcessor.setRoi(0, n, n, n);
        ImageProcessor imageProcessor3 = imageProcessor.crop();
        imageProcessor.insert(imageProcessor2, 0, n);
        imageProcessor.insert(imageProcessor3, n, 0);
        imageProcessor.setRoi(0, 0, n, n);
        imageProcessor2 = imageProcessor.crop();
        imageProcessor.setRoi(n, n, n, n);
        imageProcessor3 = imageProcessor.crop();
        imageProcessor.insert(imageProcessor2, n, n);
        imageProcessor.insert(imageProcessor3, 0, 0);
        imageProcessor.resetRoi();
    }

    public void swapQuadrants() {
        this.swapQuadrants(this);
    }

    void changeValues(ImageProcessor imageProcessor, int n, int n2, int n3) {
        byte[] byArray = (byte[])imageProcessor.getPixels();
        for (int i = 0; i < byArray.length; ++i) {
            int n4 = byArray[i] & 0xFF;
            if (n4 < n || n4 > n2) continue;
            byArray[i] = (byte)n3;
        }
    }

    public FHT multiply(FHT fHT) {
        return this.multiply(fHT, false);
    }

    public FHT conjugateMultiply(FHT fHT) {
        return this.multiply(fHT, true);
    }

    FHT multiply(FHT fHT, boolean bl) {
        float[] fArray = (float[])this.getPixels();
        float[] fArray2 = (float[])fHT.getPixels();
        float[] fArray3 = new float[this.maxN * this.maxN];
        for (int i = 0; i < this.maxN; ++i) {
            int n = (this.maxN - i) % this.maxN;
            for (int j = 0; j < this.maxN; ++j) {
                int n2 = (this.maxN - j) % this.maxN;
                double d = (fArray2[i * this.maxN + j] + fArray2[n * this.maxN + n2]) / 2.0f;
                double d2 = (fArray2[i * this.maxN + j] - fArray2[n * this.maxN + n2]) / 2.0f;
                fArray3[i * this.maxN + j] = bl ? (float)((double)fArray[i * this.maxN + j] * d - (double)fArray[n * this.maxN + n2] * d2) : (float)((double)fArray[i * this.maxN + j] * d + (double)fArray[n * this.maxN + n2] * d2);
            }
        }
        FHT fHT2 = new FHT(new FloatProcessor(this.maxN, this.maxN, fArray3, null));
        fHT2.isFrequencyDomain = true;
        return fHT2;
    }

    public FHT divide(FHT fHT) {
        float[] fArray = (float[])this.getPixels();
        float[] fArray2 = (float[])fHT.getPixels();
        float[] fArray3 = new float[this.maxN * this.maxN];
        for (int i = 0; i < this.maxN; ++i) {
            int n = (this.maxN - i) % this.maxN;
            for (int j = 0; j < this.maxN; ++j) {
                int n2 = (this.maxN - j) % this.maxN;
                double d = fArray2[i * this.maxN + j] * fArray2[i * this.maxN + j] + fArray2[n * this.maxN + n2] * fArray2[n * this.maxN + n2];
                if (d < 1.0E-20) {
                    d = 1.0E-20;
                }
                double d2 = fArray2[i * this.maxN + j] + fArray2[n * this.maxN + n2];
                double d3 = fArray2[i * this.maxN + j] - fArray2[n * this.maxN + n2];
                double d4 = (double)fArray[i * this.maxN + j] * d2 - (double)fArray[n * this.maxN + n2] * d3;
                fArray3[i * this.maxN + j] = (float)(d4 / d);
            }
        }
        FHT fHT2 = new FHT(new FloatProcessor(this.maxN, this.maxN, fArray3, null));
        fHT2.isFrequencyDomain = true;
        return fHT2;
    }

    public void setShowProgress(boolean bl) {
        this.showProgress = bl;
    }

    public FHT getCopy() {
        ImageProcessor imageProcessor = super.duplicate();
        FHT fHT = new FHT(imageProcessor);
        fHT.isFrequencyDomain = this.isFrequencyDomain;
        fHT.quadrantSwapNeeded = this.quadrantSwapNeeded;
        fHT.rgb = this.rgb;
        fHT.originalWidth = this.originalWidth;
        fHT.originalHeight = this.originalHeight;
        fHT.originalBitDepth = this.originalBitDepth;
        fHT.originalColorModel = this.originalColorModel;
        return fHT;
    }

    @Override
    public String toString() {
        return "FHT, " + this.getWidth() + "x" + this.getHeight() + ", fd=" + this.isFrequencyDomain;
    }
}

