/*
 * Decompiled with CFR 0.152.
 */
package ij.process;

import java.awt.Rectangle;

public class FloatPolygon {
    Rectangle bounds;
    public int npoints;
    public float[] xpoints;
    public float[] ypoints;

    public FloatPolygon() {
        this.npoints = 0;
        this.xpoints = new float[10];
        this.ypoints = new float[10];
    }

    public FloatPolygon(float[] fArray, float[] fArray2, int n) {
        this.npoints = n;
        this.xpoints = fArray;
        this.ypoints = fArray2;
    }

    public boolean contains(float f, float f2) {
        boolean bl = false;
        int n = 0;
        int n2 = this.npoints - 1;
        while (n < this.npoints) {
            if (this.ypoints[n] > f2 != this.ypoints[n2] > f2 && f < (this.xpoints[n2] - this.xpoints[n]) * (f2 - this.ypoints[n]) / (this.ypoints[n2] - this.ypoints[n]) + this.xpoints[n]) {
                bl = !bl;
            }
            n2 = n++;
        }
        return bl;
    }

    public Rectangle getBounds() {
        if (this.npoints == 0) {
            return new Rectangle();
        }
        if (this.bounds == null) {
            this.calculateBounds(this.xpoints, this.ypoints, this.npoints);
        }
        return this.bounds.getBounds();
    }

    void calculateBounds(float[] fArray, float[] fArray2, int n) {
        int n2;
        float f = Float.MAX_VALUE;
        float f2 = Float.MAX_VALUE;
        float f3 = Float.MIN_VALUE;
        float f4 = Float.MIN_VALUE;
        for (n2 = 0; n2 < n; ++n2) {
            float f5 = fArray[n2];
            f = Math.min(f, f5);
            f3 = Math.max(f3, f5);
            float f6 = fArray2[n2];
            f2 = Math.min(f2, f6);
            f4 = Math.max(f4, f6);
        }
        n2 = (int)Math.floor(f);
        int n3 = (int)Math.floor(f2);
        this.bounds = new Rectangle(n2, n3, (int)((double)(f3 - (float)n2) + 0.5), (int)((double)(f4 - (float)n3) + 0.5));
    }

    public void addPoint(float f, float f2) {
        if (this.npoints == this.xpoints.length) {
            float[] fArray = new float[this.npoints * 2];
            System.arraycopy(this.xpoints, 0, fArray, 0, this.npoints);
            this.xpoints = fArray;
            fArray = new float[this.npoints * 2];
            System.arraycopy(this.ypoints, 0, fArray, 0, this.npoints);
            this.ypoints = fArray;
        }
        this.xpoints[this.npoints] = f;
        this.ypoints[this.npoints] = f2;
        ++this.npoints;
        this.bounds = null;
    }

    public void addPoint(double d, double d2) {
        this.addPoint((float)d, (float)d2);
    }
}

