/*
 * Decompiled with CFR 0.152.
 */
package ij.process;

import ij.measure.Calibration;
import ij.process.ImageProcessor;
import ij.process.ImageStatistics;

public class ShortStatistics
extends ImageStatistics {
    public ShortStatistics(ImageProcessor imageProcessor) {
        this(imageProcessor, 27, null);
    }

    public ShortStatistics(ImageProcessor imageProcessor, int n, Calibration calibration) {
        int n2;
        int n3;
        this.width = imageProcessor.getWidth();
        this.height = imageProcessor.getHeight();
        this.setup(imageProcessor, calibration);
        this.nBins = 256;
        double d = imageProcessor.getMinThreshold();
        if ((n & 0x100) == 0 || d == -808080.0) {
            n3 = 0;
            n2 = 65535;
        } else {
            n3 = (int)d;
            n2 = (int)imageProcessor.getMaxThreshold();
        }
        int[] nArray = imageProcessor.getHistogram();
        this.histogram16 = nArray;
        float[] fArray = calibration != null ? calibration.getCTable() : null;
        this.getRawMinAndMax(nArray, n3, n2);
        this.histMin = this.min;
        this.histMax = this.max;
        this.getStatistics(imageProcessor, nArray, (int)this.min, (int)this.max, fArray);
        if ((n & 8) != 0) {
            this.getMode();
        }
        if ((n & 0x800) != 0 || (n & 0x2000) != 0) {
            this.fitEllipse(imageProcessor, n);
        } else if ((n & 0x20) != 0) {
            this.getCentroid(imageProcessor, n3, n2);
        }
        if ((n & 0x60040) != 0) {
            this.calculateMoments(imageProcessor, n3, n2, fArray);
        }
        if ((n & 0x10) != 0 && fArray != null) {
            this.getCalibratedMinAndMax(nArray, (int)this.min, (int)this.max, fArray);
        }
        if ((n & 0x10000) != 0) {
            this.calculateMedian(nArray, n3, n2, calibration);
        }
        if ((n & 0x80000) != 0) {
            this.calculateAreaFraction(imageProcessor, nArray);
        }
    }

    void getRawMinAndMax(int[] nArray, int n, int n2) {
        int n3;
        int n4;
        for (n4 = n; nArray[n4] == 0 && n4 < 65535; ++n4) {
        }
        this.min = n4;
        for (n3 = n2; nArray[n3] == 0 && n3 > 0; --n3) {
        }
        this.max = n3;
    }

    void getStatistics(ImageProcessor imageProcessor, int[] nArray, int n, int n2, float[] fArray) {
        double d = 0.0;
        double d2 = 0.0;
        this.nBins = imageProcessor.getHistogramSize();
        this.histMin = imageProcessor.getHistogramMin();
        this.histMax = imageProcessor.getHistogramMax();
        if (this.histMin == 0.0 && this.histMax == 0.0) {
            this.histMin = n;
            this.histMax = n2;
        } else {
            if ((double)n < this.histMin) {
                n = (int)this.histMin;
            }
            if ((double)n2 > this.histMax) {
                n2 = (int)this.histMax;
            }
        }
        this.binSize = (this.histMax - this.histMin) / (double)this.nBins;
        double d3 = 1.0 / this.binSize;
        int n3 = (int)this.histMin;
        this.histogram = new int[this.nBins];
        int n4 = 0;
        for (int i = n; i <= n2; ++i) {
            int n5 = nArray[i];
            if (n5 > n4) {
                n4 = n5;
                this.dmode = i;
            }
            this.pixelCount += n5;
            double d4 = fArray == null ? (double)i : (double)fArray[i];
            d += d4 * (double)n5;
            d2 += d4 * d4 * (double)n5;
            int n6 = (int)(d3 * (double)(i - n3));
            if (n6 >= this.nBins) {
                n6 = this.nBins - 1;
            }
            int n7 = n6;
            this.histogram[n7] = this.histogram[n7] + n5;
        }
        this.area = (double)this.pixelCount * this.pw * this.ph;
        this.umean = this.mean = d / (double)this.pixelCount;
        this.calculateStdDev(this.pixelCount, d, d2);
        if (fArray != null) {
            this.dmode = fArray[(int)this.dmode];
        }
    }

    void getMode() {
        this.maxCount = 0;
        for (int i = 0; i < this.nBins; ++i) {
            int n = this.histogram[i];
            if (n <= this.maxCount) continue;
            this.maxCount = n;
            this.mode = i;
        }
    }

    void getCentroid(ImageProcessor imageProcessor, int n, int n2) {
        short[] sArray = (short[])imageProcessor.getPixels();
        byte[] byArray = imageProcessor.getMaskArray();
        boolean bl = n > 0 || n2 < 65535;
        int n3 = 0;
        double d = 0.0;
        double d2 = 0.0;
        int n4 = this.ry;
        int n5 = 0;
        while (n4 < this.ry + this.rh) {
            int n6 = n4 * this.width + this.rx;
            int n7 = n5 * this.rw;
            for (int i = this.rx; i < this.rx + this.rw; ++i) {
                if (byArray == null || byArray[n7++] != 0) {
                    if (bl) {
                        int n8 = sArray[n6] & 0xFFFF;
                        if (n8 >= n && n8 <= n2) {
                            ++n3;
                            d += (double)i;
                            d2 += (double)n4;
                        }
                    } else {
                        ++n3;
                        d += (double)i;
                        d2 += (double)n4;
                    }
                }
                ++n6;
            }
            ++n4;
            ++n5;
        }
        this.xCentroid = d / (double)n3 + 0.5;
        this.yCentroid = d2 / (double)n3 + 0.5;
        if (this.cal != null) {
            this.xCentroid = this.cal.getX(this.xCentroid);
            this.yCentroid = this.cal.getY(this.yCentroid, this.height);
        }
    }

    void calculateMoments(ImageProcessor imageProcessor, int n, int n2, float[] fArray) {
        short[] sArray = (short[])imageProcessor.getPixels();
        byte[] byArray = imageProcessor.getMaskArray();
        double d = 0.0;
        double d2 = 0.0;
        double d3 = 0.0;
        double d4 = 0.0;
        double d5 = 0.0;
        double d6 = 0.0;
        int n3 = this.ry;
        int n4 = 0;
        while (n3 < this.ry + this.rh) {
            int n5 = n3 * this.width + this.rx;
            int n6 = n4 * this.rw;
            for (int i = this.rx; i < this.rx + this.rw; ++i) {
                int n7;
                if ((byArray == null || byArray[n6++] != 0) && (n7 = sArray[n5] & 0xFFFF) >= n && n7 <= n2) {
                    double d7 = fArray != null ? (double)fArray[n7] : (double)n7;
                    double d8 = d7 * d7;
                    d += d7;
                    d2 += d8;
                    d3 += d7 * d8;
                    d4 += d8 * d8;
                    d5 += (double)i * d7;
                    d6 += (double)n3 * d7;
                }
                ++n5;
            }
            ++n3;
            ++n4;
        }
        double d9 = this.mean * this.mean;
        double d10 = d2 / (double)this.pixelCount - d9;
        double d11 = Math.sqrt(d10);
        this.skewness = ((d3 - 3.0 * this.mean * d2) / (double)this.pixelCount + 2.0 * this.mean * d9) / (d10 * d11);
        this.kurtosis = ((d4 - 4.0 * this.mean * d3 + 6.0 * d9 * d2) / (double)this.pixelCount - 3.0 * d9 * d9) / (d10 * d10) - 3.0;
        this.xCenterOfMass = d5 / d + 0.5;
        this.yCenterOfMass = d6 / d + 0.5;
        if (this.cal != null) {
            this.xCenterOfMass = this.cal.getX(this.xCenterOfMass);
            this.yCenterOfMass = this.cal.getY(this.yCenterOfMass, this.height);
        }
    }

    void getCalibratedMinAndMax(int[] nArray, int n, int n2, float[] fArray) {
        this.min = Double.MAX_VALUE;
        this.max = -1.7976931348623157E308;
        double d = 0.0;
        for (int i = n; i <= n2; ++i) {
            if (nArray[i] <= 0) continue;
            d = fArray[i];
            if (d < this.min) {
                this.min = d;
            }
            if (!(d > this.max)) continue;
            this.max = d;
        }
    }
}

