/*
 * Decompiled with CFR 0.152.
 */
package ec;

import ec.Breeder;
import ec.Evaluator;
import ec.Exchanger;
import ec.Finisher;
import ec.Initializer;
import ec.Population;
import ec.Singleton;
import ec.Statistics;
import ec.util.MersenneTwisterFast;
import ec.util.Output;
import ec.util.Parameter;
import ec.util.ParameterDatabase;
import java.io.IOException;

public class EvolutionState
implements Singleton {
    public ParameterDatabase parameters;
    public MersenneTwisterFast[] random;
    public Output output;
    public int breedthreads;
    public int evalthreads;
    public boolean checkpoint;
    public String checkpointPrefix;
    public int checkpointModulo;
    public int randomSeedOffset;
    public boolean quitOnRunComplete;
    public Object[] job;
    public String[] runtimeArguments;
    public int generation;
    public int numGenerations;
    public Population population;
    public Initializer initializer;
    public Finisher finisher;
    public Breeder breeder;
    public Evaluator evaluator;
    public Statistics statistics;
    public Exchanger exchanger;
    public static final int C_STARTED_FRESH = 0;
    public static final int C_STARTED_FROM_CHECKPOINT = 1;
    public static final int R_SUCCESS = 0;
    public static final int R_FAILURE = 1;
    public static final int R_NOTDONE = 2;
    public static final String P_INITIALIZER = "init";
    public static final String P_FINISHER = "finish";
    public static final String P_BREEDER = "breed";
    public static final String P_EVALUATOR = "eval";
    public static final String P_STATISTICS = "stat";
    public static final String P_EXCHANGER = "exch";
    public static final String P_GENERATIONS = "generations";
    public static final String P_QUITONRUNCOMPLETE = "quit-on-run-complete";
    public static final String P_CHECKPOINTPREFIX = "prefix";
    public static final String P_CHECKPOINTMODULO = "checkpoint-modulo";
    public static final String P_CHECKPOINT = "checkpoint";

    public void setup(EvolutionState state, Parameter base) {
        Parameter p = new Parameter(P_CHECKPOINT);
        this.checkpoint = this.parameters.getBoolean(p, null, false);
        p = new Parameter(P_CHECKPOINTPREFIX);
        this.checkpointPrefix = this.parameters.getString(p, null);
        if (this.checkpointPrefix == null) {
            this.output.fatal("No checkpoint prefix specified.", p);
        }
        p = new Parameter(P_CHECKPOINTMODULO);
        this.checkpointModulo = this.parameters.getInt(p, null, 1);
        if (this.checkpointModulo == 0) {
            this.output.fatal("The checkpoint modulo must be an integer >0.", p);
        }
        p = new Parameter(P_GENERATIONS);
        this.numGenerations = this.parameters.getInt(p, null, 1);
        if (this.numGenerations == 0) {
            this.output.fatal("The number of generations must be an integer >0.", p);
        }
        p = new Parameter(P_QUITONRUNCOMPLETE);
        this.quitOnRunComplete = this.parameters.getBoolean(p, null, false);
        p = new Parameter(P_INITIALIZER);
        this.initializer = (Initializer)this.parameters.getInstanceForParameter(p, null, Initializer.class);
        this.initializer.setup(this, p);
        p = new Parameter(P_FINISHER);
        this.finisher = (Finisher)this.parameters.getInstanceForParameter(p, null, Finisher.class);
        this.finisher.setup(this, p);
        p = new Parameter(P_BREEDER);
        this.breeder = (Breeder)this.parameters.getInstanceForParameter(p, null, Breeder.class);
        this.breeder.setup(this, p);
        p = new Parameter(P_EVALUATOR);
        this.evaluator = (Evaluator)this.parameters.getInstanceForParameter(p, null, Evaluator.class);
        this.evaluator.setup(this, p);
        p = new Parameter(P_STATISTICS);
        this.statistics = (Statistics)this.parameters.getInstanceForParameterEq(p, null, Statistics.class);
        this.statistics.setup(this, p);
        p = new Parameter(P_EXCHANGER);
        this.exchanger = (Exchanger)this.parameters.getInstanceForParameter(p, null, Exchanger.class);
        this.exchanger.setup(this, p);
        this.generation = 0;
    }

    public void resetFromCheckpoint() throws IOException {
        this.output.restart();
        this.exchanger.reinitializeContacts(this);
        this.evaluator.reinitializeContacts(this);
    }

    public void finish(int result) {
    }

    public void startFromCheckpoint() {
    }

    public void startFresh() {
    }

    public int evolve() throws InternalError {
        return 2;
    }

    public void run(int condition) {
        if (condition == 0) {
            this.startFresh();
        } else {
            this.startFromCheckpoint();
        }
        int result = 2;
        while (result == 2) {
            result = this.evolve();
        }
        this.finish(result);
    }
}

