/*
 * Decompiled with CFR 0.152.
 */
package ec;

import ec.EvolutionState;
import ec.util.Checkpoint;
import ec.util.MersenneTwisterFast;
import ec.util.Output;
import ec.util.Parameter;
import ec.util.ParameterDatabase;
import ec.util.Version;
import java.io.File;
import java.io.PrintWriter;

public class Evolve {
    public static final String P_PRINTACCESSEDPARAMETERS = "print-accessed-params";
    public static final String P_PRINTUSEDPARAMETERS = "print-used-params";
    public static final String P_PRINTALLPARAMETERS = "print-all-params";
    public static final String P_PRINTUNUSEDPARAMETERS = "print-unused-params";
    public static final String P_PRINTUNACCESSEDPARAMETERS = "print-unaccessed-params";
    public static final String A_CHECKPOINT = "-checkpoint";
    public static final String A_FILE = "-file";
    public static final String P_EVALTHREADS = "evalthreads";
    public static final String P_BREEDTHREADS = "breedthreads";
    public static final String P_SEED = "seed";
    public static final String V_SEED_TIME = "time";
    public static final String P_STATE = "state";
    public static final String V_THREADS_AUTO = "auto";

    public static EvolutionState possiblyRestoreFromCheckpoint(String[] args) {
        for (int x = 0; x < args.length - 1; ++x) {
            if (!args[x].equals(A_CHECKPOINT)) continue;
            System.err.println("Restoring from Checkpoint " + args[x + 1]);
            try {
                return Checkpoint.restoreFromCheckpoint(args[x + 1]);
            }
            catch (Exception e) {
                Output.initialError("An exception was generated upon starting up from a checkpoint.\nHere it is:\n" + e);
            }
        }
        return null;
    }

    public static ParameterDatabase loadParameterDatabase(String[] args) {
        ParameterDatabase parameters = null;
        for (int x = 0; x < args.length - 1; ++x) {
            if (!args[x].equals(A_FILE)) continue;
            try {
                parameters = new ParameterDatabase(new File(new File(args[x + 1]).getAbsolutePath()), args);
                break;
            }
            catch (Exception e) {
                Output.initialError("An exception was generated upon reading the parameter file \"" + args[x + 1] + "\".\nHere it is:\n" + e);
            }
        }
        if (parameters == null) {
            Output.initialError("No parameter file was specified.");
        }
        return parameters;
    }

    public static int determineThreads(Output output, ParameterDatabase parameters, Parameter threadParameter) {
        int thread;
        block7: {
            thread = 1;
            String tmp_s = parameters.getString(threadParameter, null);
            if (tmp_s == null) {
                output.fatal("Threads number must exist.", threadParameter, null);
            } else {
                if (V_THREADS_AUTO.equalsIgnoreCase(tmp_s)) {
                    Runtime runtime = Runtime.getRuntime();
                    try {
                        return (Integer)runtime.getClass().getMethod("availableProcessors", null).invoke((Object)runtime, (Object[])null);
                    }
                    catch (Exception e) {
                        output.fatal("Whoa! This Java version is too old to have the Runtime.availableProcessors() method available.\nThis means you can't use 'auto' as a threads option.", threadParameter, null);
                        break block7;
                    }
                }
                try {
                    thread = parameters.getInt(threadParameter, null);
                }
                catch (NumberFormatException e) {
                    output.fatal("Invalid, non-integer threads value (" + thread + ")", threadParameter, null);
                }
            }
        }
        return thread;
    }

    public static MersenneTwisterFast primeGenerator(MersenneTwisterFast generator) {
        for (int i = 0; i < 1248; ++i) {
            generator.nextInt();
        }
        return generator;
    }

    public static int determineSeed(Output output, ParameterDatabase parameters, Parameter seedParameter, long currentTime, int offset, boolean auto) {
        int seed = 1;
        String tmp_s = parameters.getString(seedParameter, null);
        if (tmp_s == null && !auto) {
            output.fatal("Seed must exist.", seedParameter, null);
        } else if (V_SEED_TIME.equalsIgnoreCase(tmp_s) || tmp_s == null && auto) {
            if (tmp_s == null && auto) {
                output.warnOnce("Using automatic determination number of threads, but not all seeds are defined.\nThe rest will be defined using the wall clock time.");
            }
            if ((seed = (int)currentTime) == 0) {
                output.fatal("Whoa! This Java version is returning 0 for System.currentTimeMillis(), which ain't right.  This means you can't use 'time' as a seed ", seedParameter, null);
            }
        } else {
            try {
                seed = parameters.getInt(seedParameter, null);
            }
            catch (NumberFormatException e) {
                output.fatal("Invalid, non-integer seed value (" + seed + ")", seedParameter, null);
            }
        }
        return seed + offset;
    }

    public static EvolutionState initialize(ParameterDatabase parameters, int randomSeedOffset) {
        Output output = new Output(true);
        output.addLog(0, false);
        output.addLog(1, true);
        return Evolve.initialize(parameters, randomSeedOffset, output);
    }

    public static EvolutionState initialize(ParameterDatabase parameters, int randomSeedOffset, Output output) {
        EvolutionState state = null;
        int breedthreads = 1;
        int evalthreads = 1;
        output.systemMessage(Version.message());
        breedthreads = Evolve.determineThreads(output, parameters, new Parameter(P_BREEDTHREADS));
        evalthreads = Evolve.determineThreads(output, parameters, new Parameter(P_EVALTHREADS));
        boolean auto = V_THREADS_AUTO.equalsIgnoreCase(parameters.getString(new Parameter(P_BREEDTHREADS), null)) || V_THREADS_AUTO.equalsIgnoreCase(parameters.getString(new Parameter(P_EVALTHREADS), null));
        MersenneTwisterFast[] random = new MersenneTwisterFast[breedthreads > evalthreads ? breedthreads : evalthreads];
        int[] seeds = new int[random.length];
        String seedMessage = "Seed: ";
        int time = (int)System.currentTimeMillis();
        for (int x = 0; x < random.length; ++x) {
            seeds[x] = Evolve.determineSeed(output, parameters, new Parameter(P_SEED).push("" + x), time + x, random.length * randomSeedOffset, auto);
            for (int y = 0; y < x; ++y) {
                if (seeds[x] != seeds[y]) continue;
                output.fatal("seed." + x + " (" + seeds[x] + ") and " + P_SEED + "." + y + " (" + seeds[y] + ") ought not be the same seed.", null, null);
            }
            random[x] = Evolve.primeGenerator(new MersenneTwisterFast(seeds[x]));
            seedMessage = seedMessage + seeds[x] + " ";
        }
        state = (EvolutionState)parameters.getInstanceForParameter(new Parameter(P_STATE), null, EvolutionState.class);
        state.parameters = parameters;
        state.random = random;
        state.output = output;
        state.evalthreads = evalthreads;
        state.breedthreads = breedthreads;
        state.randomSeedOffset = randomSeedOffset;
        output.systemMessage("Threads:  breed/" + breedthreads + " eval/" + evalthreads);
        output.systemMessage(seedMessage);
        return state;
    }

    public static void cleanup(EvolutionState state) {
        state.output.flush();
        PrintWriter pw = new PrintWriter(System.err);
        state.parameters.getBoolean(new Parameter(P_PRINTUSEDPARAMETERS), null, false);
        state.parameters.getBoolean(new Parameter(P_PRINTACCESSEDPARAMETERS), null, false);
        state.parameters.getBoolean(new Parameter(P_PRINTUNUSEDPARAMETERS), null, false);
        state.parameters.getBoolean(new Parameter(P_PRINTUNACCESSEDPARAMETERS), null, false);
        state.parameters.getBoolean(new Parameter(P_PRINTALLPARAMETERS), null, false);
        if (state.parameters.getBoolean(new Parameter(P_PRINTUSEDPARAMETERS), null, false)) {
            pw.println("\n\nUsed Parameters\n===============\n");
            state.parameters.listGotten(pw);
        }
        if (state.parameters.getBoolean(new Parameter(P_PRINTACCESSEDPARAMETERS), null, false)) {
            pw.println("\n\nAccessed Parameters\n===================\n");
            state.parameters.listAccessed(pw);
        }
        if (state.parameters.getBoolean(new Parameter(P_PRINTUNUSEDPARAMETERS), null, false)) {
            pw.println("\n\nUnused Parameters\n================= (Ignore parent.x references) \n");
            state.parameters.listNotGotten(pw);
        }
        if (state.parameters.getBoolean(new Parameter(P_PRINTUNACCESSEDPARAMETERS), null, false)) {
            pw.println("\n\nUnaccessed Parameters\n===================== (Ignore parent.x references) \n");
            state.parameters.listNotAccessed(pw);
        }
        if (state.parameters.getBoolean(new Parameter(P_PRINTALLPARAMETERS), null, false)) {
            pw.println("\n\nAll Parameters\n==============\n");
            state.parameters.list(pw, false);
        }
        pw.flush();
        System.err.flush();
        System.out.flush();
        state.output.close();
    }

    public static void main(String[] args) {
        int numJobs;
        EvolutionState state = Evolve.possiblyRestoreFromCheckpoint(args);
        int currentJob = 0;
        if (state != null) {
            try {
                if (state.runtimeArguments == null) {
                    Output.initialError("Checkpoint completed from job started by foreign program (probably GUI).  Exiting...");
                }
                args = state.runtimeArguments;
                currentJob = (Integer)state.job[0] + 1;
            }
            catch (Exception e) {
                Output.initialError("EvolutionState's jobs variable is not set up properly.  Exiting...");
            }
            state.run(1);
            Evolve.cleanup(state);
        }
        ParameterDatabase parameters = Evolve.loadParameterDatabase(args);
        if (currentJob == 0) {
            currentJob = parameters.getIntWithDefault(new Parameter("current-job"), null, 0);
        }
        if (currentJob < 0) {
            Output.initialError("The 'current-job' parameter must be >= 0 (or not exist, which defaults to 0)");
        }
        if ((numJobs = parameters.getIntWithDefault(new Parameter("jobs"), null, 1)) < 1) {
            Output.initialError("The 'jobs' parameter must be >= 1 (or not exist, which defaults to 1)");
        }
        for (int job = currentJob; job < numJobs; ++job) {
            try {
                if (parameters == null) {
                    parameters = Evolve.loadParameterDatabase(args);
                }
                state = Evolve.initialize(parameters, job);
                state.output.systemMessage("Job: " + job);
                state.job = new Object[1];
                state.job[0] = new Integer(job);
                state.runtimeArguments = args;
                if (numJobs > 1) {
                    String jobFilePrefix = "job." + job + ".";
                    state.output.setFilePrefix(jobFilePrefix);
                    state.checkpointPrefix = jobFilePrefix + state.checkpointPrefix;
                }
                state.run(0);
                Evolve.cleanup(state);
                parameters = null;
                continue;
            }
            catch (Throwable e) {
                e.printStackTrace();
                state = null;
                System.gc();
            }
        }
        System.exit(0);
    }
}

