/*
 * Decompiled with CFR 0.152.
 */
package ec.app.multiplexerslow;

import ec.EvolutionState;
import ec.Individual;
import ec.app.multiplexerslow.MultiplexerData;
import ec.gp.GPIndividual;
import ec.gp.GPProblem;
import ec.gp.koza.KozaFitness;
import ec.simple.SimpleProblemForm;
import ec.util.Parameter;

public class Multiplexer
extends GPProblem
implements SimpleProblemForm {
    public static final int NUMINPUTS = 20;
    public static final String P_NUMBITS = "bits";
    public int bits;
    public int amax;
    public int dmax;
    public int addressPart;
    public int dataPart;
    public MultiplexerData input;

    public Object clone() {
        Multiplexer myobj = (Multiplexer)super.clone();
        myobj.input = (MultiplexerData)this.input.clone();
        return myobj;
    }

    public void setup(EvolutionState state, Parameter base) {
        int x;
        super.setup(state, base);
        this.bits = state.parameters.getIntWithMax(base.push(P_NUMBITS), null, 1, 3);
        if (this.bits < 1) {
            state.output.fatal("The number of bits for Multiplexer must be between 1 and 3 inclusive");
        }
        this.amax = 1;
        for (x = 0; x < this.bits; ++x) {
            this.amax *= 2;
        }
        this.dmax = 1;
        for (x = 0; x < this.amax; ++x) {
            this.dmax *= 2;
        }
        this.input = (MultiplexerData)state.parameters.getInstanceForParameterEq(base.push("data"), null, MultiplexerData.class);
        this.input.setup(state, base.push("data"));
    }

    public void evaluate(EvolutionState state, Individual ind, int subpopulation, int threadnum) {
        if (!ind.evaluated) {
            int sum = 0;
            this.addressPart = 0;
            while (this.addressPart < this.amax) {
                this.dataPart = 0;
                while (this.dataPart < this.dmax) {
                    ((GPIndividual)ind).trees[0].child.eval(state, threadnum, this.input, this.stack, (GPIndividual)ind, this);
                    sum += 1 - (this.dataPart >>> this.addressPart & 1 ^ this.input.x & 1);
                    ++this.dataPart;
                }
                ++this.addressPart;
            }
            KozaFitness f = (KozaFitness)ind.fitness;
            f.setStandardizedFitness(state, this.amax * this.dmax - sum);
            f.hits = sum;
            ind.evaluated = true;
        }
    }
}

