/*
 * Decompiled with CFR 0.152.
 */
package ec.app.regression.func;

import ec.EvolutionState;
import ec.Problem;
import ec.app.regression.RegressionData;
import ec.gp.ADFStack;
import ec.gp.ERC;
import ec.gp.GPData;
import ec.gp.GPIndividual;
import ec.gp.GPNode;
import ec.util.Code;
import ec.util.DecodeReturn;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;

public class RegERC
extends ERC {
    public double value;

    public void resetNode(EvolutionState state, int thread) {
        this.value = state.random[thread].nextDouble() * 2.0 - 1.0;
    }

    public int nodeHashCode() {
        return this.getClass().hashCode() + Float.floatToIntBits((float)this.value);
    }

    public boolean nodeEquals(GPNode node) {
        if (this.getClass() != node.getClass()) {
            return false;
        }
        return ((RegERC)node).value == this.value;
    }

    public void readNode(EvolutionState state, DataInput dataInput) throws IOException {
        this.value = dataInput.readDouble();
    }

    public void writeNode(EvolutionState state, DataOutput dataOutput) throws IOException {
        dataOutput.writeDouble(this.value);
    }

    public String encode() {
        return Code.encode(this.value);
    }

    public boolean decode(DecodeReturn dret) {
        int pos = dret.pos;
        String data = dret.data;
        Code.decode(dret);
        if (dret.type != 7) {
            dret.data = data;
            dret.pos = pos;
            return false;
        }
        this.value = dret.d;
        return true;
    }

    public String toStringForHumans() {
        return "" + (float)this.value;
    }

    public void eval(EvolutionState state, int thread, GPData input, ADFStack stack, GPIndividual individual, Problem problem) {
        RegressionData rd = (RegressionData)input;
        rd.x = this.value;
    }
}

