/*
 * Decompiled with CFR 0.152.
 */
package ec.app.sat;

import ec.EvolutionState;
import ec.Individual;
import ec.Problem;
import ec.simple.SimpleFitness;
import ec.simple.SimpleProblemForm;
import ec.util.Parameter;
import ec.vector.BitVectorIndividual;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.util.StringTokenizer;

public class SAT
extends Problem
implements SimpleProblemForm {
    public static final String P_FILENAME = "sat-filename";
    Clause[] formula;

    public void setup(EvolutionState state, Parameter base) {
        super.setup(state, base);
        String fileName = state.parameters.getString(base.push(P_FILENAME), null);
        try {
            BufferedReader inFile = new BufferedReader(new FileReader(new File(fileName)));
            String line = "";
            int cnt = 0;
            boolean start = false;
            while ((line = inFile.readLine()) != null) {
                if (start) {
                    this.formula[cnt++] = new Clause(line);
                    continue;
                }
                if (!line.startsWith("p")) continue;
                start = true;
                line.trim();
                int index = line.lastIndexOf(" ");
                this.formula = new Clause[Integer.parseInt(line.substring(index + 1))];
            }
            inFile.close();
        }
        catch (IOException e) {
            state.output.fatal("Error in SAT setup, while loading from file " + fileName + "\nFrom parameter " + base.push(P_FILENAME) + "\nError:\n" + e);
        }
    }

    public void evaluate(EvolutionState state, Individual ind, int subpopulation, int threadnum) {
        BitVectorIndividual ind2 = (BitVectorIndividual)ind;
        double fitness = 0.0;
        for (int i = 0; i < this.formula.length; ++i) {
            fitness += (double)this.formula[i].eval(ind2);
        }
        ((SimpleFitness)ind2.fitness).setFitness(state, (float)fitness, false);
        ind2.evaluated = true;
    }

    public class Clause {
        int[] variables;

        public Clause(String c) {
            StringTokenizer st = new StringTokenizer(c);
            this.variables = new int[st.countTokens() - 1];
            for (int i = 0; i < this.variables.length; ++i) {
                this.variables[i] = Integer.parseInt(st.nextToken());
            }
        }

        public int eval(BitVectorIndividual ind) {
            for (int i = 0; i < this.variables.length; ++i) {
                int x = this.variables[i];
                boolean tmp = x < 0 ? !ind.genome[-x - 1] : ind.genome[x - 1];
                if (!tmp) continue;
                return 1;
            }
            return 0;
        }
    }
}

