/*
 * Decompiled with CFR 0.152.
 */
package ec.app.tutorial4;

import ec.EvolutionState;
import ec.Individual;
import ec.app.tutorial4.DoubleData;
import ec.gp.GPIndividual;
import ec.gp.GPProblem;
import ec.gp.koza.KozaFitness;
import ec.simple.SimpleProblemForm;
import ec.util.Parameter;

public class MultiValuedRegression
extends GPProblem
implements SimpleProblemForm {
    public double currentX;
    public double currentY;
    public DoubleData input;

    public Object clone() {
        MultiValuedRegression newobj = (MultiValuedRegression)super.clone();
        newobj.input = (DoubleData)this.input.clone();
        return newobj;
    }

    public void setup(EvolutionState state, Parameter base) {
        super.setup(state, base);
        this.input = (DoubleData)state.parameters.getInstanceForParameterEq(base.push("data"), null, DoubleData.class);
        this.input.setup(state, base.push("data"));
    }

    public void evaluate(EvolutionState state, Individual ind, int subpopulation, int threadnum) {
        if (!ind.evaluated) {
            int hits = 0;
            double sum = 0.0;
            for (int y = 0; y < 10; ++y) {
                this.currentX = state.random[threadnum].nextDouble();
                this.currentY = state.random[threadnum].nextDouble();
                double expectedResult = this.currentX * this.currentX * this.currentY + this.currentX * this.currentY + this.currentY;
                ((GPIndividual)ind).trees[0].child.eval(state, threadnum, this.input, this.stack, (GPIndividual)ind, this);
                double result = Math.abs(expectedResult - this.input.x);
                if (result <= 0.01) {
                    ++hits;
                }
                sum += result;
            }
            KozaFitness f = (KozaFitness)ind.fitness;
            f.setStandardizedFitness(state, (float)sum);
            f.hits = hits;
            ind.evaluated = true;
        }
    }
}

