/*
 * Decompiled with CFR 0.152.
 */
package ec.coevolve;

import ec.Evaluator;
import ec.EvolutionState;
import ec.Individual;
import ec.Population;
import ec.SelectionMethod;
import ec.Subpopulation;
import ec.coevolve.EliteComparator;
import ec.coevolve.GroupedProblemForm;
import ec.util.Parameter;
import ec.util.QuickSort;
import ec.util.SortComparatorL;

public class MultiPopCoevolutionaryEvaluator
extends Evaluator {
    public static final String P_SUBPOP = "subpop";
    public static final String P_NUM_RAND_IND = "num-current";
    protected int numCurrent;
    public static final String P_NUM_ELITE = "num-elites";
    protected int numElite;
    Individual[][] eliteIndividuals;
    public static final String P_NUM_IND = "num-prev";
    protected int numPrev;
    Population previousPopulation;
    public static final String P_SELECTION_METHOD_PREV = "select-prev";
    SelectionMethod[] selectionMethodPrev;
    public static final String P_SELECTION_METHOD_CURRENT = "select-current";
    SelectionMethod[] selectionMethodCurrent;
    Individual[] inds = null;
    boolean[] updates = null;
    static /* synthetic */ Class class$ec$SelectionMethod;

    public void setup(EvolutionState state, Parameter base) {
        int i;
        super.setup(state, base);
        Parameter tempSubpop = new Parameter("pop").push("subpops");
        int numSubpopulations = state.parameters.getInt(tempSubpop, null, 0);
        if (numSubpopulations <= 0) {
            state.output.fatal("Parameter not found, or it has a non-positive value.", tempSubpop);
        }
        this.selectionMethodPrev = new SelectionMethod[numSubpopulations];
        this.numElite = state.parameters.getInt(base.push(P_NUM_ELITE), null, 0);
        if (this.numElite < 0) {
            state.output.fatal("Parameter not found, or it has an incorrect value.", base.push(P_NUM_ELITE));
        }
        this.numCurrent = state.parameters.getInt(base.push(P_NUM_RAND_IND), null, 0);
        this.selectionMethodCurrent = new SelectionMethod[numSubpopulations];
        if (this.numCurrent < 0) {
            state.output.fatal("Parameter not found, or it has an incorrect value.", base.push(P_NUM_RAND_IND));
        } else if (this.numCurrent > 0) {
            for (i = 0; i < numSubpopulations; ++i) {
                this.selectionMethodCurrent[i] = (SelectionMethod)state.parameters.getInstanceForParameter(base.push(P_SUBPOP).push("" + i).push(P_SELECTION_METHOD_CURRENT), base.push(P_SELECTION_METHOD_CURRENT), class$ec$SelectionMethod == null ? MultiPopCoevolutionaryEvaluator.class$("ec.SelectionMethod") : class$ec$SelectionMethod);
                if (this.selectionMethodCurrent[i] == null) {
                    state.output.error("No selection method provided for subpopulation " + i, base.push(P_SUBPOP).push("" + i).push(P_SELECTION_METHOD_CURRENT), base.push(P_SELECTION_METHOD_CURRENT));
                    continue;
                }
                this.selectionMethodCurrent[i].setup(state, base.push(P_SUBPOP).push("" + i).push(P_SELECTION_METHOD_CURRENT));
            }
        }
        this.numPrev = state.parameters.getInt(base.push(P_NUM_IND), null, 0);
        this.selectionMethodPrev = new SelectionMethod[numSubpopulations];
        if (this.numPrev < 0) {
            state.output.fatal("Parameter not found, or it has an incorrect value.", base.push(P_NUM_IND));
        } else if (this.numPrev > 0) {
            for (i = 0; i < numSubpopulations; ++i) {
                this.selectionMethodPrev[i] = (SelectionMethod)state.parameters.getInstanceForParameter(base.push(P_SUBPOP).push("" + i).push(P_SELECTION_METHOD_PREV), base.push(P_SELECTION_METHOD_PREV), class$ec$SelectionMethod == null ? MultiPopCoevolutionaryEvaluator.class$("ec.SelectionMethod") : class$ec$SelectionMethod);
                if (this.selectionMethodPrev[i] == null) {
                    state.output.error("No selection method provided for subpopulation " + i, base.push(P_SUBPOP).push("" + i).push(P_SELECTION_METHOD_PREV), base.push(P_SELECTION_METHOD_PREV));
                    continue;
                }
                this.selectionMethodPrev[i].setup(state, base.push(P_SUBPOP).push("" + i).push(P_SELECTION_METHOD_PREV));
            }
        }
        if (this.numElite + this.numCurrent + this.numPrev <= 0) {
            state.output.error("The total number of partners to be selected should be > 0.");
        }
        state.output.exitIfErrors();
    }

    public boolean runComplete(EvolutionState state) {
        return false;
    }

    public void evaluatePopulation(EvolutionState state) {
        this.beforeCoevolutionaryEvaluation(state, state.population, (GroupedProblemForm)((Object)this.p_problem));
        ((GroupedProblemForm)((Object)this.p_problem)).preprocessPopulation(state, state.population, false);
        this.performCoevolutionaryEvaluation(state, state.population, (GroupedProblemForm)((Object)this.p_problem));
        ((GroupedProblemForm)((Object)this.p_problem)).postprocessPopulation(state, state.population, false);
        this.afterCoevolutionaryEvaluation(state, state.population, (GroupedProblemForm)((Object)this.p_problem));
    }

    protected void beforeCoevolutionaryEvaluation(EvolutionState state, Population population, GroupedProblemForm prob) {
        if (state.generation == 0) {
            this.eliteIndividuals = new Individual[state.population.subpops.length][this.numElite];
            for (int i = 0; i < this.eliteIndividuals.length; ++i) {
                if (this.numElite > state.population.subpops[i].individuals.length) {
                    state.output.fatal("Number of elite partners is greater than the size of the subpopulation.");
                }
                for (int j = 0; j < this.numElite; ++j) {
                    this.eliteIndividuals[i][j] = (Individual)state.population.subpops[i].individuals[j].clone();
                }
            }
        }
    }

    public void performCoevolutionaryEvaluation(EvolutionState state, Population population, GroupedProblemForm prob) {
        int j;
        this.inds = new Individual[population.subpops.length];
        this.updates = new boolean[population.subpops.length];
        for (int i = 0; i < this.selectionMethodPrev.length; ++i) {
            this.selectionMethodCurrent[i].prepareToProduce(state, i, 0);
            Population currentPopulation = state.population;
            state.population = this.previousPopulation;
            this.selectionMethodPrev[i].prepareToProduce(state, i, 0);
            state.population = currentPopulation;
        }
        int[] subpops = new int[state.population.subpops.length];
        for (j = 0; j < subpops.length; ++j) {
            subpops[j] = j;
        }
        for (j = 0; j < state.population.subpops.length; ++j) {
            for (int i = 0; i < state.population.subpops[j].individuals.length; ++i) {
                int ind;
                int k;
                for (k = 0; k < this.eliteIndividuals[j].length; ++k) {
                    for (ind = 0; ind < this.inds.length; ++ind) {
                        if (ind == j) {
                            this.inds[ind] = state.population.subpops[j].individuals[i];
                            this.updates[ind] = true;
                            continue;
                        }
                        this.inds[ind] = this.eliteIndividuals[ind][k];
                        this.updates[ind] = false;
                    }
                    prob.evaluate(state, this.inds, this.updates, false, subpops, 0);
                }
                for (k = 0; k < this.numCurrent; ++k) {
                    for (ind = 0; ind < this.inds.length; ++ind) {
                        if (ind == j) {
                            this.inds[ind] = state.population.subpops[j].individuals[i];
                            this.updates[ind] = true;
                            continue;
                        }
                        this.inds[ind] = this.produce(this.selectionMethodCurrent[j], j, i, state, 0);
                        this.updates[ind] = false;
                    }
                    prob.evaluate(state, this.inds, this.updates, false, subpops, 0);
                }
                for (k = 0; k < this.numCurrent; ++k) {
                    for (ind = 0; ind < this.inds.length; ++ind) {
                        if (ind == j) {
                            this.inds[ind] = state.population.subpops[j].individuals[i];
                            this.updates[ind] = true;
                            continue;
                        }
                        if (state.generation > 0) {
                            Population currentPopulation = state.population;
                            state.population = this.previousPopulation;
                            this.inds[ind] = this.produce(this.selectionMethodPrev[j], j, i, state, 0);
                            state.population = currentPopulation;
                            this.updates[ind] = false;
                            continue;
                        }
                        this.inds[ind] = state.population.subpops[j].individuals[state.random[0].nextInt(state.population.subpops[j].individuals.length)];
                        this.updates[ind] = false;
                    }
                    prob.evaluate(state, this.inds, this.updates, false, subpops, 0);
                }
            }
        }
        for (int i = 0; i < this.selectionMethodPrev.length; ++i) {
            this.selectionMethodCurrent[i].finishProducing(state, i, 0);
            Population currentPopulation = state.population;
            state.population = this.previousPopulation;
            this.selectionMethodPrev[i].finishProducing(state, i, 0);
            state.population = currentPopulation;
        }
    }

    protected Individual produce(SelectionMethod method, int subpopulation, int individual, EvolutionState state, int thread) {
        return state.population.subpops[subpopulation].individuals[method.produce(subpopulation, state, thread)];
    }

    protected void afterCoevolutionaryEvaluation(EvolutionState state, Population population, GroupedProblemForm prob) {
        int i;
        if (this.numElite > 0) {
            for (i = 0; i < state.population.subpops.length; ++i) {
                this.loadElites(state, state.population.subpops[i], i);
            }
        }
        this.previousPopulation = (Population)state.population.emptyClone();
        for (i = 0; i < this.previousPopulation.subpops.length; ++i) {
            for (int j = 0; j < this.previousPopulation.subpops[i].individuals.length; ++j) {
                this.previousPopulation.subpops[i].individuals[j] = (Individual)state.population.subpops[i].individuals[j].clone();
            }
        }
    }

    void loadElites(EvolutionState state, Subpopulation subpop, int whichSubpop) {
        if (this.numElite == 1) {
            int best = 0;
            Individual[] oldinds = subpop.individuals;
            for (int x = 1; x < oldinds.length; ++x) {
                if (!oldinds[x].fitness.betterThan(oldinds[best].fitness)) continue;
                best = x;
            }
            this.eliteIndividuals[whichSubpop][0] = (Individual)state.population.subpops[whichSubpop].individuals[best].clone();
        } else if (this.numElite > 0) {
            int[] orderedPop = new int[subpop.individuals.length];
            for (int x = 0; x < subpop.individuals.length; ++x) {
                orderedPop[x] = x;
            }
            QuickSort.qsort(orderedPop, (SortComparatorL)new EliteComparator(subpop.individuals));
            for (int j = 0; j < this.numElite; ++j) {
                this.eliteIndividuals[whichSubpop][j] = (Individual)state.population.subpops[whichSubpop].individuals[orderedPop[j]].clone();
            }
        }
    }
}

