/*
 * Decompiled with CFR 0.152.
 */
package ec.de;

import ec.EvolutionState;
import ec.Individual;
import ec.de.DEBreeder;
import ec.util.Parameter;
import ec.vector.DoubleVectorIndividual;

public class Rand1EitherOrDEBreeder
extends DEBreeder {
    public double PF = 0.0;
    public static final String P_PF = "pf";

    public void setup(EvolutionState state, Parameter base) {
        super.setup(state, base);
        this.PF = state.parameters.getDouble(base.push(P_PF), null, 0.0);
        if (this.PF < 0.0 || this.PF > 1.0) {
            state.output.fatal("Parameter not found, or its value is outside of [0.0,1.0].", base.push(P_PF), null);
        }
        if (state.parameters.exists(base.push("cr"), null)) {
            state.output.warning("Crossover parameter specified, but Rand1EitherOrDEBreeder does not use crossover.", base.push("cr"));
        }
    }

    public DoubleVectorIndividual createIndividual(EvolutionState state, int subpop, int index, int thread) {
        Individual[] inds = state.population.subpops[subpop].individuals;
        DoubleVectorIndividual v = (DoubleVectorIndividual)inds[index].clone();
        while (true) {
            int r2;
            int r1;
            int r0;
            if ((r0 = state.random[thread].nextInt(inds.length)) == index) {
                continue;
            }
            while ((r1 = state.random[thread].nextInt(inds.length)) == r0 || r1 == index) {
            }
            while ((r2 = state.random[thread].nextInt(inds.length)) == r1 || r2 == r0 || r2 == index) {
            }
            DoubleVectorIndividual g0 = (DoubleVectorIndividual)inds[r0];
            DoubleVectorIndividual g1 = (DoubleVectorIndividual)inds[r1];
            DoubleVectorIndividual g2 = (DoubleVectorIndividual)inds[r2];
            for (int i = 0; i < v.genome.length; ++i) {
                v.genome[i] = state.random[thread].nextBoolean(this.PF) ? g0.genome[i] + this.F * (g1.genome[i] - g2.genome[i]) : g0.genome[i] + 0.5 * (this.F + 1.0) * (g1.genome[i] + g2.genome[i] - 2.0 * g0.genome[i]);
            }
            if (this.valid(v)) break;
        }
        return v;
    }
}

