/*
 * Decompiled with CFR 0.152.
 */
package ec.es;

import ec.EvolutionState;
import ec.Individual;
import ec.SelectionMethod;
import ec.es.ESDefaults;
import ec.es.MuCommaLambdaBreeder;
import ec.util.Parameter;

public class ESSelection
extends SelectionMethod {
    public static final String P_ESSELECT = "select";

    public Parameter defaultBase() {
        return ESDefaults.base().push(P_ESSELECT);
    }

    public void prepareToProduce(EvolutionState state, int subpopulation, int thread) {
        super.prepareToProduce(state, subpopulation, thread);
        if (!(state.breeder instanceof MuCommaLambdaBreeder)) {
            state.output.fatal("ESSelection was handed a Breeder that's not either MuCommaLambdaBreeder or MuCommaPlusLambdaBreeder.");
        }
        MuCommaLambdaBreeder breeder = (MuCommaLambdaBreeder)state.breeder;
        breeder.count[thread] = 1;
    }

    public int produce(int subpopulation, EvolutionState state, int thread) {
        if (!(state.breeder instanceof MuCommaLambdaBreeder)) {
            state.output.fatal("ESSelection was handed a Breeder that's not either MuCommaLambdaBreeder or MuCommaPlusLambdaBreeder.");
        }
        MuCommaLambdaBreeder breeder = (MuCommaLambdaBreeder)state.breeder;
        int pos = (breeder.lambda[subpopulation] % state.breedthreads == 0 ? breeder.lambda[subpopulation] / state.breedthreads : breeder.lambda[subpopulation] / state.breedthreads + 1) * thread + breeder.count[thread];
        int parent = pos / breeder.mu[subpopulation];
        return parent;
    }

    public int produce(int min, int max, int start, int subpopulation, Individual[] inds, EvolutionState state, int thread) {
        if (min > 1) {
            state.output.fatal("ESSelection used, but it's being asked to produce more than one individual.");
        }
        if (!(state.breeder instanceof MuCommaLambdaBreeder)) {
            state.output.fatal("ESSelection was handed a Breeder that's not either MuCommaLambdaBreeder or MuCommaPlusLambdaBreeder.");
        }
        MuCommaLambdaBreeder breeder = (MuCommaLambdaBreeder)state.breeder;
        int pos = (breeder.lambda[subpopulation] % state.breedthreads == 0 ? breeder.lambda[subpopulation] / state.breedthreads : breeder.lambda[subpopulation] / state.breedthreads + 1) * thread + breeder.count[thread];
        int parent = pos / (breeder.lambda[subpopulation] / breeder.mu[subpopulation]);
        inds[start] = state.population.subpops[subpopulation].individuals[parent];
        return 1;
    }
}

