/*
 * Decompiled with CFR 0.152.
 */
package ec.eval;

import ec.EvolutionState;
import ec.eval.Job;
import ec.eval.SlaveMonitor;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.net.Socket;
import java.util.Iterator;
import java.util.LinkedList;

class SlaveConnection {
    String slaveName;
    Socket evalSocket;
    DataOutputStream dataOut;
    public DataInputStream dataIn;
    EvolutionState state;
    SlaveMonitor slaveMonitor;
    Thread reader;
    Thread writer;
    private LinkedList jobs = new LinkedList();
    boolean shuttingDown;
    Object shutDownLock = new int[0];
    boolean showDebugInfo;

    public SlaveConnection(EvolutionState state, String slaveName, Socket evalSocket, DataOutputStream dataOut, DataInputStream dataIn, SlaveMonitor slaveMonitor) {
        this.slaveName = slaveName;
        this.evalSocket = evalSocket;
        this.dataOut = dataOut;
        this.dataIn = dataIn;
        this.state = state;
        this.slaveMonitor = slaveMonitor;
        this.buildThreads();
        this.showDebugInfo = slaveMonitor.showDebugInfo;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void shutdown(EvolutionState state) {
        Object object = this.shutDownLock;
        synchronized (object) {
            if (this.shuttingDown) {
                return;
            }
            this.shuttingDown = true;
        }
        try {
            this.dataOut.writeByte(0);
        }
        catch (Exception e) {
            // empty catch block
        }
        try {
            this.dataOut.flush();
        }
        catch (Exception e) {
            // empty catch block
        }
        try {
            this.dataOut.close();
        }
        catch (Exception e) {
            // empty catch block
        }
        try {
            this.dataIn.close();
        }
        catch (Exception e) {
            // empty catch block
        }
        try {
            this.evalSocket.close();
        }
        catch (IOException iOException) {
            // empty catch block
        }
        state.output.systemMessage(this.toString() + " Slave is shutting down....");
        this.slaveMonitor.unregisterSlave(this);
        this.rescheduleJobs(state);
        object = this.jobs;
        synchronized (object) {
            this.slaveMonitor.notifyMonitor(this.jobs);
            this.reader.interrupt();
            this.writer.interrupt();
        }
        state.output.systemMessage(this.toString() + " Slave exits....");
    }

    public String toString() {
        return "Slave(" + this.slaveName + ")";
    }

    final void debug(String s) {
        if (this.showDebugInfo) {
            System.err.println(Thread.currentThread().getName() + "->" + s);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int numJobs() {
        LinkedList linkedList = this.jobs;
        synchronized (linkedList) {
            return this.jobs.size();
        }
    }

    void buildThreads() {
        this.reader = new Thread(){

            public void run() {
                while (SlaveConnection.this.readLoop()) {
                }
            }
        };
        this.writer = new Thread(){

            public void run() {
                while (SlaveConnection.this.writeLoop()) {
                }
            }
        };
        this.writer.start();
        this.reader.start();
    }

    Job oldestUnsentJob() {
        Iterator i = this.jobs.iterator();
        while (i.hasNext()) {
            Job job = (Job)i.next();
            if (job.sent) continue;
            job.sent = true;
            return job;
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    boolean writeLoop() {
        Job job = null;
        try {
            LinkedList linkedList = this.jobs;
            synchronized (linkedList) {
                job = this.oldestUnsentJob();
                if (job == null) {
                    this.debug("" + Thread.currentThread().getName() + "Waiting for a job to send");
                    this.slaveMonitor.waitOnMonitor(this.jobs);
                }
            }
            if (job != null) {
                this.debug("" + Thread.currentThread().getName() + "Sending Job");
                if (job.type == 1) {
                    this.dataOut.writeByte(1);
                } else {
                    this.dataOut.writeByte(2);
                    this.dataOut.writeBoolean(job.countVictoriesOnly);
                }
                this.dataOut.writeInt(job.inds.length);
                for (int x = 0; x < job.subPops.length; ++x) {
                    this.dataOut.writeInt(job.subPops[x]);
                }
                this.debug("Starting to transmit individuals");
                for (int i = 0; i < job.inds.length; ++i) {
                    job.inds[i].writeIndividual(this.state, this.dataOut);
                    this.dataOut.writeBoolean(job.updateFitness[i]);
                }
                this.dataOut.flush();
            }
        }
        catch (Exception e) {
            this.shutdown(this.state);
            return false;
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    boolean readLoop() {
        Job job = null;
        try {
            byte val = this.dataIn.readByte();
            this.debug(this.toString() + " Incoming Job");
            LinkedList linkedList = this.jobs;
            synchronized (linkedList) {
                job = (Job)this.jobs.getFirst();
            }
            this.debug("Got job: " + job);
            job.copyIndividualsForward();
            for (int i = 0; i < job.newinds.length; ++i) {
                this.debug(this.toString() + " Individual# " + i);
                this.debug(this.toString() + " Reading Byte");
                if (i > 0) {
                    val = this.dataIn.readByte();
                }
                this.debug(this.toString() + " Reading Individual");
                if (val == 1) {
                    job.newinds[i].readIndividual(this.state, this.dataIn);
                } else if (val == 2) {
                    job.newinds[i].evaluated = this.dataIn.readBoolean();
                    job.newinds[i].fitness.readFitness(this.state, this.dataIn);
                } else if (val == 0) {
                    // empty if block
                }
                this.debug(this.toString() + " Read Individual");
            }
            job.copyIndividualsBack(this.state);
            LinkedList linkedList2 = this.jobs;
            synchronized (linkedList2) {
                this.jobs.removeFirst();
            }
            this.slaveMonitor.notifySlaveAvailability(this, job, this.state);
        }
        catch (IOException e) {
            this.shutdown(this.state);
            return false;
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void scheduleJob(Job job) {
        LinkedList linkedList = this.jobs;
        synchronized (linkedList) {
            if (job.sent) {
                this.state.output.fatal("Tried to reschedule an existing job");
            }
            this.jobs.addLast(job);
            this.slaveMonitor.notifyMonitor(this.jobs);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void rescheduleJobs(EvolutionState state) {
        while (true) {
            Job job = null;
            LinkedList linkedList = this.jobs;
            synchronized (linkedList) {
                if (this.jobs.isEmpty()) {
                    return;
                }
                job = (Job)this.jobs.removeFirst();
            }
            this.debug(Thread.currentThread().getName() + " Waiting for a slave to reschedule the evaluation.");
            job.sent = false;
            this.slaveMonitor.scheduleJobForEvaluation(state, job);
            this.debug(Thread.currentThread().getName() + " Got a slave to reschedule the evaluation.");
        }
    }
}

