/*
 * Decompiled with CFR 0.152.
 */
package ec.eval;

import ec.EvolutionState;
import ec.eval.Job;
import ec.eval.SlaveConnection;
import ec.steadystate.QueueIndividual;
import ec.steadystate.SteadyStateEvolutionState;
import ec.util.Output;
import ec.util.Parameter;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.OutputStream;
import java.net.ServerSocket;
import java.net.Socket;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.NoSuchElementException;

public class SlaveMonitor {
    public static final String P_EVALMASTERPORT = "eval.master.port";
    public static final String P_EVALCOMPRESSION = "eval.compression";
    public static final String P_MAXIMUMNUMBEROFCONCURRENTJOBSPERSLAVE = "eval.masterproblem.max-jobs-per-slave";
    public static final int SEED_INCREMENT = 7919;
    public EvolutionState state;
    public ServerSocket servSock;
    public boolean useCompression;
    boolean shutdownInProgress = false;
    Object[] shutdownInProgressLock = new Object[0];
    int randomSeed;
    Thread thread;
    private LinkedList allSlaves = new LinkedList();
    private LinkedList availableSlaves = new LinkedList();
    int maxJobsPerSlave;
    boolean showDebugInfo;
    LinkedList evaluatedIndividuals = new LinkedList();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    final boolean isShutdownInProgress() {
        Object[] objectArray = this.shutdownInProgressLock;
        synchronized (this.shutdownInProgressLock) {
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return this.shutdownInProgress;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    final void setShutdownInProgress(boolean val) {
        Object[] objectArray = this.shutdownInProgressLock;
        synchronized (this.shutdownInProgressLock) {
            this.shutdownInProgress = val;
            // ** MonitorExit[var2_2] (shouldn't be in output)
            return;
        }
    }

    public boolean waitOnMonitor(Object monitor) {
        try {
            monitor.wait();
        }
        catch (InterruptedException e) {
            return false;
        }
        return true;
    }

    public void notifyMonitor(Object monitor) {
        monitor.notifyAll();
    }

    final void debug(String s) {
        if (this.showDebugInfo) {
            System.err.println(Thread.currentThread().getName() + "->" + s);
        }
    }

    public SlaveMonitor(final EvolutionState state, boolean showDebugInfo) {
        this.showDebugInfo = showDebugInfo;
        this.state = state;
        int port = state.parameters.getInt(new Parameter(P_EVALMASTERPORT), null);
        this.maxJobsPerSlave = state.parameters.getInt(new Parameter(P_MAXIMUMNUMBEROFCONCURRENTJOBSPERSLAVE), null);
        this.useCompression = state.parameters.getBoolean(new Parameter(P_EVALCOMPRESSION), null, false);
        try {
            this.servSock = new ServerSocket(port);
        }
        catch (IOException e) {
            state.output.fatal("Unable to bind to port " + port + ": " + e);
        }
        this.randomSeed = (int)System.currentTimeMillis();
        this.thread = new Thread(new Runnable(){

            public void run() {
                Thread.currentThread().setName("SlaveMonitor::    ");
                while (!SlaveMonitor.this.isShutdownInProgress()) {
                    Socket slaveSock = null;
                    while (slaveSock == null && !SlaveMonitor.this.isShutdownInProgress()) {
                        try {
                            slaveSock = SlaveMonitor.this.servSock.accept();
                        }
                        catch (IOException e) {
                            slaveSock = null;
                        }
                    }
                    SlaveMonitor.this.debug(Thread.currentThread().getName() + " Slave attempts to connect.");
                    if (SlaveMonitor.this.isShutdownInProgress()) break;
                    try {
                        DataInputStream dataIn = null;
                        DataOutputStream dataOut = null;
                        InputStream tmpIn = slaveSock.getInputStream();
                        OutputStream tmpOut = slaveSock.getOutputStream();
                        if (SlaveMonitor.this.useCompression) {
                            tmpIn = Output.makeCompressingInputStream(tmpIn);
                            tmpOut = Output.makeCompressingOutputStream(tmpOut);
                            if (tmpIn == null || tmpOut == null) {
                                Output.initialError("You do not appear to have JZLib installed on your system, and so must set eval.compression=false. To get JZLib, download from the ECJ website or from http://www.jcraft.com/jzlib/");
                            }
                        }
                        dataIn = new DataInputStream(tmpIn);
                        dataOut = new DataOutputStream(tmpOut);
                        String slaveName = dataIn.readUTF();
                        dataOut.writeInt(SlaveMonitor.this.randomSeed);
                        SlaveMonitor.this.randomSeed += 7919;
                        dataOut.flush();
                        SlaveMonitor.this.registerSlave(state, slaveName, slaveSock, dataOut, dataIn);
                        state.output.systemMessage("Slave " + slaveName + " connected successfully.");
                    }
                    catch (IOException iOException) {}
                }
                SlaveMonitor.this.debug(Thread.currentThread().getName() + " The monitor is shutting down.");
            }
        });
        this.thread.start();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void registerSlave(EvolutionState state, String name, Socket socket, DataOutputStream out, DataInputStream in) {
        SlaveConnection newSlave = new SlaveConnection(state, name, socket, out, in, this);
        LinkedList linkedList = this.availableSlaves;
        synchronized (linkedList) {
            this.availableSlaves.addLast(newSlave);
            this.notifyMonitor(this.availableSlaves);
        }
        linkedList = this.allSlaves;
        synchronized (linkedList) {
            this.allSlaves.addLast(newSlave);
            this.notifyMonitor(this.allSlaves);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void unregisterSlave(SlaveConnection slave) {
        LinkedList linkedList = this.allSlaves;
        synchronized (linkedList) {
            this.allSlaves.remove(slave);
            this.notifyMonitor(this.allSlaves);
        }
        linkedList = this.availableSlaves;
        synchronized (linkedList) {
            this.availableSlaves.remove(slave);
            this.notifyMonitor(this.availableSlaves);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void shutdown() {
        this.setShutdownInProgress(true);
        try {
            this.servSock.close();
        }
        catch (IOException e) {
            // empty catch block
        }
        this.thread.interrupt();
        try {
            this.thread.join();
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
        LinkedList linkedList = this.allSlaves;
        synchronized (linkedList) {
            while (!this.allSlaves.isEmpty()) {
                ((SlaveConnection)this.allSlaves.removeFirst()).shutdown(this.state);
            }
            this.notifyMonitor(this.allSlaves);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void scheduleJobForEvaluation(EvolutionState state, Job job) {
        if (this.isShutdownInProgress()) {
            return;
        }
        SlaveConnection result = null;
        LinkedList linkedList = this.availableSlaves;
        synchronized (linkedList) {
            while (true) {
                if (!this.availableSlaves.isEmpty()) break;
                this.debug("Waiting for an available slave.");
                this.waitOnMonitor(this.availableSlaves);
            }
            result = (SlaveConnection)this.availableSlaves.removeFirst();
            this.notifyMonitor(this.availableSlaves);
        }
        this.debug("Got a slave available for work.");
        result.scheduleJob(job);
        if (result.numJobs() < this.maxJobsPerSlave) {
            linkedList = this.availableSlaves;
            synchronized (linkedList) {
                if (!this.availableSlaves.contains(result)) {
                    this.availableSlaves.addLast(result);
                }
                this.notifyMonitor(this.availableSlaves);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void waitForAllSlavesToFinishEvaluating(EvolutionState state) {
        LinkedList linkedList = this.allSlaves;
        synchronized (linkedList) {
            Iterator iter = this.allSlaves.iterator();
            while (iter.hasNext()) {
                SlaveConnection slaveConnection = (SlaveConnection)iter.next();
                try {
                    slaveConnection.dataOut.flush();
                }
                catch (IOException e) {}
            }
            this.notifyMonitor(this.allSlaves);
        }
        boolean shouldCycle = true;
        LinkedList linkedList2 = this.allSlaves;
        synchronized (linkedList2) {
            while (shouldCycle) {
                shouldCycle = false;
                Iterator iter = this.allSlaves.iterator();
                while (iter.hasNext()) {
                    SlaveConnection slaveConnection = (SlaveConnection)iter.next();
                    int jobs = slaveConnection.numJobs();
                    if (jobs == 0) continue;
                    this.debug("Slave " + slaveConnection + " has " + jobs + " more jobs to finish.");
                    shouldCycle = true;
                    break;
                }
                if (!shouldCycle) continue;
                this.debug("Waiting for slaves to finish their jobs.");
                this.waitOnMonitor(this.allSlaves);
                this.debug("At least one job has been finished.");
            }
            this.notifyMonitor(this.allSlaves);
        }
        this.debug("All slaves have finished their jobs.");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void notifySlaveAvailability(SlaveConnection slave, Job job, EvolutionState state) {
        LinkedList linkedList = this.allSlaves;
        synchronized (linkedList) {
            this.notifyMonitor(this.allSlaves);
        }
        if (slave.numJobs() < this.maxJobsPerSlave) {
            linkedList = this.availableSlaves;
            synchronized (linkedList) {
                if (!this.availableSlaves.contains(slave)) {
                    this.availableSlaves.addLast(slave);
                }
                this.notifyMonitor(this.availableSlaves);
            }
        }
        this.debug("Notify the monitor that the slave is available.");
        if (state instanceof SteadyStateEvolutionState) {
            linkedList = this.evaluatedIndividuals;
            synchronized (linkedList) {
                for (int x = 0; x < job.inds.length; ++x) {
                    this.evaluatedIndividuals.addLast(new QueueIndividual(job.inds[x], job.subPops[x]));
                }
                this.notifyMonitor(this.evaluatedIndividuals);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean evaluatedIndividualAvailable() {
        LinkedList linkedList = this.evaluatedIndividuals;
        synchronized (linkedList) {
            try {
                this.evaluatedIndividuals.getFirst();
                return true;
            }
            catch (NoSuchElementException e) {
                return false;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public QueueIndividual waitForIndividual() {
        while (true) {
            LinkedList linkedList = this.evaluatedIndividuals;
            synchronized (linkedList) {
                if (this.evaluatedIndividualAvailable()) {
                    return (QueueIndividual)this.evaluatedIndividuals.removeFirst();
                }
                this.debug("Waiting for individual to be evaluated.");
                this.waitOnMonitor(this.evaluatedIndividuals);
                this.debug("At least one individual has been finished.");
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    int numAvailableSlaves() {
        int i = 0;
        LinkedList linkedList = this.availableSlaves;
        synchronized (linkedList) {
            i = this.availableSlaves.size();
        }
        return i;
    }

    private void writeObject(ObjectOutputStream out) throws IOException {
        this.state.output.fatal("Not implemented yet: SlaveMonitor.writeObject");
    }

    private void readObject(ObjectInputStream in) throws IOException, ClassNotFoundException {
        this.state.output.fatal("Not implemented yet: SlaveMonitor.readObject");
    }
}

