/*
 * Decompiled with CFR 0.152.
 */
package ec.evolve;

import ec.EvolutionState;
import ec.Statistics;
import ec.Subpopulation;
import ec.steadystate.SteadyStateStatisticsForm;
import ec.util.Parameter;
import java.io.File;

public class RandomRestarts
extends Statistics
implements SteadyStateStatisticsForm {
    public static final String P_RESTART_TYPE = "restart-type";
    public static final String P_RESTART_UPPERBOUND = "restart-upper-bound";
    public int countdown;
    public int upperbound;
    String restartType;

    public void setup(EvolutionState state, Parameter base) {
        super.setup(state, base);
        this.restartType = state.parameters.getString(base.push(P_RESTART_TYPE), null);
        this.upperbound = state.parameters.getInt(base.push(P_RESTART_UPPERBOUND), null, 1);
        if (this.upperbound < 1) {
            state.output.fatal("Parameter either not found or invalid (<1).", base.push(P_RESTART_UPPERBOUND));
        }
        if (!this.restartType.equals("random") && !this.restartType.equals("fixed")) {
            state.output.fatal("Parameter must be either 'fixed' or 'random'.", base.push(P_RESTART_TYPE));
        }
        this.resetClock(state);
    }

    public void preEvaluationStatistics(EvolutionState state) {
        super.preEvaluationStatistics(state);
        this.possiblyRestart(state);
    }

    public void generationBoundaryStatistics(EvolutionState state) {
        super.generationBoundaryStatistics(state);
        this.possiblyRestart(state);
    }

    void possiblyRestart(EvolutionState state) {
        if (this.countdown == 0) {
            System.out.println("Restarting the population!");
            for (int subp = 0; subp < state.population.subpops.length; ++subp) {
                Subpopulation currentSubp = state.population.subpops[subp];
                File tempFile = currentSubp.loadInds;
                currentSubp.loadInds = null;
                currentSubp.populate(state, 0);
                currentSubp.loadInds = tempFile;
            }
            this.resetClock(state);
        } else {
            --this.countdown;
        }
    }

    void resetClock(EvolutionState state) {
        this.countdown = this.restartType.equals("fixed") ? this.upperbound : state.random[0].nextInt(this.upperbound + 1);
    }
}

