/*
 * Decompiled with CFR 0.152.
 */
package ec.exchange;

import ec.EvolutionState;
import ec.Individual;
import ec.util.Output;
import ec.util.Parameter;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.io.InterruptedIOException;
import java.net.ServerSocket;
import java.net.Socket;
import java.net.SocketException;

class IslandExchangeMailbox
implements Runnable {
    public static final int SLEEP_BETWEEN_CHECKING_FOR_IMMIGRANTS = 1000;
    public static final int CHECK_TIMEOUT = 1000;
    public static final int SYNCHRONIZATION_SLEEP = 100;
    public Individual[][] immigrants;
    public int[] nImmigrants;
    int[] person2die;
    ServerSocket serverSocket;
    int n_incoming;
    boolean compressedCommunication;
    Socket[] inSockets;
    DataInputStream[] dataInput;
    String[] incomingIds;
    boolean[] running;
    EvolutionState state;
    Boolean syncVar;
    String myId;
    boolean chatty;

    public IslandExchangeMailbox(EvolutionState state_p, int port, int n_incoming_p, int how_many, String _myId, boolean chatty, boolean _compressedCommunication) {
        this.myId = _myId;
        this.compressedCommunication = _compressedCommunication;
        this.chatty = chatty;
        this.state = state_p;
        this.n_incoming = n_incoming_p;
        Parameter p_numsubpops = new Parameter("pop").push("subpops");
        int numsubpops = this.state.parameters.getInt(p_numsubpops, null, 1);
        if (numsubpops == 0) {
            // empty if block
        }
        this.immigrants = new Individual[numsubpops][how_many];
        this.person2die = new int[numsubpops];
        this.nImmigrants = new int[numsubpops];
        this.syncVar = Boolean.FALSE;
        try {
            this.serverSocket = new ServerSocket(port, this.n_incoming);
        }
        catch (IOException e) {
            this.state.output.fatal("Could not start mailbox for incoming messages.  Perhaps the port (" + port + ") is bad?\n...or someone else already has it?");
        }
        this.inSockets = new Socket[this.n_incoming];
        this.dataInput = new DataInputStream[this.n_incoming];
        this.incomingIds = new String[this.n_incoming];
        this.running = new boolean[this.n_incoming];
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Converted monitor instructions to comments
     * Lifted jumps to return sites
     */
    public void run() {
        for (x = 0; x < this.n_incoming; ++x) {
            try {
                this.inSockets[x] = this.serverSocket.accept();
                if (this.compressedCommunication) {
                    compressedo = Output.makeCompressingOutputStream(this.inSockets[x].getOutputStream());
                    compressedi = Output.makeCompressingInputStream(this.inSockets[x].getInputStream());
                    if (compressedi == null || compressedo == null) {
                        this.state.output.fatal("You do not appear to have JZLib installed on your system, and so may must have compression turned off for IslandExchange.  To get JZLib, download from the ECJ website or from http://www.jcraft.com/jzlib/");
                    }
                    this.dataInput[x] = new DataInputStream(compressedi);
                    dataOutput = new DataOutputStream(compressedo);
                } else {
                    this.dataInput[x] = new DataInputStream(this.inSockets[x].getInputStream());
                    dataOutput = new DataOutputStream(this.inSockets[x].getOutputStream());
                }
                dataOutput.writeUTF(this.myId);
                dataOutput.flush();
                this.incomingIds[x] = this.dataInput[x].readUTF().trim();
                this.state.output.message("Island " + this.incomingIds[x] + " connected to my mailbox");
                this.inSockets[x].setSoTimeout(1000);
                this.running[x] = true;
                continue;
            }
            catch (IOException e) {
                this.running[x] = false;
                this.state.output.fatal("An exception was generated while creating communication structures for island " + x + ".  Here it is: " + e);
            }
        }
        this.state.output.message("All islands have connected to my client.");
        shouldExit = false;
        block24: while (true) {
            try {
                Thread.sleep(1000L);
            }
            catch (InterruptedException e) {
                // empty catch block
            }
            x = 0;
            while (true) {
                block37: {
                    block38: {
                        block36: {
                            if (x >= this.n_incoming) break block36;
                            if (!this.running[x]) break block37;
                            break block38;
                        }
                        x = this.syncVar;
                        // MONITORENTER : x
                        shouldExit = this.syncVar;
                        // MONITOREXIT : x
                        if (!shouldExit) continue block24;
                        try {
                            this.serverSocket.close();
                        }
                        catch (IOException e) {
                            // empty catch block
                        }
                        x = 0;
                        break block24;
                    }
                    try {
                        while (true) lbl-1000:
                        // 3 sources

                        {
                            subpop = this.dataInput[x].readInt();
                            try {
                                this.inSockets[x].setSoTimeout(0);
                            }
                            catch (SocketException e) {
                                this.state.output.warning("Could not set the socket to blocking while receiving individuals in the mailbox.");
                            }
                            how_many_to_come = this.dataInput[x].readInt();
                            if (this.chatty) {
                                this.state.output.message("Receiving " + how_many_to_come + " immigrants for subpopulation " + subpop + " from island " + this.incomingIds[x]);
                            }
                            var5_17 = this.immigrants;
                            // MONITORENTER : this.immigrants
                            if (this.nImmigrants[subpop] == 0) {
                                this.person2die[subpop] = 0;
                            }
                            for (ind = 0; ind < how_many_to_come; ++ind) {
                                try {
                                    this.immigrants[subpop][this.person2die[subpop]] = this.state.population.subpops[subpop].species.newIndividual(this.state, this.dataInput[x]);
                                    if (this.person2die[subpop] == this.immigrants[subpop].length - 1) {
                                        this.person2die[subpop] = 0;
                                    } else {
                                        v0 = subpop;
                                        this.person2die[v0] = this.person2die[v0] + 1;
                                    }
                                    if (this.nImmigrants[subpop] >= this.immigrants[subpop].length) continue;
                                    v1 = subpop;
                                    this.nImmigrants[v1] = this.nImmigrants[v1] + 1;
                                    continue;
                                }
                                catch (IOException e) {
                                    this.state.output.message("IO exception while communicating with an island");
                                    this.running[x] = false;
                                    continue;
                                }
                                catch (NumberFormatException e) {
                                    this.state.output.message("IO exception while communicating with an island");
                                    this.running[x] = false;
                                }
                            }
                            // MONITOREXIT : var5_17
                            try {
                                this.inSockets[x].setSoTimeout(1000);
                            }
                            catch (SocketException e) {
                                this.state.output.warning("Could not set the socket to non-blocking while receiving individuals in the mailbox.");
                                continue;
                            }
                            break;
                        }
                    }
                    catch (InterruptedIOException e) {
                    }
                    catch (IOException e) {
                        this.state.output.message("IO exception while communicating with an island");
                        this.running[x] = false;
                    }
                    catch (NumberFormatException e) {
                        this.state.output.message("Socket closed");
                        this.running[x] = false;
                    }
                    ** GOTO lbl-1000
                }
                ++x;
            }
            break;
        }
        while (x < this.n_incoming) {
            try {
                this.inSockets[x].close();
            }
            catch (IOException e) {
                // empty catch block
            }
            ++x;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void shutDown() {
        Boolean bl = this.syncVar;
        synchronized (bl) {
            this.syncVar = Boolean.TRUE;
        }
    }

    public int getPort() {
        return this.serverSocket.getLocalPort();
    }
}

