/*
 * Decompiled with CFR 0.152.
 */
package ec.gp;

import ec.EvolutionState;
import ec.Problem;
import ec.gp.ADFArgument;
import ec.gp.ADFContext;
import ec.gp.ADFStack;
import ec.gp.GPData;
import ec.gp.GPDefaults;
import ec.gp.GPIndividual;
import ec.gp.GPInitializer;
import ec.gp.GPNode;
import ec.util.Parameter;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;

public class ADF
extends GPNode {
    public static final String P_ADF = "adf";
    public static final String P_ASSOCIATEDTREE = "tree";
    public static final String P_FUNCTIONNAME = "name";
    public int associatedTree;
    public String name;

    public String name() {
        return this.name;
    }

    public Parameter defaultBase() {
        return GPDefaults.base().push(P_ADF);
    }

    public void writeNode(EvolutionState state, DataOutput dataOutput) throws IOException {
        dataOutput.writeInt(this.associatedTree);
        dataOutput.writeUTF(this.name);
    }

    public void readNode(EvolutionState state, DataInput dataInput) throws IOException {
        this.associatedTree = dataInput.readInt();
        this.name = dataInput.readUTF();
    }

    public int nodeHashCode() {
        return this.getClass().hashCode() + this.name.hashCode() + this.associatedTree;
    }

    public boolean nodeEquals(GPNode node) {
        if (!this.getClass().equals(node.getClass()) || this.children.length != node.children.length) {
            return false;
        }
        ADF adf = (ADF)node;
        return this.associatedTree == adf.associatedTree && this.name.equals(adf.name);
    }

    public void checkConstraints(EvolutionState state, int tree, GPIndividual typicalIndividual, Parameter individualBase) {
        super.checkConstraints(state, tree, typicalIndividual, individualBase);
        if (this.associatedTree < 0 || this.associatedTree > typicalIndividual.trees.length) {
            state.output.error("The node " + this.toStringForError() + " of individual " + individualBase + " must have an associated tree that is >= 0 and < " + typicalIndividual.trees.length);
        } else {
            GPInitializer initializer = (GPInitializer)state.initializer;
            if (!this.constraints((GPInitializer)initializer).returntype.compatibleWith(initializer, typicalIndividual.trees[this.associatedTree].constraints((GPInitializer)initializer).treetype)) {
                state.output.error("The return type of the node " + this.toStringForError() + " of individual " + individualBase + "is not type-compatible with the tree type of its associated tree.");
            }
            GPNode[][] funcs = typicalIndividual.trees[this.associatedTree].constraints((GPInitializer)initializer).functionset.nodes;
            ADFArgument[] validArgument = new ADFArgument[this.children.length];
            for (int w = 0; w < funcs.length; ++w) {
                GPNode[] gpfi = funcs[w];
                for (int x = 0; x < gpfi.length; ++x) {
                    if (!(gpfi[x] instanceof ADFArgument)) continue;
                    ADFArgument argument = (ADFArgument)gpfi[x];
                    int arg = argument.argument;
                    if (arg >= this.children.length) {
                        state.output.error("The node " + this.toStringForError() + " in individual " + individualBase + " would call its associated tree, which has an argument terminal with an argument number (" + arg + ") >= the ADF/ADM's arity (" + this.children.length + ").  The argument terminal in question is " + gpfi[x].toStringForError());
                        continue;
                    }
                    if (validArgument[arg] != null && validArgument[arg] != argument) {
                        state.output.warning("There exists more than one Argument terminal for argument #" + arg + " for the node " + this.toStringForError() + " in individual " + individualBase);
                    } else {
                        validArgument[arg] = argument;
                    }
                    if (gpfi[x].constraints((GPInitializer)initializer).returntype.compatibleWith(initializer, this.constraints((GPInitializer)initializer).childtypes[arg])) continue;
                    state.output.error("The node " + this.toStringForError() + " in individual " + individualBase + " would call its associated tree, which has an argument terminal which is not type-compatible with the related argument position of the ADF/ADM.  The argument terminal in question is " + gpfi[x].toStringForError());
                }
            }
            for (int x = 0; x < this.children.length; ++x) {
                if (validArgument[x] != null) continue;
                state.output.warning("There is no argument terminal for argument #" + x + " for the node " + this.toStringForError() + " in individual " + individualBase);
            }
        }
    }

    public void setup(EvolutionState state, Parameter base) {
        Parameter def = this.defaultBase();
        this.associatedTree = state.parameters.getInt(base.push(P_ASSOCIATEDTREE), def.push(P_FUNCTIONNAME), 0);
        if (this.associatedTree < 0) {
            state.output.fatal("ADF/ADM node must have a positive-numbered associated tree.", base.push(P_ASSOCIATEDTREE), def.push(P_FUNCTIONNAME));
        }
        this.name = state.parameters.getString(base.push(P_FUNCTIONNAME), def.push(P_FUNCTIONNAME));
        if (this.name == null || this.name.equals("")) {
            this.name = "ADF" + (this.associatedTree - 1);
            state.output.warning("ADF/ADM node for Tree " + this.associatedTree + " has no function name.  Using the name " + this.name(), base.push(P_FUNCTIONNAME), def.push(P_FUNCTIONNAME));
        }
        if (this.name.length() == 1) {
            state.output.warning("Using old-style ADF/ADM name.  You should change it to something longer and more descriptive, such as ADF" + this.name, base.push(P_FUNCTIONNAME), def.push(P_FUNCTIONNAME));
        }
        super.setup(state, base);
    }

    public String toString() {
        return this.name();
    }

    public void eval(EvolutionState state, int thread, GPData input, ADFStack stack, GPIndividual individual, Problem problem) {
        ADFContext c = stack.get();
        c.prepareADF(this);
        for (int x = 0; x < this.children.length; ++x) {
            input.copyTo(c.arguments[x]);
            this.children[x].eval(state, thread, c.arguments[x], stack, individual, problem);
        }
        stack.push(c);
        individual.trees[this.associatedTree].child.eval(state, thread, input, stack, individual, problem);
        if (stack.pop(1) != 1) {
            state.output.fatal("Stack prematurely empty for " + this.toStringForError());
        }
    }
}

