/*
 * Decompiled with CFR 0.152.
 */
package ec.gp.breed;

import ec.BreedingPipeline;
import ec.EvolutionState;
import ec.Individual;
import ec.gp.GPBreedingPipeline;
import ec.gp.GPFunctionSet;
import ec.gp.GPIndividual;
import ec.gp.GPInitializer;
import ec.gp.GPNode;
import ec.gp.GPNodeGatherer;
import ec.gp.GPTree;
import ec.gp.GPType;
import ec.gp.breed.GPBreedDefaults;
import ec.util.Parameter;

public class MutateDemotePipeline
extends GPBreedingPipeline {
    public static final String P_MUTATEDEMOTE = "mutate-demote";
    public static final String P_NUM_TRIES = "tries";
    public static final String P_MAXDEPTH = "maxdepth";
    public static final int NUM_SOURCES = 1;
    int numTries;
    int maxDepth;
    int tree;
    private GPNodeGatherer gatherer = new GPNodeGatherer();
    private GPNode demotableNode;

    public Parameter defaultBase() {
        return GPBreedDefaults.base().push(P_MUTATEDEMOTE);
    }

    public int numSources() {
        return 1;
    }

    public void setup(EvolutionState state, Parameter base) {
        super.setup(state, base);
        Parameter def = this.defaultBase();
        this.numTries = state.parameters.getInt(base.push(P_NUM_TRIES), def.push(P_NUM_TRIES), 1);
        if (this.numTries == 0) {
            state.output.fatal("MutateDemotePipeline has an invalid number of tries (it must be >= 1).", base.push(P_NUM_TRIES), def.push(P_NUM_TRIES));
        }
        this.maxDepth = state.parameters.getInt(base.push(P_MAXDEPTH), def.push(P_MAXDEPTH), 1);
        if (this.maxDepth == 0) {
            state.output.fatal("The MutateDemotePipeline " + base + "has an invalid maximum depth (it must be >= 1).", base.push(P_MAXDEPTH), def.push(P_MAXDEPTH));
        }
        this.tree = -1;
        if (state.parameters.exists(base.push("tree").push("0"), def.push("tree").push("0"))) {
            this.tree = state.parameters.getInt(base.push("tree").push("0"), def.push("tree").push("0"), 0);
            if (this.tree == -1) {
                state.output.fatal("Tree fixed value, if defined, must be >= 0");
            }
        }
    }

    public Object clone() {
        MutateDemotePipeline obj = (MutateDemotePipeline)super.clone();
        obj.gatherer = new GPNodeGatherer();
        return obj;
    }

    private boolean demotable(GPInitializer initializer, GPNode node, GPFunctionSet set) {
        GPType t = node.parent instanceof GPNode ? ((GPNode)node.parent).constraints((GPInitializer)initializer).childtypes[node.argposition] : ((GPTree)node.parent).constraints((GPInitializer)initializer).treetype;
        for (int x = 0; x < set.nonterminals[t.type].length; ++x) {
            for (int y = 0; y < set.nonterminals[t.type][x].constraints((GPInitializer)initializer).childtypes.length; ++y) {
                if (!set.nonterminals[t.type][x].constraints((GPInitializer)initializer).childtypes[y].compatibleWith(initializer, node.constraints((GPInitializer)initializer).returntype)) continue;
                return true;
            }
        }
        return false;
    }

    private void demoteSomething(GPNode node, EvolutionState state, int thread, GPFunctionSet set) {
        if (((GPInitializer)state.initializer).numAtomicTypes + ((GPInitializer)state.initializer).numSetTypes == 1) {
            this._demoteSomethingTypeless(node, state, thread, set);
        } else {
            this._demoteSomething(node, state, thread, set);
        }
    }

    private void _demoteSomething(GPNode node, EvolutionState state, int thread, GPFunctionSet set) {
        int numDemotable = 0;
        GPInitializer initializer = (GPInitializer)state.initializer;
        GPType t = node.parent instanceof GPNode ? ((GPNode)node.parent).constraints((GPInitializer)initializer).childtypes[node.argposition] : ((GPTree)node.parent).constraints((GPInitializer)initializer).treetype;
        block0: for (int x = 0; x < set.nonterminals[t.type].length; ++x) {
            for (int y = 0; y < set.nonterminals[t.type][x].constraints((GPInitializer)initializer).childtypes.length; ++y) {
                if (!set.nonterminals[t.type][x].constraints((GPInitializer)initializer).childtypes[y].compatibleWith(initializer, node.constraints((GPInitializer)initializer).returntype)) continue;
                ++numDemotable;
                continue block0;
            }
        }
        int demoteItem = state.random[thread].nextInt(numDemotable);
        numDemotable = 0;
        block2: for (int x = 0; x < set.nonterminals[t.type].length; ++x) {
            for (int y = 0; y < set.nonterminals[t.type][x].constraints((GPInitializer)initializer).childtypes.length; ++y) {
                if (!set.nonterminals[t.type][x].constraints((GPInitializer)initializer).childtypes[y].compatibleWith(initializer, node.constraints((GPInitializer)initializer).returntype)) continue;
                if (numDemotable == demoteItem) {
                    GPNode cnode = set.nonterminals[t.type][x].lightClone();
                    int numSpots = 0;
                    GPType retyp = node.constraints((GPInitializer)initializer).returntype;
                    GPType[] chityp = cnode.constraints((GPInitializer)initializer).childtypes;
                    for (int z = 0; z < cnode.children.length; ++z) {
                        if (!chityp[z].compatibleWith(initializer, retyp)) continue;
                        ++numSpots;
                    }
                    int choice = state.random[thread].nextInt(numSpots);
                    numSpots = 0;
                    for (int z = 0; z < cnode.children.length; ++z) {
                        GPNode term;
                        if (chityp[z].compatibleWith(initializer, retyp)) {
                            if (numSpots == choice) {
                                cnode.parent = node.parent;
                                cnode.argposition = node.argposition;
                                cnode.children[z] = node;
                                node.parent = cnode;
                                node.argposition = (byte)z;
                                if (cnode.parent instanceof GPNode) {
                                    ((GPNode)cnode.parent).children[cnode.argposition] = cnode;
                                } else {
                                    ((GPTree)cnode.parent).child = cnode;
                                }
                                ++numSpots;
                                continue;
                            }
                            cnode.children[z] = term = set.terminals[chityp[z].type][state.random[thread].nextInt(set.terminals[chityp[z].type].length)].lightClone();
                            term.parent = cnode;
                            term.argposition = (byte)z;
                            term.resetNode(state, thread);
                            ++numSpots;
                            continue;
                        }
                        cnode.children[z] = term = set.terminals[chityp[z].type][state.random[thread].nextInt(set.terminals[chityp[z].type].length)].lightClone();
                        term.parent = cnode;
                        term.argposition = (byte)z;
                        term.resetNode(state, thread);
                    }
                    return;
                }
                ++numDemotable;
                continue block2;
            }
        }
        throw new InternalError("Bug in demoteSomething -- should never be able to reach the end of the function");
    }

    private void _demoteSomethingTypeless(GPNode node, EvolutionState state, int thread, GPFunctionSet set) {
        int numDemotable = 0;
        numDemotable = set.nonterminals[0].length;
        int demoteItem = state.random[thread].nextInt(numDemotable);
        numDemotable = 0;
        GPNode cnode = set.nonterminals[0][demoteItem].lightClone();
        GPType[] chityp = cnode.constraints((GPInitializer)((GPInitializer)state.initializer)).childtypes;
        int choice = state.random[thread].nextInt(cnode.children.length);
        for (int z = 0; z < cnode.children.length; ++z) {
            GPNode term;
            if (z == choice) {
                cnode.parent = node.parent;
                cnode.argposition = node.argposition;
                cnode.children[z] = node;
                node.parent = cnode;
                node.argposition = (byte)z;
                if (cnode.parent instanceof GPNode) {
                    ((GPNode)cnode.parent).children[cnode.argposition] = cnode;
                    continue;
                }
                ((GPTree)cnode.parent).child = cnode;
                continue;
            }
            cnode.children[z] = term = set.terminals[chityp[z].type][state.random[thread].nextInt(set.terminals[chityp[z].type].length)].lightClone();
            term.parent = cnode;
            term.argposition = (byte)z;
            term.resetNode(state, thread);
        }
    }

    private int numDemotableNodes(GPInitializer initializer, GPNode root, int soFar, GPFunctionSet set) {
        if (initializer.numAtomicTypes + initializer.numSetTypes == 1) {
            return root.numNodes(0);
        }
        return this._numDemotableNodes(initializer, root, soFar, set);
    }

    private int _numDemotableNodes(GPInitializer initializer, GPNode root, int soFar, GPFunctionSet set) {
        if (this.demotable(initializer, root, set)) {
            ++soFar;
        }
        for (int x = 0; x < root.children.length; ++x) {
            soFar = this._numDemotableNodes(initializer, root.children[x], soFar, set);
        }
        return soFar;
    }

    private int pickDemotableNode(GPInitializer initializer, GPNode root, int num, GPFunctionSet set) {
        if (initializer.numAtomicTypes + initializer.numSetTypes == 1) {
            this.gatherer.node = null;
            root.nodeInPosition(num, this.gatherer, 0);
            if (this.gatherer.node == null) {
                throw new InternalError("Internal error in pickDemotableNode, nodeInPosition didn't find a node!");
            }
            this.demotableNode = this.gatherer.node;
            return -1;
        }
        return this._pickDemotableNode(initializer, root, num, set);
    }

    private int _pickDemotableNode(GPInitializer initializer, GPNode root, int num, GPFunctionSet set) {
        if (this.demotable(initializer, root, set) && --num == -1) {
            this.demotableNode = root;
            return num;
        }
        for (int x = 0; x < root.children.length && (num = this._pickDemotableNode(initializer, root.children[x], num, set)) != -1; ++x) {
        }
        return num;
    }

    private boolean verifyPoint(GPNode inner1) {
        return inner1.depth() + inner1.atDepth() + 1 <= this.maxDepth;
    }

    public int produce(int min, int max, int start, int subpopulation, Individual[] inds, EvolutionState state, int thread) {
        int n = this.sources[0].produce(min, max, start, subpopulation, inds, state, thread);
        if (!state.random[thread].nextBoolean(this.likelihood)) {
            return this.reproduce(n, start, subpopulation, inds, state, thread, false);
        }
        GPInitializer initializer = (GPInitializer)state.initializer;
        for (int q = start; q < n + start; ++q) {
            int x;
            GPIndividual j;
            GPIndividual i = (GPIndividual)inds[q];
            if (this.tree != -1 && (this.tree < 0 || this.tree >= i.trees.length)) {
                state.output.fatal("MutateDemotePipeline attempted to fix tree.0 to a value which was out of bounds of the array of the individual's trees.  Check the pipeline's fixed tree values -- they may be negative or greater than the number of trees in an individual");
            }
            if (this.sources[0] instanceof BreedingPipeline) {
                j = i;
            } else {
                j = i.lightClone();
                j.trees = new GPTree[i.trees.length];
                for (x = 0; x < j.trees.length; ++x) {
                    j.trees[x] = i.trees[x].lightClone();
                    j.trees[x].owner = j;
                    j.trees[x].child = (GPNode)i.trees[x].child.clone();
                    j.trees[x].child.parent = j.trees[x];
                    j.trees[x].child.argposition = 0;
                }
            }
            for (x = 0; x < this.numTries; ++x) {
                int t = this.tree == -1 ? (i.trees.length > 1 ? state.random[thread].nextInt(i.trees.length) : 0) : this.tree;
                int numdemote = this.numDemotableNodes(initializer, j.trees[t].child, 0, j.trees[t].constraints((GPInitializer)initializer).functionset);
                if (numdemote == 0) continue;
                this.pickDemotableNode(initializer, j.trees[t].child, state.random[thread].nextInt(numdemote), j.trees[t].constraints((GPInitializer)initializer).functionset);
                if (!this.verifyPoint(this.demotableNode)) continue;
                this.demoteSomething(this.demotableNode, state, thread, j.trees[t].constraints((GPInitializer)initializer).functionset);
                j.evaluated = false;
                break;
            }
            inds[q] = j;
        }
        return n;
    }
}

