/*
 * Decompiled with CFR 0.152.
 */
package ec.gp.breed;

import ec.BreedingPipeline;
import ec.EvolutionState;
import ec.Individual;
import ec.gp.ERC;
import ec.gp.GPBreedingPipeline;
import ec.gp.GPIndividual;
import ec.gp.GPNode;
import ec.gp.GPNodeSelector;
import ec.gp.GPTree;
import ec.gp.breed.GPBreedDefaults;
import ec.util.Parameter;

public class MutateERCPipeline
extends GPBreedingPipeline {
    public static final String P_MUTATEERC = "mutate-erc";
    public static final int NUM_SOURCES = 1;
    public GPNodeSelector nodeselect;
    int tree;

    public Parameter defaultBase() {
        return GPBreedDefaults.base().push(P_MUTATEERC);
    }

    public int numSources() {
        return 1;
    }

    public Object clone() {
        MutateERCPipeline c = (MutateERCPipeline)super.clone();
        c.nodeselect = (GPNodeSelector)this.nodeselect.clone();
        return c;
    }

    public void setup(EvolutionState state, Parameter base) {
        super.setup(state, base);
        Parameter p = base.push("ns").push("0");
        Parameter def = this.defaultBase();
        this.nodeselect = (GPNodeSelector)state.parameters.getInstanceForParameter(p, def.push("ns").push("0"), GPNodeSelector.class);
        this.nodeselect.setup(state, p);
        this.tree = -1;
        if (state.parameters.exists(base.push("tree").push("0"), def.push("tree").push("0"))) {
            this.tree = state.parameters.getInt(base.push("tree").push("0"), def.push("tree").push("0"), 0);
            if (this.tree == -1) {
                state.output.fatal("Tree fixed value, if defined, must be >= 0");
            }
        }
    }

    public final void mutateERCs(GPNode node, EvolutionState state, int thread) {
        if (node instanceof ERC) {
            ((ERC)node).mutateERC(state, thread);
        }
        for (int x = 0; x < node.children.length; ++x) {
            this.mutateERCs(node.children[x], state, thread);
        }
    }

    public int produce(int min, int max, int start, int subpopulation, Individual[] inds, EvolutionState state, int thread) {
        int n = this.sources[0].produce(min, max, start, subpopulation, inds, state, thread);
        if (!state.random[thread].nextBoolean(this.likelihood)) {
            return this.reproduce(n, start, subpopulation, inds, state, thread, false);
        }
        for (int q = start; q < n + start; ++q) {
            GPIndividual j;
            GPIndividual i = (GPIndividual)inds[q];
            if (this.tree != -1 && (this.tree < 0 || this.tree >= i.trees.length)) {
                state.output.fatal("MutateERCPipeline attempted to fix tree.0 to a value which was out of bounds of the array of the individual's trees.  Check the pipeline's fixed tree values -- they may be negative or greater than the number of trees in an individual");
            }
            int t = this.tree == -1 ? (i.trees.length > 1 ? state.random[thread].nextInt(i.trees.length) : 0) : this.tree;
            if (this.sources[0] instanceof BreedingPipeline) {
                j = i;
            } else {
                j = i.lightClone();
                j.trees = new GPTree[i.trees.length];
                for (int x = 0; x < j.trees.length; ++x) {
                    j.trees[x] = i.trees[x].lightClone();
                    j.trees[x].owner = j;
                    j.trees[x].child = (GPNode)i.trees[x].child.clone();
                    j.trees[x].child.parent = j.trees[x];
                    j.trees[x].child.argposition = 0;
                }
            }
            j.evaluated = false;
            this.nodeselect.reset();
            GPNode p = this.nodeselect.pickNode(state, subpopulation, thread, j, j.trees[t]);
            this.mutateERCs(p, state, thread);
            inds[q] = j;
        }
        return n;
    }
}

