/*
 * Decompiled with CFR 0.152.
 */
package ec.gp.koza;

import ec.EvolutionState;
import ec.gp.GPFunctionSet;
import ec.gp.GPNode;
import ec.gp.GPNodeParent;
import ec.gp.GPType;
import ec.gp.koza.GPKozaDefaults;
import ec.gp.koza.KozaBuilder;
import ec.util.Parameter;

public class HalfBuilder
extends KozaBuilder {
    public static final String P_HALFBUILDER = "half";
    public static final String P_PICKGROWPROBABILITY = "growp";
    public float pickGrowProbability;

    public Parameter defaultBase() {
        return GPKozaDefaults.base().push(P_HALFBUILDER);
    }

    public void setup(EvolutionState state, Parameter base) {
        super.setup(state, base);
        Parameter def = this.defaultBase();
        this.pickGrowProbability = state.parameters.getFloatWithMax(base.push(P_PICKGROWPROBABILITY), def.push(P_PICKGROWPROBABILITY), 0.0, 1.0);
        if (this.pickGrowProbability < 0.0f) {
            state.output.fatal("The Pick-Grow Probability for HalfBuilder must be a floating-point value between 0.0 and 1.0 inclusive.", base.push("max-depth"), def.push("max-depth"));
        }
    }

    public GPNode newRootedTree(EvolutionState state, GPType type, int thread, GPNodeParent parent, GPFunctionSet set, int argposition, int requestedSize) {
        if (state.random[thread].nextFloat() < this.pickGrowProbability) {
            return this.growNode(state, 0, state.random[thread].nextInt(this.maxDepth - this.minDepth + 1) + this.minDepth, type, thread, parent, argposition, set);
        }
        return this.fullNode(state, 0, state.random[thread].nextInt(this.maxDepth - this.minDepth + 1) + this.minDepth, type, thread, parent, argposition, set);
    }
}

