/*
 * Decompiled with CFR 0.152.
 */
package ec.multiobjective;

import ec.EvolutionState;
import ec.Fitness;
import ec.Individual;
import ec.multiobjective.MultiObjectiveDefaults;
import ec.util.Code;
import ec.util.DecodeReturn;
import ec.util.Parameter;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.io.LineNumberReader;
import java.util.ArrayList;

public class MultiObjectiveFitness
extends Fitness {
    public static final String MULTI_FITNESS_POSTAMBLE = "[";
    public static final String FITNESS_POSTAMBLE = "]";
    public static final String P_NUMOBJECTIVES = "num-objectives";
    public static final String P_MAXOBJECTIVES = "max";
    public static final String P_MINOBJECTIVES = "min";
    public static final String P_MAXIMIZE = "maximize";
    public float[] maxObjective;
    public float[] minObjective;
    protected float[] objectives;
    protected boolean maximize = true;

    public String[] getAuxilliaryFitnessNames() {
        return new String[0];
    }

    public double[] getAuxilliaryFitnessValues() {
        return new double[0];
    }

    public boolean isMaximizing() {
        return this.maximize;
    }

    public int getNumObjectives() {
        return this.objectives.length;
    }

    public float[] getObjectives() {
        return this.objectives;
    }

    public float getObjective(int i) {
        return this.objectives[i];
    }

    public void setObjectives(EvolutionState state, float[] newObjectives) {
        if (newObjectives == null) {
            state.output.fatal("Null objective array provided to MultiObjectiveFitness.");
        }
        if (newObjectives.length != this.objectives.length) {
            state.output.fatal("New objective array length does not match current length.");
        }
        for (int i = 0; i < newObjectives.length; ++i) {
            float _f = newObjectives[i];
            if (_f != Float.POSITIVE_INFINITY && _f != Float.NEGATIVE_INFINITY && !Float.isNaN(_f)) continue;
            state.output.warning("Bad objective #" + i + ": " + _f + ", setting to worst value for that objective.");
            newObjectives[i] = this.maximize ? this.minObjective[i] : this.maxObjective[i];
        }
        this.objectives = newObjectives;
    }

    public Parameter defaultBase() {
        return MultiObjectiveDefaults.base().push("fitness");
    }

    public Object clone() {
        MultiObjectiveFitness f = (MultiObjectiveFitness)super.clone();
        f.objectives = (float[])this.objectives.clone();
        return f;
    }

    public float fitness() {
        float fit = this.objectives[0];
        for (int x = 1; x < this.objectives.length; ++x) {
            if (!(fit < this.objectives[x])) continue;
            fit = this.objectives[x];
        }
        return fit;
    }

    public void setup(EvolutionState state, Parameter base) {
        super.setup(state, base);
        Parameter def = this.defaultBase();
        int numFitnesses = state.parameters.getInt(base.push(P_NUMOBJECTIVES), def.push(P_NUMOBJECTIVES), 0);
        if (numFitnesses <= 0) {
            state.output.fatal("The number of objectives must be an integer >= 1.", base.push(P_NUMOBJECTIVES), def.push(P_NUMOBJECTIVES));
        }
        this.maximize = state.parameters.getBoolean(base.push(P_MAXIMIZE), def.push(P_MAXIMIZE), true);
        this.objectives = new float[numFitnesses];
        this.maxObjective = new float[numFitnesses];
        this.minObjective = new float[numFitnesses];
        for (int i = 0; i < numFitnesses; ++i) {
            this.minObjective[i] = state.parameters.getFloatWithDefault(base.push(P_MINOBJECTIVES), def.push(P_MINOBJECTIVES), 0.0);
            this.maxObjective[i] = state.parameters.getFloatWithDefault(base.push(P_MAXOBJECTIVES), def.push(P_MAXOBJECTIVES), 1.0);
            this.minObjective[i] = state.parameters.getFloatWithDefault(base.push(P_MINOBJECTIVES).push("" + i), def.push(P_MINOBJECTIVES).push("" + i), this.minObjective[i]);
            this.maxObjective[i] = state.parameters.getFloatWithDefault(base.push(P_MAXOBJECTIVES).push("" + i), def.push(P_MAXOBJECTIVES).push("" + i), this.maxObjective[i]);
            if (!(this.minObjective[i] >= this.maxObjective[i])) continue;
            state.output.error("For objective " + i + "the min fitness must be strictly less than the max fitness.");
        }
        state.output.exitIfErrors();
    }

    public boolean isIdealFitness() {
        return false;
    }

    public boolean equivalentTo(Fitness _fitness) {
        MultiObjectiveFitness other = (MultiObjectiveFitness)_fitness;
        boolean abeatsb = false;
        boolean bbeatsa = false;
        if (this.maximize != other.maximize) {
            throw new RuntimeException("Attempt made to compare two multiobjective fitnesses; but one expects higher values to be better and the other expectes lower values to be better.");
        }
        if (this.objectives.length != other.objectives.length) {
            throw new RuntimeException("Attempt made to compare two multiobjective fitnesses; but they have different numbers of objectives.");
        }
        if (this.maximize) {
            for (int x = 0; x < this.objectives.length; ++x) {
                if (this.objectives[x] > other.objectives[x]) {
                    abeatsb = true;
                }
                if (this.objectives[x] < other.objectives[x]) {
                    bbeatsa = true;
                }
                if (!abeatsb || !bbeatsa) continue;
                return true;
            }
        } else {
            for (int x = 0; x < this.objectives.length; ++x) {
                if (this.objectives[x] < other.objectives[x]) {
                    abeatsb = true;
                }
                if (this.objectives[x] > other.objectives[x]) {
                    bbeatsa = true;
                }
                if (!abeatsb || !bbeatsa) continue;
                return true;
            }
        }
        return !abeatsb && !bbeatsa;
    }

    public boolean betterThan(Fitness fitness) {
        return this.paretoDominates((MultiObjectiveFitness)fitness);
    }

    public boolean paretoDominates(MultiObjectiveFitness other) {
        boolean abeatsb = false;
        if (this.maximize != other.maximize) {
            throw new RuntimeException("Attempt made to compare two multiobjective fitnesses; but one expects higher values to be better and the other expectes lower values to be better.");
        }
        if (this.objectives.length != other.objectives.length) {
            throw new RuntimeException("Attempt made to compare two multiobjective fitnesses; but they have different numbers of objectives.");
        }
        if (this.maximize) {
            for (int x = 0; x < this.objectives.length; ++x) {
                if (this.objectives[x] > other.objectives[x]) {
                    abeatsb = true;
                    continue;
                }
                if (!(this.objectives[x] < other.objectives[x])) continue;
                return false;
            }
        } else {
            for (int x = 0; x < this.objectives.length; ++x) {
                if (this.objectives[x] < other.objectives[x]) {
                    abeatsb = true;
                    continue;
                }
                if (!(this.objectives[x] > other.objectives[x])) continue;
                return false;
            }
        }
        return abeatsb;
    }

    static void yank(int val, ArrayList list) {
        int size = list.size();
        list.set(val, list.get(size - 1));
        list.remove(size - 1);
    }

    public static ArrayList partitionIntoParetoFront(Individual[] inds, ArrayList front, ArrayList nonFront) {
        if (front == null) {
            front = new ArrayList<Individual>();
        }
        front.add(inds[0]);
        for (int i = 1; i < inds.length; ++i) {
            Individual ind = inds[i];
            boolean noOneWasBetter = true;
            int frontSize = front.size();
            for (int j = 0; j < frontSize; ++j) {
                Individual frontmember = (Individual)front.get(j);
                if (((MultiObjectiveFitness)frontmember.fitness).paretoDominates((MultiObjectiveFitness)ind.fitness)) {
                    if (nonFront != null) {
                        nonFront.add(ind);
                    }
                    noOneWasBetter = false;
                    break;
                }
                if (!((MultiObjectiveFitness)ind.fitness).paretoDominates((MultiObjectiveFitness)frontmember.fitness)) continue;
                MultiObjectiveFitness.yank(j, front);
                --frontSize;
                --j;
                if (nonFront == null) continue;
                nonFront.add(frontmember);
            }
            if (!noOneWasBetter) continue;
            front.add(ind);
        }
        return front;
    }

    public static ArrayList partitionIntoRanks(Individual[] inds) {
        Individual[] dummy = new Individual[]{};
        ArrayList frontsByRank = new ArrayList();
        while (inds.length > 0) {
            ArrayList front = new ArrayList();
            ArrayList nonFront = new ArrayList();
            MultiObjectiveFitness.partitionIntoParetoFront(inds, front, nonFront);
            inds = nonFront.toArray(dummy);
            frontsByRank.add(front);
        }
        return frontsByRank;
    }

    public double sumSquaredObjectiveDistance(MultiObjectiveFitness other) {
        double s = 0.0;
        for (int i = 0; i < this.objectives.length; ++i) {
            double a = this.objectives[i] - other.objectives[i];
            s += a * a;
        }
        return s;
    }

    public double manhattanObjectiveDistance(MultiObjectiveFitness other) {
        double s = 0.0;
        for (int i = 0; i < this.objectives.length; ++i) {
            s += (double)Math.abs(this.objectives[i] - other.objectives[i]);
        }
        return s;
    }

    public String fitnessToString() {
        String s = "Fitness: [";
        for (int x = 0; x < this.objectives.length; ++x) {
            if (x > 0) {
                s = s + " ";
            }
            s = s + Code.encode(this.objectives[x]);
        }
        s = s + " ";
        s = s + Code.encode(this.maximize);
        return s + FITNESS_POSTAMBLE;
    }

    public String fitnessToStringForHumans() {
        String s = "Fitness: [";
        for (int x = 0; x < this.objectives.length; ++x) {
            if (x > 0) {
                s = s + " ";
            }
            s = s + this.objectives[x];
        }
        s = s + " ";
        s = s + (this.maximize ? P_MAXOBJECTIVES : P_MINOBJECTIVES);
        return s + FITNESS_POSTAMBLE;
    }

    public void readFitness(EvolutionState state, LineNumberReader reader) throws IOException {
        DecodeReturn d = Code.checkPreamble("Fitness: [", state, reader);
        for (int x = 0; x < this.objectives.length; ++x) {
            Code.decode(d);
            if (d.type != 6) {
                state.output.fatal("Reading Line " + d.lineNumber + ": " + "Bad Fitness (objectives value #" + x + ").");
            }
            this.objectives[x] = (float)d.d;
        }
        Code.decode(d);
        if (d.type != 0) {
            state.output.fatal("Reading Line " + d.lineNumber + ": " + "Information missing about whether higher is better");
        }
        this.maximize = d.l != 0L;
    }

    public void writeFitness(EvolutionState state, DataOutput dataOutput) throws IOException {
        dataOutput.writeInt(this.objectives.length);
        for (int x = 0; x < this.objectives.length; ++x) {
            dataOutput.writeFloat(this.objectives[x]);
        }
        dataOutput.writeBoolean(this.maximize);
    }

    public void readFitness(EvolutionState state, DataInput dataInput) throws IOException {
        int len = dataInput.readInt();
        if (this.objectives == null || this.objectives.length != len) {
            this.objectives = new float[len];
        }
        for (int x = 0; x < this.objectives.length; ++x) {
            this.objectives[x] = dataInput.readFloat();
        }
        this.maximize = dataInput.readBoolean();
    }
}

