/*
 * Decompiled with CFR 0.152.
 */
package ec.multiobjective;

import ec.EvolutionState;
import ec.Individual;
import ec.multiobjective.MultiObjectiveFitness;
import ec.simple.SimpleStatistics;
import ec.util.Parameter;
import ec.util.QuickSort;
import ec.util.SortComparator;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;

public class MultiObjectiveStatistics
extends SimpleStatistics {
    public static final String P_PARETO_FRONT_FILE = "front";
    public static final int NO_FRONT_LOG = -1;
    public int frontLog;

    public void setup(EvolutionState state, Parameter base) {
        super.setup(state, base);
        File frontFile = state.parameters.getFile(base.push(P_PARETO_FRONT_FILE), null);
        if (frontFile != null) {
            try {
                this.frontLog = state.output.addLog(frontFile, !this.compress, this.compress);
            }
            catch (IOException i) {
                state.output.fatal("An IOException occurred while trying to create the log " + frontFile + ":\n" + i);
            }
        } else {
            state.output.warning("No Pareto Front statistics file specified.", base.push(P_PARETO_FRONT_FILE));
        }
    }

    public void finalStatistics(EvolutionState state, int result) {
        state.output.println("\n\n\n PARETO FRONTS", this.statisticslog);
        for (int s = 0; s < state.population.subpops.length; ++s) {
            int f;
            int i;
            MultiObjectiveFitness typicalFitness = (MultiObjectiveFitness)state.population.subpops[s].individuals[0].fitness;
            state.output.println("\n\nPareto Front of Subpopulation " + s, this.statisticslog);
            ArrayList front = MultiObjectiveFitness.partitionIntoParetoFront(state.population.subpops[s].individuals, null, null);
            Object[] sortedFront = front.toArray();
            QuickSort.qsort(sortedFront, new SortComparator(){

                public boolean lt(Object a, Object b) {
                    return ((MultiObjectiveFitness)((Individual)a).fitness).getObjective(0) < ((MultiObjectiveFitness)((Individual)b).fitness).getObjective(0);
                }

                public boolean gt(Object a, Object b) {
                    return ((MultiObjectiveFitness)((Individual)a).fitness).getObjective(0) > ((MultiObjectiveFitness)((Individual)b).fitness).getObjective(0);
                }
            });
            state.output.message("Pareto Front Summary: " + sortedFront.length + " Individuals");
            String message = "Ind";
            int numObjectives = typicalFitness.getObjectives().length;
            for (int i2 = 0; i2 < numObjectives; ++i2) {
                message = message + "\tObjective " + i2;
            }
            String[] names = typicalFitness.getAuxilliaryFitnessNames();
            for (i = 0; i < names.length; ++i) {
                message = message + "\t" + names[i];
            }
            state.output.message(message);
            for (i = 0; i < sortedFront.length; ++i) {
                Individual individual = (Individual)sortedFront[i];
                float[] objectives = ((MultiObjectiveFitness)individual.fitness).getObjectives();
                String line = "" + i;
                for (int f2 = 0; f2 < objectives.length; ++f2) {
                    line = line + "\t" + objectives[f2];
                }
                double[] vals = ((MultiObjectiveFitness)individual.fitness).getAuxilliaryFitnessValues();
                for (f = 0; f < vals.length; ++f) {
                    line = line + "\t" + vals[f];
                }
                state.output.message(line);
            }
            for (i = 0; i < sortedFront.length; ++i) {
                ((Individual)sortedFront[i]).printIndividualForHumans(state, this.statisticslog);
            }
            if (this.frontLog < 0) continue;
            if (state.population.subpops.length > 1) {
                state.output.println("Subpopulation " + s, this.frontLog);
            }
            for (i = 0; i < sortedFront.length; ++i) {
                Individual ind = (Individual)sortedFront[i];
                MultiObjectiveFitness mof = (MultiObjectiveFitness)ind.fitness;
                float[] objectives = mof.getObjectives();
                String line = "";
                for (f = 0; f < objectives.length; ++f) {
                    line = line + objectives[f] + " ";
                }
                state.output.println(line, this.frontLog);
            }
        }
    }
}

