/*
 * Decompiled with CFR 0.152.
 */
package ec.multiobjective.nsga2;

import ec.EvolutionState;
import ec.Individual;
import ec.Population;
import ec.Subpopulation;
import ec.simple.SimpleBreeder;
import ec.util.Parameter;

public class NSGA2Breeder
extends SimpleBreeder {
    public void setup(EvolutionState state, Parameter base) {
        super.setup(state, base);
        for (int i = 0; i < this.elite.length; ++i) {
            if (this.elite[i] == 0) continue;
            state.output.warning("Elites may not be used with NSGA2Breeder, and will be ignored.");
        }
    }

    public Population breedPopulation(EvolutionState state) {
        Population oldPop = state.population;
        Population newPop = super.breedPopulation(state);
        Subpopulation[] subpops = oldPop.subpops;
        int subpopsLength = subpops.length;
        for (int i = 0; i < subpopsLength; ++i) {
            Subpopulation oldSubpop = oldPop.subpops[i];
            Subpopulation newSubpop = newPop.subpops[i];
            Individual[] combinedInds = new Individual[oldSubpop.individuals.length + newSubpop.individuals.length];
            System.arraycopy(newSubpop.individuals, i, combinedInds, i, newSubpop.individuals.length);
            System.arraycopy(oldSubpop.individuals, i, combinedInds, newSubpop.individuals.length, oldSubpop.individuals.length);
            newSubpop.individuals = combinedInds;
        }
        return newPop;
    }
}

