/*
 * Decompiled with CFR 0.152.
 */
package ec.multiobjective.spea2;

import ec.EvolutionState;
import ec.Individual;
import ec.Population;
import ec.multiobjective.MultiObjectiveFitness;
import ec.multiobjective.spea2.SPEA2Evaluator;
import ec.multiobjective.spea2.SPEA2MultiObjectiveFitness;
import ec.simple.SimpleBreeder;
import ec.util.Parameter;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;

public class SPEA2Breeder
extends SimpleBreeder {
    protected void loadElites(EvolutionState state, Population newpop) {
        for (int x = 0; x < state.population.subpops.length; ++x) {
            if (this.elite[x] <= state.population.subpops[x].individuals.length) continue;
            state.output.error("The number of elites for subpopulation " + x + " exceeds the actual size of the subpopulation", new Parameter("breed").push("elite").push("" + x));
        }
        state.output.exitIfErrors();
        for (int sub = 0; sub < state.population.subpops.length; ++sub) {
            Individual[] newInds = newpop.subpops[sub].individuals;
            Individual[] oldInds = state.population.subpops[sub].individuals;
            this.buildArchive(state, oldInds, newInds, this.elite[sub]);
        }
        this.unmarkElitesEvaluated(newpop);
    }

    public double[] calculateDistancesFromIndividual(Individual ind, Individual[] inds) {
        double[] d = new double[inds.length];
        for (int i = 0; i < inds.length; ++i) {
            d[i] = ((SPEA2MultiObjectiveFitness)ind.fitness).sumSquaredObjectiveDistance((SPEA2MultiObjectiveFitness)inds[i].fitness);
        }
        Arrays.sort(d);
        return d;
    }

    public void buildArchive(EvolutionState state, Individual[] oldInds, Individual[] newInds, int archiveSize) {
        Individual[] dummy = new Individual[]{};
        ArrayList archive = new ArrayList();
        ArrayList nonFront = new ArrayList();
        MultiObjectiveFitness.partitionIntoParetoFront(oldInds, archive, nonFront);
        int currentArchiveSize = archive.size();
        if (currentArchiveSize < archiveSize) {
            Collections.sort(nonFront);
            int len = archiveSize - currentArchiveSize;
            for (int i = 0; i < len; ++i) {
                archive.add(nonFront.get(i));
                ++currentArchiveSize;
            }
        }
        SPEA2Evaluator evaluator = (SPEA2Evaluator)state.evaluator;
        Individual[] inds = archive.toArray(dummy);
        while (currentArchiveSize > archiveSize) {
            Individual closest = (Individual)archive.get(0);
            int closestIndex = 0;
            double[] closestD = this.calculateDistancesFromIndividual(closest, oldInds);
            block2: for (int i = 1; i < currentArchiveSize; ++i) {
                Individual competitor = (Individual)archive.get(i);
                double[] competitorD = this.calculateDistancesFromIndividual(competitor, oldInds);
                for (int k = 0; k < oldInds.length; ++k) {
                    if (closestD[i] > competitorD[i]) {
                        closest = competitor;
                        closestD = competitorD;
                        closestIndex = k;
                        continue block2;
                    }
                    if (closestD[i] < competitorD[i]) continue block2;
                }
            }
            archive.set(closestIndex, archive.get(archive.size() - 1));
            archive.remove(archive.size() - 1);
            --currentArchiveSize;
        }
        Object[] obj = archive.toArray();
        for (int i = 0; i < archiveSize; ++i) {
            newInds[newInds.length - archiveSize + i] = (Individual)((Individual)obj[i]).clone();
        }
    }
}

