/*
 * Decompiled with CFR 0.152.
 */
package ec.parsimony;

import ec.EvolutionState;
import ec.Individual;
import ec.SelectionMethod;
import ec.select.SelectDefaults;
import ec.steadystate.SteadyStateBSourceForm;
import ec.steadystate.SteadyStateEvolutionState;
import ec.util.Parameter;
import java.util.Arrays;
import java.util.Comparator;

public class RatioBucketTournamentSelection
extends SelectionMethod
implements SteadyStateBSourceForm {
    public static final String P_RATIO_BUCKET_TOURNAMENT = "ratio-bucket-tournament";
    public static final String P_SIZE = "size";
    public static final int DEFAULT_SIZE = 7;
    public int size;
    public static final String P_PICKWORST = "pick-worst";
    public boolean pickWorst;
    public static final String P_RATIO = "ratio";
    static float defaultRATIO = 2.0f;
    public float ratio;
    int[] bucketValues;

    public Parameter defaultBase() {
        return SelectDefaults.base().push(P_RATIO_BUCKET_TOURNAMENT);
    }

    public void setup(EvolutionState state, Parameter base) {
        super.setup(state, base);
        Parameter def = this.defaultBase();
        this.size = state.parameters.getInt(base.push(P_SIZE), def.push(P_SIZE), 1);
        if (this.size < 1) {
            state.output.fatal("Tournament size must be >= 1.", base.push(P_SIZE), def.push(P_SIZE));
        }
        if (state.parameters.exists(base.push(P_RATIO), def.push(P_RATIO))) {
            this.ratio = state.parameters.getFloat(base.push(P_RATIO), def.push(P_RATIO), 2.0);
            if (this.ratio < 2.0f) {
                state.output.fatal("The value of b must be >= 2.", base.push(P_RATIO), def.push(P_RATIO));
            }
        } else {
            this.ratio = defaultRATIO;
        }
        this.pickWorst = state.parameters.getBoolean(base.push(P_PICKWORST), def.push(P_PICKWORST), false);
    }

    public void prepareToProduce(EvolutionState state, int subpopulation, int thread) {
        this.bucketValues = new int[state.population.subpops[subpopulation].individuals.length];
        Arrays.sort(state.population.subpops[subpopulation].individuals, new Comparator(){

            public int compare(Object o1, Object o2) {
                Individual a = (Individual)o1;
                Individual b = (Individual)o2;
                if (a.fitness.betterThan(b.fitness)) {
                    return 1;
                }
                if (b.fitness.betterThan(a.fitness)) {
                    return -1;
                }
                return 0;
            }
        });
        float totalInds = state.population.subpops[subpopulation].individuals.length;
        float averageBuck = Math.max(totalInds / this.ratio, 1.0f);
        this.bucketValues[0] = 0;
        int nInd = 1;
        totalInds -= 1.0f;
        for (int i = 1; i < state.population.subpops[subpopulation].individuals.length; ++i) {
            if ((float)nInd < averageBuck) {
                this.bucketValues[i] = this.bucketValues[i - 1];
                ++nInd;
            } else if (state.population.subpops[subpopulation].individuals[i].fitness.equivalentTo(state.population.subpops[subpopulation].individuals[i - 1].fitness)) {
                this.bucketValues[i] = this.bucketValues[i - 1];
                ++nInd;
            } else {
                averageBuck = Math.max(totalInds / this.ratio, 1.0f);
                this.bucketValues[i] = this.bucketValues[i - 1] - 1;
                nInd = 1;
            }
            totalInds -= 1.0f;
        }
    }

    public int produce(int subpopulation, EvolutionState state, int thread) {
        Individual[] oldinds = state.population.subpops[subpopulation].individuals;
        int i = state.random[thread].nextInt(oldinds.length);
        long si = 0L;
        for (int x = 1; x < this.size; ++x) {
            long sj;
            int j = state.random[thread].nextInt(oldinds.length);
            if (this.pickWorst) {
                if (this.bucketValues[j] > this.bucketValues[i]) {
                    i = j;
                    si = 0L;
                    continue;
                }
                if (this.bucketValues[i] > this.bucketValues[j]) continue;
                if (si == 0L) {
                    si = oldinds[i].size();
                }
                if ((sj = oldinds[j].size()) < si) continue;
                i = j;
                si = sj;
                continue;
            }
            if (this.bucketValues[j] < this.bucketValues[i]) {
                i = j;
                si = 0L;
                continue;
            }
            if (this.bucketValues[i] < this.bucketValues[j]) continue;
            if (si == 0L) {
                si = oldinds[i].size();
            }
            if ((sj = oldinds[j].size()) >= si) continue;
            i = j;
            si = sj;
        }
        return i;
    }

    public void individualReplaced(SteadyStateEvolutionState state, int subpopulation, int thread, int individual) {
    }

    public void sourcesAreProperForm(SteadyStateEvolutionState state) {
    }
}

