/*
 * Decompiled with CFR 0.152.
 */
package ec.pso;

import ec.Breeder;
import ec.EvolutionState;
import ec.Population;
import ec.pso.PSOSubpopulation;
import ec.util.Parameter;
import ec.vector.DoubleVectorIndividual;

public class PSOBreeder
extends Breeder {
    public void setup(EvolutionState state, Parameter base) {
    }

    public Population breedPopulation(EvolutionState state) {
        PSOSubpopulation subpop = (PSOSubpopulation)state.population.subpops[0];
        this.assignPersonalBests(subpop);
        this.assignNeighborhoodBests(subpop);
        this.assignGlobalBest(subpop);
        DoubleVectorIndividual[] tempClone = new DoubleVectorIndividual[subpop.individuals.length];
        System.arraycopy(subpop.individuals, 0, tempClone, 0, subpop.individuals.length);
        for (int i = 0; i < subpop.individuals.length; ++i) {
            DoubleVectorIndividual ind = (DoubleVectorIndividual)subpop.individuals[i];
            DoubleVectorIndividual prevInd = subpop.previousIndividuals[i];
            DoubleVectorIndividual pBest = subpop.personalBests[i];
            DoubleVectorIndividual nBest = subpop.neighborhoodBests[i];
            DoubleVectorIndividual gBest = subpop.globalBest;
            int j = 0;
            while (j < ind.genomeLength()) {
                double velocity = ind.genome[j] - prevInd.genome[j];
                double pDelta = pBest.genome[j] - ind.genome[j];
                double nDelta = nBest.genome[j] - ind.genome[j];
                double gDelta = gBest.genome[j] - ind.genome[j];
                double pWeight = state.random[0].nextDouble();
                double nWeight = state.random[0].nextDouble();
                double gWeight = state.random[0].nextDouble();
                double newDelta = (velocity + pWeight * pDelta + nWeight * nDelta + gWeight * gDelta) / (1.0 + pWeight + nWeight + gWeight);
                int n = j++;
                ind.genome[n] = ind.genome[n] + newDelta * subpop.velocityMultiplier;
            }
            if (!subpop.clampRange) continue;
            ind.clamp();
        }
        subpop.previousIndividuals = tempClone;
        return state.population;
    }

    public void assignPersonalBests(PSOSubpopulation subpop) {
        for (int i = 0; i < subpop.personalBests.length; ++i) {
            if (subpop.personalBests[i] != null && !subpop.individuals[i].fitness.betterThan(subpop.personalBests[i].fitness)) continue;
            subpop.personalBests[i] = (DoubleVectorIndividual)subpop.individuals[i].clone();
        }
    }

    public void assignNeighborhoodBests(PSOSubpopulation subpop) {
        for (int j = 0; j < subpop.individuals.length; ++j) {
            DoubleVectorIndividual hoodBest = subpop.neighborhoodBests[j];
            int start = j - subpop.neighborhoodSize / 2;
            if (start < 0) {
                start += subpop.individuals.length;
            }
            for (int i = 0; i < subpop.neighborhoodSize; ++i) {
                DoubleVectorIndividual ind = (DoubleVectorIndividual)subpop.individuals[(start + i) % subpop.individuals.length];
                if (hoodBest != null && !ind.fitness.betterThan(hoodBest.fitness)) continue;
                hoodBest = ind;
            }
            if (hoodBest == subpop.neighborhoodBests[j]) continue;
            subpop.neighborhoodBests[j] = (DoubleVectorIndividual)hoodBest.clone();
        }
    }

    public void assignGlobalBest(PSOSubpopulation subpop) {
        DoubleVectorIndividual globalBest = subpop.globalBest;
        for (int i = 0; i < subpop.individuals.length; ++i) {
            DoubleVectorIndividual ind = (DoubleVectorIndividual)subpop.individuals[i];
            if (globalBest != null && !ind.fitness.betterThan(globalBest.fitness)) continue;
            globalBest = ind;
        }
        if (globalBest != subpop.globalBest) {
            subpop.globalBest = (DoubleVectorIndividual)globalBest.clone();
        }
    }
}

