/*
 * Decompiled with CFR 0.152.
 */
package ec.pso;

import ec.EvolutionState;
import ec.Subpopulation;
import ec.util.Code;
import ec.util.Parameter;
import ec.vector.DoubleVectorIndividual;
import ec.vector.FloatVectorSpecies;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.io.LineNumberReader;
import java.io.PrintWriter;

public class PSOSubpopulation
extends Subpopulation {
    public int neighborhoodSize;
    public static final String P_NEIGHBORHOOD_SIZE = "neighborhood-size";
    public boolean clampRange;
    public static final String P_CLAMP_RANGE = "clamp";
    public double initialVelocityScale;
    public static final String P_INITIAL_VELOCITY_SCALE = "initial-velocity-scale";
    public double velocityMultiplier;
    public static final String P_VELOCITY_MULTIPLIER = "velocity-multiplier";
    public DoubleVectorIndividual globalBest;
    public DoubleVectorIndividual[] neighborhoodBests;
    public DoubleVectorIndividual[] personalBests;
    public DoubleVectorIndividual[] previousIndividuals;
    public static final String GLOBAL_BEST_PREAMBLE = "Global-Best Individual: ";
    public static final String NEIGHBORHOOD_BEST_PREAMBLE = "Neighborhood Best Individuals: ";
    public static final String PERSONAL_BEST_PREAMBLE = "Personal Best Individuals ";
    public static final String PREVIOUS_INDIVIDUAL_PREAMBLE = "Previous Individuals ";
    public static final String INDIVIDUAL_EXISTS_PREAMBLE = "Exists: ";

    public void setup(EvolutionState state, Parameter base) {
        super.setup(state, base);
        if (!(this.species instanceof FloatVectorSpecies)) {
            state.output.error("PSOSubpopulation requires that its species is ec.vector.FloatVectorSpecies or a subclass.  Yours is: " + this.species.getClass(), null, null);
        }
        if (!(this.species.i_prototype instanceof DoubleVectorIndividual)) {
            state.output.error("PSOSubpopulation requires that its species' prototypical individual be is ec.vector.DoubleVectorSpecies or a subclass.  Yours is: " + this.species.getClass(), null, null);
        }
        this.neighborhoodBests = new DoubleVectorIndividual[this.individuals.length];
        this.personalBests = new DoubleVectorIndividual[this.individuals.length];
        this.previousIndividuals = new DoubleVectorIndividual[this.individuals.length];
        this.neighborhoodSize = state.parameters.getInt(base.push(P_NEIGHBORHOOD_SIZE), null);
        this.clampRange = state.parameters.getBoolean(base.push(P_CLAMP_RANGE), null, false);
        this.initialVelocityScale = state.parameters.getDouble(base.push(P_INITIAL_VELOCITY_SCALE), null, 0.0);
        this.velocityMultiplier = state.parameters.getDouble(base.push(P_VELOCITY_MULTIPLIER), null, 0.1);
    }

    void clear(DoubleVectorIndividual[] inds) {
        for (int x = 0; x < inds.length; ++x) {
            inds[x] = null;
        }
    }

    public void populate(EvolutionState state, int thread) {
        super.populate(state, thread);
        if (this.loadInds == null) {
            this.clear(this.neighborhoodBests);
            this.clear(this.personalBests);
            FloatVectorSpecies fvSpecies = (FloatVectorSpecies)this.species;
            for (int i = 0; i < this.individuals.length; ++i) {
                DoubleVectorIndividual prevInd = (DoubleVectorIndividual)this.individuals[i].clone();
                for (int j = 0; j < prevInd.genomeLength(); ++j) {
                    double val = prevInd.genome[j];
                    double range = fvSpecies.maxGene(j) - fvSpecies.minGene(j);
                    do {
                        prevInd.genome[j] = val + range * this.initialVelocityScale * (state.random[thread].nextDouble() * 2.0 - 1.0);
                    } while (prevInd.genome[j] < fvSpecies.minGene(j) || prevInd.genome[j] > fvSpecies.maxGene(j));
                }
                this.previousIndividuals[i] = prevInd;
            }
        }
    }

    public void printSubpopulationForHumans(EvolutionState state, int log) {
        int i;
        state.output.println(GLOBAL_BEST_PREAMBLE, log);
        if (this.globalBest == null) {
            state.output.println("Exists: false", log);
        } else {
            state.output.println("Exists: true", log);
            this.globalBest.printIndividualForHumans(state, log);
        }
        state.output.println(NEIGHBORHOOD_BEST_PREAMBLE, log);
        for (i = 0; i < this.individuals.length; ++i) {
            if (this.neighborhoodBests[i] == null) {
                state.output.println("Exists: false", log);
                continue;
            }
            state.output.println("Exists: true", log);
            this.neighborhoodBests[i].printIndividualForHumans(state, log);
        }
        state.output.println(PERSONAL_BEST_PREAMBLE, log);
        for (i = 0; i < this.individuals.length; ++i) {
            if (this.personalBests[i] == null) {
                state.output.println("Exists: false", log);
                continue;
            }
            state.output.println("Exists: true", log);
            this.personalBests[i].printIndividualForHumans(state, log);
        }
        state.output.println(PREVIOUS_INDIVIDUAL_PREAMBLE, log);
        for (i = 0; i < this.individuals.length; ++i) {
            if (this.previousIndividuals[i] == null) {
                state.output.println("Exists: false", log);
                continue;
            }
            state.output.println("Exists: true", log);
            this.previousIndividuals[i].printIndividualForHumans(state, log);
        }
        super.printSubpopulationForHumans(state, log);
    }

    public void printSubpopulation(EvolutionState state, int log) {
        int i;
        state.output.println(GLOBAL_BEST_PREAMBLE, log);
        if (this.globalBest == null) {
            state.output.println(INDIVIDUAL_EXISTS_PREAMBLE + Code.encode(false), log);
        } else {
            state.output.println(INDIVIDUAL_EXISTS_PREAMBLE + Code.encode(true), log);
            this.globalBest.printIndividual(state, log);
        }
        state.output.println(NEIGHBORHOOD_BEST_PREAMBLE, log);
        for (i = 0; i < this.individuals.length; ++i) {
            if (this.neighborhoodBests[i] == null) {
                state.output.println(INDIVIDUAL_EXISTS_PREAMBLE + Code.encode(false), log);
                continue;
            }
            state.output.println(INDIVIDUAL_EXISTS_PREAMBLE + Code.encode(true), log);
            this.neighborhoodBests[i].printIndividual(state, log);
        }
        state.output.println(PERSONAL_BEST_PREAMBLE, log);
        for (i = 0; i < this.individuals.length; ++i) {
            if (this.personalBests[i] == null) {
                state.output.println(INDIVIDUAL_EXISTS_PREAMBLE + Code.encode(false), log);
                continue;
            }
            state.output.println(INDIVIDUAL_EXISTS_PREAMBLE + Code.encode(true), log);
            this.personalBests[i].printIndividual(state, log);
        }
        state.output.println(PREVIOUS_INDIVIDUAL_PREAMBLE, log);
        for (i = 0; i < this.individuals.length; ++i) {
            if (this.previousIndividuals[i] == null) {
                state.output.println(INDIVIDUAL_EXISTS_PREAMBLE + Code.encode(false), log);
                continue;
            }
            state.output.println(INDIVIDUAL_EXISTS_PREAMBLE + Code.encode(true), log);
            this.previousIndividuals[i].printIndividual(state, log);
        }
        super.printSubpopulation(state, log);
    }

    public void printSubpopulation(EvolutionState state, PrintWriter writer) {
        int i;
        writer.println(GLOBAL_BEST_PREAMBLE);
        if (this.globalBest == null) {
            writer.println(INDIVIDUAL_EXISTS_PREAMBLE + Code.encode(false));
        } else {
            writer.println(INDIVIDUAL_EXISTS_PREAMBLE + Code.encode(true));
            this.globalBest.printIndividual(state, writer);
        }
        writer.println(NEIGHBORHOOD_BEST_PREAMBLE);
        for (i = 0; i < this.individuals.length; ++i) {
            if (this.neighborhoodBests[i] == null) {
                writer.println(INDIVIDUAL_EXISTS_PREAMBLE + Code.encode(false));
                continue;
            }
            writer.println(INDIVIDUAL_EXISTS_PREAMBLE + Code.encode(true));
            this.neighborhoodBests[i].printIndividual(state, writer);
        }
        writer.println(PERSONAL_BEST_PREAMBLE);
        for (i = 0; i < this.individuals.length; ++i) {
            if (this.personalBests[i] == null) {
                writer.println(INDIVIDUAL_EXISTS_PREAMBLE + Code.encode(false));
                continue;
            }
            writer.println(INDIVIDUAL_EXISTS_PREAMBLE + Code.encode(true));
            this.personalBests[i].printIndividual(state, writer);
        }
        writer.println(PREVIOUS_INDIVIDUAL_PREAMBLE);
        for (i = 0; i < this.individuals.length; ++i) {
            if (this.previousIndividuals[i] == null) {
                writer.println(INDIVIDUAL_EXISTS_PREAMBLE + Code.encode(false));
                continue;
            }
            writer.println(INDIVIDUAL_EXISTS_PREAMBLE + Code.encode(true));
            this.previousIndividuals[i].printIndividual(state, writer);
        }
        super.printSubpopulation(state, writer);
    }

    DoubleVectorIndividual possiblyReadIndividual(EvolutionState state, LineNumberReader reader) throws IOException {
        if (Code.readBooleanWithPreamble(INDIVIDUAL_EXISTS_PREAMBLE, state, reader)) {
            return (DoubleVectorIndividual)this.species.newIndividual(state, reader);
        }
        return null;
    }

    public void readSubpopulation(EvolutionState state, LineNumberReader reader) throws IOException {
        int i;
        Code.checkPreamble(GLOBAL_BEST_PREAMBLE, state, reader);
        this.globalBest = this.possiblyReadIndividual(state, reader);
        Code.checkPreamble(NEIGHBORHOOD_BEST_PREAMBLE, state, reader);
        for (i = 0; i < this.individuals.length; ++i) {
            this.neighborhoodBests[i] = this.possiblyReadIndividual(state, reader);
        }
        Code.checkPreamble(PERSONAL_BEST_PREAMBLE, state, reader);
        for (i = 0; i < this.individuals.length; ++i) {
            this.personalBests[i] = this.possiblyReadIndividual(state, reader);
        }
        Code.checkPreamble(PREVIOUS_INDIVIDUAL_PREAMBLE, state, reader);
        for (i = 0; i < this.individuals.length; ++i) {
            this.previousIndividuals[i] = this.possiblyReadIndividual(state, reader);
        }
        super.readSubpopulation(state, reader);
    }

    public void writeSubpopulation(EvolutionState state, DataOutput dataOutput) throws IOException {
        int i;
        if (this.globalBest == null) {
            dataOutput.writeBoolean(false);
        } else {
            dataOutput.writeBoolean(true);
            this.globalBest.writeIndividual(state, dataOutput);
        }
        for (i = 0; i < this.individuals.length; ++i) {
            if (this.neighborhoodBests[i] == null) {
                dataOutput.writeBoolean(false);
                continue;
            }
            dataOutput.writeBoolean(true);
            this.neighborhoodBests[i].writeIndividual(state, dataOutput);
        }
        for (i = 0; i < this.individuals.length; ++i) {
            if (this.personalBests[i] == null) {
                dataOutput.writeBoolean(false);
                continue;
            }
            dataOutput.writeBoolean(true);
            this.personalBests[i].writeIndividual(state, dataOutput);
        }
        for (i = 0; i < this.individuals.length; ++i) {
            if (this.previousIndividuals[i] == null) {
                dataOutput.writeBoolean(false);
                continue;
            }
            dataOutput.writeBoolean(true);
            this.previousIndividuals[i].writeIndividual(state, dataOutput);
        }
        super.writeSubpopulation(state, dataOutput);
    }

    public void readSubpopulation(EvolutionState state, DataInput dataInput) throws IOException {
        int i;
        this.globalBest = dataInput.readBoolean() ? (DoubleVectorIndividual)this.species.newIndividual(state, dataInput) : null;
        for (i = 0; i < this.individuals.length; ++i) {
            this.neighborhoodBests[i] = dataInput.readBoolean() ? (DoubleVectorIndividual)this.species.newIndividual(state, dataInput) : null;
        }
        for (i = 0; i < this.individuals.length; ++i) {
            this.personalBests[i] = dataInput.readBoolean() ? (DoubleVectorIndividual)this.species.newIndividual(state, dataInput) : null;
        }
        for (i = 0; i < this.individuals.length; ++i) {
            this.previousIndividuals[i] = dataInput.readBoolean() ? (DoubleVectorIndividual)this.species.newIndividual(state, dataInput) : null;
        }
        super.readSubpopulation(state, dataInput);
    }
}

