/*
 * Decompiled with CFR 0.152.
 */
package ec.rule;

import ec.EvolutionState;
import ec.Individual;
import ec.rule.RuleDefaults;
import ec.rule.RuleSet;
import ec.util.Code;
import ec.util.Parameter;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.io.LineNumberReader;
import java.io.PrintWriter;

public class RuleIndividual
extends Individual {
    public static final String P_RULESET = "ruleset";
    public static final String P_NUMRULESETS = "num-rulesets";
    public RuleSet[] rulesets;
    static /* synthetic */ Class class$ec$rule$RuleSet;

    public Parameter defaultBase() {
        return RuleDefaults.base().push("individual");
    }

    public Object clone() {
        RuleIndividual myobj = (RuleIndividual)super.clone();
        myobj.rulesets = new RuleSet[this.rulesets.length];
        for (int x = 0; x < this.rulesets.length; ++x) {
            myobj.rulesets[x] = (RuleSet)this.rulesets[x].clone();
        }
        return myobj;
    }

    public void preprocessIndividual(EvolutionState state, int thread) {
        for (int x = 0; x < this.rulesets.length; ++x) {
            this.rulesets[x].preprocessRules(state, thread);
        }
    }

    public void postprocessIndividual(EvolutionState state, int thread) {
        for (int x = 0; x < this.rulesets.length; ++x) {
            this.rulesets[x].postprocessRules(state, thread);
        }
    }

    public boolean equals(Object ind) {
        if (!this.getClass().equals(ind.getClass())) {
            return false;
        }
        RuleIndividual other = (RuleIndividual)ind;
        if (this.rulesets.length != other.rulesets.length) {
            return false;
        }
        for (int x = 0; x < this.rulesets.length; ++x) {
            if (this.rulesets[x].equals(other.rulesets[x])) continue;
            return false;
        }
        return true;
    }

    public int hashCode() {
        int hash = this.getClass().hashCode();
        for (int x = 0; x < this.rulesets.length; ++x) {
            hash = (hash << 1 | hash >>> 31) ^ this.rulesets[x].hashCode();
        }
        return hash;
    }

    public void setup(EvolutionState state, Parameter base) {
        super.setup(state, base);
        int numrulesets = state.parameters.getInt(base.push(P_NUMRULESETS), this.defaultBase().push(P_NUMRULESETS), 1);
        if (numrulesets == 0) {
            state.output.fatal("RuleIndividual needs at least one RuleSet!", base.push(P_NUMRULESETS), this.defaultBase().push(P_NUMRULESETS));
        }
        this.rulesets = new RuleSet[numrulesets];
        for (int x = 0; x < numrulesets; ++x) {
            this.rulesets[x] = (RuleSet)state.parameters.getInstanceForParameterEq(base.push(P_RULESET).push("" + x), this.defaultBase().push(P_RULESET), class$ec$rule$RuleSet == null ? RuleIndividual.class$("ec.rule.RuleSet") : class$ec$rule$RuleSet);
            this.rulesets[x].setup(state, base.push(P_RULESET).push("" + x));
        }
    }

    public void printIndividualForHumans(EvolutionState state, int log) {
        state.output.println("Evaluated: " + (this.evaluated ? "true" : "false"), log);
        this.fitness.printFitnessForHumans(state, log);
        for (int x = 0; x < this.rulesets.length; ++x) {
            state.output.println("Ruleset " + x + ":", log);
            this.rulesets[x].printRuleSetForHumans(state, log);
        }
    }

    public void printIndividual(EvolutionState state, int log) {
        state.output.println("Evaluated: " + Code.encode(this.evaluated), log);
        this.fitness.printFitness(state, log);
        for (int x = 0; x < this.rulesets.length; ++x) {
            state.output.println("Ruleset " + x + ":", log);
            this.rulesets[x].printRuleSet(state, log);
        }
    }

    public void printIndividual(EvolutionState state, PrintWriter writer) {
        writer.println("Evaluated: " + Code.encode(this.evaluated));
        this.fitness.printFitness(state, writer);
        for (int x = 0; x < this.rulesets.length; ++x) {
            writer.println("Ruleset " + x + ":");
            this.rulesets[x].printRuleSet(state, writer);
        }
    }

    public void writeGenotype(EvolutionState state, DataOutput dataOutput) throws IOException {
        dataOutput.writeInt(this.rulesets.length);
        for (int x = 0; x < this.rulesets.length; ++x) {
            this.rulesets[x].writeRuleSet(state, dataOutput);
        }
    }

    public void readGenotype(EvolutionState state, DataInput dataInput) throws IOException {
        int len = dataInput.readInt();
        if (this.rulesets == null || this.rulesets.length != len) {
            state.output.fatal("Number of RuleSets differ in RuleIndividual when reading from readGenotype(EvolutionState, DataInput).");
        }
        for (int x = 0; x < this.rulesets.length; ++x) {
            this.rulesets[x].readRuleSet(state, dataInput);
        }
    }

    public void parseGenotype(EvolutionState state, LineNumberReader reader) throws IOException {
        for (int x = 0; x < this.rulesets.length; ++x) {
            reader.readLine();
            this.rulesets[x].readRuleSet(state, reader);
        }
    }

    public long size() {
        long size = 0L;
        for (int x = 0; x < this.rulesets.length; ++x) {
            size += (long)this.rulesets[x].numRules();
        }
        return size;
    }

    public void reset(EvolutionState state, int thread) {
        for (int x = 0; x < this.rulesets.length; ++x) {
            this.rulesets[x].reset(state, thread);
        }
    }

    public void mutate(EvolutionState state, int thread) {
        for (int x = 0; x < this.rulesets.length; ++x) {
            this.rulesets[x].mutate(state, thread);
        }
    }
}

