/*
 * Decompiled with CFR 0.152.
 */
package ec.rule;

import ec.Clique;
import ec.EvolutionState;
import ec.rule.Rule;
import ec.rule.RuleInitializer;
import ec.rule.RuleSet;
import ec.util.Parameter;
import ec.util.RandomChoice;

public class RuleSetConstraints
implements Clique {
    public static final String P_NAME = "name";
    public static final String P_RULE = "rule";
    public static final String P_RESETMINSIZE = "reset-min-size";
    public static final String P_RESETMAXSIZE = "reset-max-size";
    public static final String P_NUMSIZES = "reset-num-sizes";
    public static final String P_RESETSIZE = "reset-size";
    public static final String P_MINSIZE = "min-size";
    public static final String P_MAXSIZE = "max-size";
    public int minSize;
    public int maxSize;
    public int resetMinSize;
    public int resetMaxSize;
    public float[] sizeDistribution;
    public static final String P_ADD_PROB = "p-add";
    public float p_add;
    public static final String P_DEL_PROB = "p-del";
    public float p_del;
    public static final String P_RAND_ORDER_PROB = "p-rand-order";
    public float p_randorder;
    public Rule rulePrototype;
    public byte constraintNumber;
    public String name;

    public int pickSize(EvolutionState state, int thread) {
        if (this.sizeDistribution != null) {
            return RandomChoice.pickFromDistribution(this.sizeDistribution, state.random[thread].nextFloat());
        }
        return state.random[thread].nextInt(this.resetMaxSize - this.resetMinSize + 1) + this.resetMinSize;
    }

    public int numRulesForReset(RuleSet ruleset, EvolutionState state, int thread) {
        return this.pickSize(state, thread);
    }

    public String toString() {
        return this.name;
    }

    public static RuleSetConstraints constraintsFor(String constraintsName, EvolutionState state) {
        RuleSetConstraints myConstraints = (RuleSetConstraints)((RuleInitializer)state.initializer).ruleSetConstraintRepository.get(constraintsName);
        if (myConstraints == null) {
            state.output.error("The rule constraints \"" + constraintsName + "\" could not be found.");
        }
        return myConstraints;
    }

    public void setup(EvolutionState state, Parameter base) {
        RuleSetConstraints old_constraints;
        this.name = state.parameters.getString(base.push(P_NAME), null);
        if (this.name == null) {
            state.output.fatal("No name was given for this RuleSetConstraints.", base.push(P_NAME));
        }
        if ((old_constraints = ((RuleInitializer)state.initializer).ruleSetConstraintRepository.put(this.name, this)) != null) {
            state.output.fatal("The rule constraints \"" + this.name + "\" has been defined multiple times.", base.push(P_NAME));
        }
        this.rulePrototype = (Rule)state.parameters.getInstanceForParameter(base.push(P_RULE), null, Rule.class);
        this.rulePrototype.setup(state, base.push(P_RULE));
        this.p_add = state.parameters.getFloat(base.push(P_ADD_PROB), null, 0.0);
        if (this.p_add < 0.0f || this.p_add > 1.0f) {
            state.output.fatal("Parameter not found, or its value is outside of allowed range [0..1].", base.push(P_ADD_PROB));
        }
        this.p_del = state.parameters.getFloat(base.push(P_DEL_PROB), null, 0.0);
        if (this.p_del < 0.0f || this.p_del > 1.0f) {
            state.output.fatal("Parameter not found, or its value is outside of allowed range [0..1].", base.push(P_DEL_PROB));
        }
        this.p_randorder = state.parameters.getFloat(base.push(P_RAND_ORDER_PROB), null, 0.0);
        if (this.p_randorder < 0.0f || this.p_randorder > 1.0f) {
            state.output.fatal("Parameter not found, or its value is outside of allowed range [0..1].", base.push(P_RAND_ORDER_PROB));
        }
        if (state.parameters.exists(base.push(P_RESETMINSIZE), null) || state.parameters.exists(base.push(P_RESETMAXSIZE), null)) {
            if (!state.parameters.exists(base.push(P_RESETMAXSIZE), null)) {
                state.output.error("This RuleSetConstraints has a reset-min-size but not a reset-max-size.");
            }
            this.resetMinSize = state.parameters.getInt(base.push(P_RESETMINSIZE), null, 0);
            if (this.resetMinSize == -1) {
                state.output.error("If min&max are defined, RuleSetConstraints must have a min size >= 0.", base.push(P_RESETMINSIZE), null);
            }
            this.resetMaxSize = state.parameters.getInt(base.push(P_RESETMAXSIZE), null, 0);
            if (this.resetMaxSize == -1) {
                state.output.error("If min&max are defined, RuleSetConstraints must have a max size >= 0.", base.push(P_RESETMAXSIZE), null);
            }
            if (this.resetMinSize > this.resetMaxSize) {
                state.output.error("If min&max are defined, RuleSetConstraints must have min size <= max size.", base.push(P_RESETMINSIZE), null);
            }
            state.output.exitIfErrors();
        }
        if (state.parameters.exists(base.push(P_NUMSIZES), null)) {
            int siz = state.parameters.getInt(base.push(P_NUMSIZES), null, 1);
            if (siz == 0) {
                state.output.fatal("The number of sizes in the RuleSetConstraints's distribution must be >= 1. ");
            }
            this.sizeDistribution = new float[siz];
            float sum = 0.0f;
            for (int x = 0; x < siz; ++x) {
                this.sizeDistribution[x] = state.parameters.getFloat(base.push(P_RESETSIZE).push("" + x), null, 0.0);
                if ((double)this.sizeDistribution[x] < 0.0) {
                    state.output.warning("Distribution value #" + x + " negative or not defined, assumed to be 0.0", base.push(P_RESETSIZE).push("" + x), null);
                    this.sizeDistribution[x] = 0.0f;
                }
                sum += this.sizeDistribution[x];
            }
            if ((double)sum > 1.0) {
                state.output.warning("Distribution sums to greater than 1.0", base.push(P_RESETSIZE), null);
            }
            if ((double)sum == 0.0) {
                state.output.fatal("Distribution is all 0's", base.push(P_RESETSIZE), null);
            }
            RandomChoice.organizeDistribution(this.sizeDistribution);
        }
        this.minSize = state.parameters.exists(base.push(P_MINSIZE), null) ? state.parameters.getInt(base.push(P_MINSIZE), null, 0) : 0;
        this.maxSize = state.parameters.exists(base.push(P_MAXSIZE), null) ? state.parameters.getInt(base.push(P_MAXSIZE), null, 0) : Integer.MAX_VALUE;
        if (this.minSize > this.maxSize) {
            state.output.fatal("Cannot have min size greater than max size : (" + this.minSize + " > " + this.maxSize + ")", base.push(P_MINSIZE), null);
        }
        if (this.sizeDistribution != null) {
            if (this.minSize != 0) {
                state.output.fatal("Using size distribution, but min size is not 0", base.push(P_MINSIZE), null);
            }
            if (this.sizeDistribution.length - 1 > this.maxSize) {
                state.output.fatal("Using size distribution whose maximum size is higher than max size", base.push(P_MAXSIZE), null);
            }
        } else {
            if (this.resetMinSize < this.minSize) {
                state.output.fatal("Cannot have min size greater than reset min size : (" + this.minSize + " > " + this.resetMinSize + ")", base.push(P_MINSIZE), null);
            }
            if (this.resetMaxSize > this.maxSize) {
                state.output.fatal("Cannot have max size less than reset max size : (" + this.maxSize + " > " + this.resetMaxSize + ")", base.push(P_MAXSIZE), null);
            }
        }
    }
}

