/*
 * Decompiled with CFR 0.152.
 */
package ec.select;

import ec.EvolutionState;
import ec.Individual;
import ec.SelectionMethod;
import ec.select.SelectDefaults;
import ec.util.Parameter;
import ec.util.QuickSort;
import ec.util.RandomChoice;
import ec.util.SortComparatorL;

public class BestSelection
extends SelectionMethod {
    public static final String P_BEST = "best";
    public static final String P_N = "n";
    public static final String P_PICKWORST = "pick-worst";
    public float[] sortedFit;
    public int[] sortedPop;
    public boolean pickWorst;
    public int bestn;

    public Parameter defaultBase() {
        return SelectDefaults.base().push(P_BEST);
    }

    public void setup(EvolutionState state, Parameter base) {
        super.setup(state, base);
        Parameter def = this.defaultBase();
        this.bestn = state.parameters.getInt(base.push(P_N), def.push(P_N), 1);
        if (this.bestn == 0) {
            state.output.fatal("n must be an integer greater than 0", base.push(P_N), def.push(P_N));
        }
        this.pickWorst = state.parameters.getBoolean(base.push(P_PICKWORST), def.push(P_PICKWORST), false);
    }

    public void prepareToProduce(EvolutionState s, int subpopulation, int thread) {
        int x;
        final Individual[] i = s.population.subpops[subpopulation].individuals;
        this.sortedPop = new int[i.length];
        for (x = 0; x < this.sortedPop.length; ++x) {
            this.sortedPop[x] = x;
        }
        QuickSort.qsort(this.sortedPop, new SortComparatorL(){

            public boolean lt(long a, long b) {
                return i[(int)b].fitness.betterThan(i[(int)a].fitness);
            }

            public boolean gt(long a, long b) {
                return i[(int)a].fitness.betterThan(i[(int)b].fitness);
            }
        });
        this.sortedFit = new float[Math.min(this.sortedPop.length, this.bestn)];
        if (this.pickWorst) {
            for (x = 0; x < this.sortedFit.length; ++x) {
                this.sortedFit[x] = i[this.sortedPop[x]].fitness.fitness();
            }
        } else {
            for (x = 0; x < this.sortedFit.length; ++x) {
                this.sortedFit[x] = i[this.sortedPop[this.sortedPop.length - x - 1]].fitness.fitness();
            }
        }
        for (x = 0; x < this.sortedFit.length; ++x) {
            if (!(this.sortedFit[x] < 0.0f)) continue;
            s.output.fatal("Discovered a negative fitness value.  BestSelection requires that all fitness values be non-negative(offending subpopulation #" + subpopulation + ")");
        }
        RandomChoice.organizeDistribution(this.sortedFit, true);
    }

    public int produce(int subpopulation, EvolutionState state, int thread) {
        if (this.pickWorst) {
            return this.sortedPop[RandomChoice.pickFromDistribution(this.sortedFit, state.random[thread].nextFloat())];
        }
        return this.sortedPop[this.sortedPop.length - RandomChoice.pickFromDistribution(this.sortedFit, state.random[thread].nextFloat()) - 1];
    }

    public void finishProducing(EvolutionState s, int subpopulation, int thread) {
        this.sortedFit = null;
        this.sortedPop = null;
    }
}

