/*
 * Decompiled with CFR 0.152.
 */
package ec.simple;

import ec.EvolutionState;
import ec.Individual;
import ec.Statistics;
import ec.util.Parameter;
import java.io.File;
import java.io.IOException;

public class SimpleShortStatistics
extends Statistics {
    public static final String P_STATISTICS_FILE = "file";
    public int statisticslog = 0;
    public static final String P_COMPRESS = "gzip";
    public static final String P_FULL = "gather-full";
    public boolean doFull;
    public Individual[] best_of_run;
    public long[] lengths;
    public long lastTime;
    public long lastUsage;

    public Individual[] getBestSoFar() {
        return this.best_of_run;
    }

    public void setup(EvolutionState state, Parameter base) {
        super.setup(state, base);
        File statisticsFile = state.parameters.getFile(base.push(P_STATISTICS_FILE), null);
        if (statisticsFile != null) {
            try {
                this.statisticslog = state.output.addLog(statisticsFile, !state.parameters.getBoolean(base.push(P_COMPRESS), null, false), state.parameters.getBoolean(base.push(P_COMPRESS), null, false));
            }
            catch (IOException i) {
                state.output.fatal("An IOException occurred while trying to create the log " + statisticsFile + ":\n" + i);
            }
        }
        this.doFull = state.parameters.getBoolean(base.push(P_FULL), null, false);
    }

    public void preInitializationStatistics(EvolutionState state) {
        super.preInitializationStatistics(state);
        if (this.doFull) {
            Runtime r = Runtime.getRuntime();
            this.lastTime = System.currentTimeMillis();
            this.lastUsage = r.totalMemory() - r.freeMemory();
        }
    }

    public void postInitializationStatistics(EvolutionState state) {
        super.postInitializationStatistics(state);
        this.best_of_run = new Individual[state.population.subpops.length];
        state.output.print("0 ", this.statisticslog);
        if (this.doFull) {
            this.lengths = new long[state.population.subpops.length];
            for (int x = 0; x < this.lengths.length; ++x) {
                this.lengths[x] = 0L;
            }
            Runtime r = Runtime.getRuntime();
            long curU = r.totalMemory() - r.freeMemory();
            state.output.print("" + (System.currentTimeMillis() - this.lastTime) + " ", this.statisticslog);
            state.output.print("" + (curU - this.lastUsage) + " ", this.statisticslog);
        }
    }

    public void preBreedingStatistics(EvolutionState state) {
        super.preBreedingStatistics(state);
        if (this.doFull) {
            Runtime r = Runtime.getRuntime();
            this.lastTime = System.currentTimeMillis();
            this.lastUsage = r.totalMemory() - r.freeMemory();
        }
    }

    public void postBreedingStatistics(EvolutionState state) {
        super.postBreedingStatistics(state);
        state.output.print("" + (state.generation + 1) + " ", this.statisticslog);
        if (this.doFull) {
            Runtime r = Runtime.getRuntime();
            long curU = r.totalMemory() - r.freeMemory();
            state.output.print("" + (System.currentTimeMillis() - this.lastTime) + " ", this.statisticslog);
            state.output.print("" + (curU - this.lastUsage) + " ", this.statisticslog);
        }
    }

    public void preEvaluationStatistics(EvolutionState state) {
        super.preEvaluationStatistics(state);
        if (this.doFull) {
            Runtime r = Runtime.getRuntime();
            this.lastTime = System.currentTimeMillis();
            this.lastUsage = r.totalMemory() - r.freeMemory();
        }
    }

    protected void _postEvaluationStatistics(EvolutionState state) {
        if (this.doFull) {
            Runtime r = Runtime.getRuntime();
            long curU = r.totalMemory() - r.freeMemory();
            state.output.print("" + (System.currentTimeMillis() - this.lastTime) + " ", this.statisticslog);
            state.output.print("" + (curU - this.lastUsage) + " ", this.statisticslog);
        }
        long lengthPerGen = 0L;
        Individual[] best_i = new Individual[state.population.subpops.length];
        for (int x = 0; x < state.population.subpops.length; ++x) {
            if (this.doFull) {
                lengthPerGen = 0L;
                for (int y = 0; y < state.population.subpops[x].individuals.length; ++y) {
                    long size = state.population.subpops[x].individuals[y].size();
                    lengthPerGen += size;
                    int n = x;
                    this.lengths[n] = this.lengths[n] + size;
                }
                state.output.print("" + (double)lengthPerGen / (double)state.population.subpops[x].individuals.length + " ", this.statisticslog);
                state.output.print("" + (double)this.lengths[x] / (double)(state.population.subpops[x].individuals.length * (state.generation + 1)) + " ", this.statisticslog);
            }
            double meanFitness = 0.0;
            for (int y = 0; y < state.population.subpops[x].individuals.length; ++y) {
                if (best_i[x] == null || state.population.subpops[x].individuals[y].fitness.betterThan(best_i[x].fitness)) {
                    best_i[x] = state.population.subpops[x].individuals[y];
                }
                meanFitness += (double)state.population.subpops[x].individuals[y].fitness.fitness();
            }
            state.output.print("" + (meanFitness /= (double)state.population.subpops[x].individuals.length) + " " + best_i[x].fitness.fitness() + " ", this.statisticslog);
            if (this.best_of_run[x] == null || best_i[x].fitness.betterThan(this.best_of_run[x].fitness)) {
                this.best_of_run[x] = (Individual)best_i[x].clone();
            }
            state.output.print("" + this.best_of_run[x].fitness.fitness() + " ", this.statisticslog);
            if (!this.doFull) continue;
            state.output.print("" + (double)best_i[x].size() + " " + (double)this.best_of_run[x].size() + " ", this.statisticslog);
        }
    }

    public void postEvaluationStatistics(EvolutionState state) {
        super.postEvaluationStatistics(state);
        this._postEvaluationStatistics(state);
        state.output.println("", this.statisticslog);
    }
}

