/*
 * Decompiled with CFR 0.152.
 */
package ec.vector;

import ec.EvolutionState;
import ec.Individual;
import ec.util.Code;
import ec.util.DecodeReturn;
import ec.util.Parameter;
import ec.vector.VectorDefaults;
import ec.vector.VectorIndividual;
import ec.vector.VectorSpecies;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.io.LineNumberReader;

public class BitVectorIndividual
extends VectorIndividual {
    public static final String P_BITVECTORINDIVIDUAL = "bit-vect-ind";
    public boolean[] genome;

    public Parameter defaultBase() {
        return VectorDefaults.base().push(P_BITVECTORINDIVIDUAL);
    }

    public Object clone() {
        BitVectorIndividual myobj = (BitVectorIndividual)super.clone();
        myobj.genome = (boolean[])this.genome.clone();
        return myobj;
    }

    public void setup(EvolutionState state, Parameter base) {
        super.setup(state, base);
        VectorSpecies s = (VectorSpecies)this.species;
        this.genome = new boolean[s.genomeSize];
    }

    public void defaultCrossover(EvolutionState state, int thread, VectorIndividual ind) {
        VectorSpecies s = (VectorSpecies)this.species;
        BitVectorIndividual i = (BitVectorIndividual)ind;
        if (this.genome.length != i.genome.length) {
            state.output.fatal("Genome lengths are not the same for fixed-length vector crossover");
        }
        switch (s.crossoverType) {
            case 0: {
                int point = state.random[thread].nextInt(this.genome.length / s.chunksize + 1);
                for (int x = 0; x < point * s.chunksize; ++x) {
                    boolean tmp = i.genome[x];
                    i.genome[x] = this.genome[x];
                    this.genome[x] = tmp;
                }
                break;
            }
            case 1: {
                int point0 = state.random[thread].nextInt(this.genome.length / s.chunksize + 1);
                int point = state.random[thread].nextInt(this.genome.length / s.chunksize + 1);
                if (point0 > point) {
                    int p = point0;
                    point0 = point;
                    point = p;
                }
                for (int x = point0 * s.chunksize; x < point * s.chunksize; ++x) {
                    boolean tmp = i.genome[x];
                    i.genome[x] = this.genome[x];
                    this.genome[x] = tmp;
                }
                break;
            }
            case 128: {
                for (int x = 0; x < this.genome.length / s.chunksize; ++x) {
                    if (!state.random[thread].nextBoolean(s.crossoverProbability)) continue;
                    for (int y = x * s.chunksize; y < (x + 1) * s.chunksize; ++y) {
                        boolean tmp = i.genome[y];
                        i.genome[y] = this.genome[y];
                        this.genome[y] = tmp;
                    }
                }
                break;
            }
        }
    }

    public void split(int[] points, Object[] pieces) {
        int point0 = 0;
        int point1 = points[0];
        for (int x = 0; x < pieces.length; ++x) {
            pieces[x] = new boolean[point1 - point0];
            System.arraycopy(this.genome, point0, pieces[x], 0, point1 - point0);
            point0 = point1;
            point1 = x >= pieces.length - 2 ? this.genome.length : points[x + 1];
        }
    }

    public void join(Object[] pieces) {
        int sum = 0;
        for (int x = 0; x < pieces.length; ++x) {
            sum += ((boolean[])pieces[x]).length;
        }
        int runningsum = 0;
        boolean[] newgenome = new boolean[sum];
        for (int x = 0; x < pieces.length; ++x) {
            System.arraycopy(pieces[x], 0, newgenome, runningsum, ((boolean[])pieces[x]).length);
            runningsum += ((boolean[])pieces[x]).length;
        }
        this.genome = newgenome;
    }

    public void defaultMutate(EvolutionState state, int thread) {
        VectorSpecies s = (VectorSpecies)this.species;
        if ((double)s.mutationProbability > 0.0) {
            for (int x = 0; x < this.genome.length; ++x) {
                if (!state.random[thread].nextBoolean(s.mutationProbability)) continue;
                this.genome[x] = !this.genome[x];
            }
        }
    }

    public void reset(EvolutionState state, int thread) {
        for (int x = 0; x < this.genome.length; ++x) {
            this.genome[x] = state.random[thread].nextBoolean();
        }
    }

    public int hashCode() {
        int hash = this.getClass().hashCode();
        hash = (hash << 1 | hash >>> 31) ^ this.genome.hashCode();
        return hash;
    }

    public String genotypeToStringForHumans() {
        String s = "";
        for (int i = 0; i < this.genome.length; ++i) {
            s = this.genome[i] ? s + " 1" : s + " 0";
        }
        return s;
    }

    public String genotypeToString() {
        StringBuffer s = new StringBuffer();
        s.append(Code.encode(this.genome.length));
        for (int i = 0; i < this.genome.length; ++i) {
            s.append(Code.encode(this.genome[i]));
        }
        return s.toString();
    }

    protected void parseGenotype(EvolutionState state, LineNumberReader reader) throws IOException {
        String s = reader.readLine();
        DecodeReturn d = new DecodeReturn(s);
        Code.decode(d);
        int lll = (int)d.l;
        this.genome = new boolean[lll];
        for (int i = 0; i < this.genome.length; ++i) {
            Code.decode(d);
            this.genome[i] = d.l != 0L;
        }
    }

    public boolean equals(Object ind) {
        if (!this.getClass().equals(ind.getClass())) {
            return false;
        }
        BitVectorIndividual i = (BitVectorIndividual)ind;
        if (this.genome.length != i.genome.length) {
            return false;
        }
        for (int j = 0; j < this.genome.length; ++j) {
            if (this.genome[j] == i.genome[j]) continue;
            return false;
        }
        return true;
    }

    public Object getGenome() {
        return this.genome;
    }

    public void setGenome(Object gen) {
        this.genome = (boolean[])gen;
    }

    public int genomeLength() {
        return this.genome.length;
    }

    public void setGenomeLength(int len) {
        boolean[] newGenome;
        System.arraycopy(this.genome, 0, newGenome, 0, this.genome.length < (newGenome = new boolean[len]).length ? this.genome.length : newGenome.length);
        this.genome = newGenome;
    }

    public void writeGenotype(EvolutionState state, DataOutput dataOutput) throws IOException {
        dataOutput.writeInt(this.genome.length);
        for (int x = 0; x < this.genome.length; ++x) {
            dataOutput.writeBoolean(this.genome[x]);
        }
    }

    public void readGenotype(EvolutionState state, DataInput dataInput) throws IOException {
        int len = dataInput.readInt();
        if (this.genome == null || this.genome.length != len) {
            this.genome = new boolean[len];
        }
        for (int x = 0; x < this.genome.length; ++x) {
            this.genome[x] = dataInput.readBoolean();
        }
    }

    public double distanceTo(Individual otherInd) {
        if (!(otherInd instanceof BitVectorIndividual)) {
            return super.distanceTo(otherInd);
        }
        BitVectorIndividual other = (BitVectorIndividual)otherInd;
        boolean[] otherGenome = other.genome;
        double hammingDistance = 0.0;
        for (int i = 0; i < other.genomeLength(); ++i) {
            if (!(this.genome[i] ^ otherGenome[i])) continue;
            hammingDistance += 1.0;
        }
        return hammingDistance;
    }
}

