/*
 * Decompiled with CFR 0.152.
 */
package ec.vector;

import ec.EvolutionState;
import ec.util.Code;
import ec.util.DecodeReturn;
import ec.util.Parameter;
import ec.vector.GeneVectorSpecies;
import ec.vector.VectorDefaults;
import ec.vector.VectorGene;
import ec.vector.VectorIndividual;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.io.LineNumberReader;

public class GeneVectorIndividual
extends VectorIndividual {
    public static final String P_GENEVECTORINDIVIDUAL = "gene-vect-ind";
    public VectorGene[] genome;

    public Parameter defaultBase() {
        return VectorDefaults.base().push(P_GENEVECTORINDIVIDUAL);
    }

    public Object clone() {
        GeneVectorIndividual myobj = (GeneVectorIndividual)super.clone();
        myobj.genome = (VectorGene[])this.genome.clone();
        for (int x = 0; x < this.genome.length; ++x) {
            myobj.genome[x] = (VectorGene)this.genome[x].clone();
        }
        return myobj;
    }

    public void setup(EvolutionState state, Parameter base) {
        super.setup(state, base);
        Parameter def = this.defaultBase();
        if (!(this.species instanceof GeneVectorSpecies)) {
            state.output.fatal("GeneVectorIndividual requires a GeneVectorSpecies", base, def);
        }
        GeneVectorSpecies s = (GeneVectorSpecies)this.species;
        this.genome = new VectorGene[s.genomeSize];
        this.reset(state, 0);
    }

    public void defaultCrossover(EvolutionState state, int thread, VectorIndividual ind) {
        GeneVectorSpecies s = (GeneVectorSpecies)this.species;
        GeneVectorIndividual i = (GeneVectorIndividual)ind;
        if (this.genome.length != i.genome.length) {
            state.output.fatal("Genome lengths are not the same for fixed-length vector crossover");
        }
        switch (s.crossoverType) {
            case 0: {
                int point = state.random[thread].nextInt(this.genome.length / s.chunksize + 1);
                for (int x = 0; x < point * s.chunksize; ++x) {
                    VectorGene tmp = i.genome[x];
                    i.genome[x] = this.genome[x];
                    this.genome[x] = tmp;
                }
                break;
            }
            case 1: {
                int point0 = state.random[thread].nextInt(this.genome.length / s.chunksize + 1);
                int point = state.random[thread].nextInt(this.genome.length / s.chunksize + 1);
                if (point0 > point) {
                    int p = point0;
                    point0 = point;
                    point = p;
                }
                for (int x = point0 * s.chunksize; x < point * s.chunksize; ++x) {
                    VectorGene tmp = i.genome[x];
                    i.genome[x] = this.genome[x];
                    this.genome[x] = tmp;
                }
                break;
            }
            case 128: {
                for (int x = 0; x < this.genome.length / s.chunksize; ++x) {
                    if (!state.random[thread].nextBoolean(s.crossoverProbability)) continue;
                    for (int y = x * s.chunksize; y < (x + 1) * s.chunksize; ++y) {
                        VectorGene tmp = i.genome[y];
                        i.genome[y] = this.genome[y];
                        this.genome[y] = tmp;
                    }
                }
                break;
            }
        }
    }

    public void split(int[] points, Object[] pieces) {
        int point0 = 0;
        int point1 = points[0];
        for (int x = 0; x < pieces.length; ++x) {
            pieces[x] = new VectorGene[point1 - point0];
            System.arraycopy(this.genome, point0, pieces[x], 0, point1 - point0);
            point0 = point1;
            point1 = x >= pieces.length - 2 ? this.genome.length : points[x + 1];
        }
    }

    public void join(Object[] pieces) {
        int sum = 0;
        for (int x = 0; x < pieces.length; ++x) {
            sum += ((VectorGene[])pieces[x]).length;
        }
        int runningsum = 0;
        VectorGene[] newgenome = new VectorGene[sum];
        for (int x = 0; x < pieces.length; ++x) {
            System.arraycopy(pieces[x], 0, newgenome, runningsum, ((VectorGene[])pieces[x]).length);
            runningsum += ((VectorGene[])pieces[x]).length;
        }
        this.genome = newgenome;
    }

    public void defaultMutate(EvolutionState state, int thread) {
        GeneVectorSpecies s = (GeneVectorSpecies)this.species;
        if ((double)s.mutationProbability > 0.0) {
            for (int x = 0; x < this.genome.length; ++x) {
                if (!state.random[thread].nextBoolean(s.mutationProbability)) continue;
                this.genome[x].mutate(state, thread);
            }
        }
    }

    public void reset(EvolutionState state, int thread) {
        GeneVectorSpecies s = (GeneVectorSpecies)this.species;
        for (int x = 0; x < this.genome.length; ++x) {
            if (this.genome[x] == null) {
                this.genome[x] = (VectorGene)s.genePrototype.clone();
            }
            this.genome[x].reset(state, thread);
        }
    }

    public int hashCode() {
        int hash = this.getClass().hashCode();
        for (int x = 0; x < this.genome.length; ++x) {
            hash = (hash << 1 | hash >>> 31) ^ this.genome[x].hashCode();
        }
        return hash;
    }

    public String genotypeToStringForHumans() {
        StringBuffer s = new StringBuffer();
        for (int i = 0; i < this.genome.length; ++i) {
            s.append(" ");
            s.append(this.genome[i].printGeneToStringForHumans());
        }
        return s.toString();
    }

    public String genotypeToString() {
        StringBuffer s = new StringBuffer();
        for (int i = 0; i < this.genome.length; ++i) {
            s.append(" ");
            s.append(this.genome[i].printGeneToString());
        }
        return s.toString();
    }

    protected void parseGenotype(EvolutionState state, LineNumberReader reader) throws IOException {
        String s = reader.readLine();
        DecodeReturn d = new DecodeReturn(s);
        Code.decode(d);
        int lll = (int)d.l;
        this.genome = new VectorGene[lll];
        GeneVectorSpecies _species = (GeneVectorSpecies)this.species;
        for (int i = 0; i < this.genome.length; ++i) {
            this.genome[i] = (VectorGene)_species.genePrototype.clone();
            this.genome[i].readGene(state, reader);
        }
    }

    public boolean equals(Object ind) {
        if (!this.getClass().equals(ind.getClass())) {
            return false;
        }
        GeneVectorIndividual i = (GeneVectorIndividual)ind;
        if (this.genome.length != i.genome.length) {
            return false;
        }
        for (int j = 0; j < this.genome.length; ++j) {
            if (this.genome[j].equals(i.genome[j])) continue;
            return false;
        }
        return true;
    }

    public Object getGenome() {
        return this.genome;
    }

    public void setGenome(Object gen) {
        this.genome = (VectorGene[])gen;
    }

    public int genomeLength() {
        return this.genome.length;
    }

    public void cloneGenes(Object piece) {
        VectorGene[] genes = (VectorGene[])piece;
        for (int i = 0; i < genes.length; ++i) {
            if (genes[i] == null) continue;
            genes[i] = (VectorGene)genes[i].clone();
        }
    }

    public void writeGenotype(EvolutionState state, DataOutput dataOutput) throws IOException {
        dataOutput.writeInt(this.genome.length);
        for (int x = 0; x < this.genome.length; ++x) {
            this.genome[x].writeGene(state, dataOutput);
        }
    }

    public void setGenomeLength(int len) {
        VectorGene[] newGenome;
        GeneVectorSpecies s = (GeneVectorSpecies)this.species;
        System.arraycopy(this.genome, 0, newGenome, 0, this.genome.length < (newGenome = new VectorGene[len]).length ? this.genome.length : newGenome.length);
        for (int x = this.genome.length; x < newGenome.length; ++x) {
            if (this.genome[x] != null) continue;
            this.genome[x] = (VectorGene)s.genePrototype.clone();
        }
        this.genome = newGenome;
    }

    public void readGenotype(EvolutionState state, DataInput dataInput) throws IOException {
        int len = dataInput.readInt();
        if (this.genome == null || this.genome.length != len) {
            this.genome = new VectorGene[len];
        }
        GeneVectorSpecies _species = (GeneVectorSpecies)this.species;
        for (int x = 0; x < this.genome.length; ++x) {
            this.genome[x] = (VectorGene)_species.genePrototype.clone();
            this.genome[x].readGene(state, dataInput);
        }
    }
}

