/*
 * Decompiled with CFR 0.152.
 */
package ec.vector;

import ec.EvolutionState;
import ec.Individual;
import ec.util.Code;
import ec.util.DecodeReturn;
import ec.util.MersenneTwisterFast;
import ec.util.Parameter;
import ec.vector.IntegerVectorSpecies;
import ec.vector.VectorDefaults;
import ec.vector.VectorIndividual;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.io.LineNumberReader;

public class IntegerVectorIndividual
extends VectorIndividual {
    public static final String P_INTEGERVECTORINDIVIDUAL = "int-vect-ind";
    public int[] genome;

    public Parameter defaultBase() {
        return VectorDefaults.base().push(P_INTEGERVECTORINDIVIDUAL);
    }

    public Object clone() {
        IntegerVectorIndividual myobj = (IntegerVectorIndividual)super.clone();
        myobj.genome = (int[])this.genome.clone();
        return myobj;
    }

    public void setup(EvolutionState state, Parameter base) {
        super.setup(state, base);
        Parameter def = this.defaultBase();
        if (!(this.species instanceof IntegerVectorSpecies)) {
            state.output.fatal("IntegerVectorIndividual requires an IntegerVectorSpecies", base, def);
        }
        IntegerVectorSpecies s = (IntegerVectorSpecies)this.species;
        this.genome = new int[s.genomeSize];
    }

    public void defaultCrossover(EvolutionState state, int thread, VectorIndividual ind) {
        IntegerVectorSpecies s = (IntegerVectorSpecies)this.species;
        IntegerVectorIndividual i = (IntegerVectorIndividual)ind;
        if (this.genome.length != i.genome.length) {
            state.output.fatal("Genome lengths are not the same for fixed-length vector crossover");
        }
        switch (s.crossoverType) {
            case 0: {
                int point = state.random[thread].nextInt(this.genome.length / s.chunksize + 1);
                for (int x = 0; x < point * s.chunksize; ++x) {
                    int tmp = i.genome[x];
                    i.genome[x] = this.genome[x];
                    this.genome[x] = tmp;
                }
                break;
            }
            case 1: {
                int point0 = state.random[thread].nextInt(this.genome.length / s.chunksize + 1);
                int point = state.random[thread].nextInt(this.genome.length / s.chunksize + 1);
                if (point0 > point) {
                    int p = point0;
                    point0 = point;
                    point = p;
                }
                for (int x = point0 * s.chunksize; x < point * s.chunksize; ++x) {
                    int tmp = i.genome[x];
                    i.genome[x] = this.genome[x];
                    this.genome[x] = tmp;
                }
                break;
            }
            case 128: {
                for (int x = 0; x < this.genome.length / s.chunksize; ++x) {
                    if (!state.random[thread].nextBoolean(s.crossoverProbability)) continue;
                    for (int y = x * s.chunksize; y < (x + 1) * s.chunksize; ++y) {
                        int tmp = i.genome[y];
                        i.genome[y] = this.genome[y];
                        this.genome[y] = tmp;
                    }
                }
                break;
            }
            case 256: {
                double alpha = state.random[thread].nextDouble() * (1.0 + 2.0 * s.lineDistance) - s.lineDistance;
                double beta = state.random[thread].nextDouble() * (1.0 + 2.0 * s.lineDistance) - s.lineDistance;
                for (int x = 0; x < this.genome.length; ++x) {
                    long min = s.minGene(x);
                    long max = s.maxGene(x);
                    long t = (long)Math.floor(alpha * (double)this.genome[x] + (1.0 - alpha) * (double)i.genome[x] + 0.5);
                    long u = (long)Math.floor(beta * (double)i.genome[x] + (1.0 - beta) * (double)this.genome[x] + 0.5);
                    if (t < min || t > max || u < min || u > max) continue;
                    this.genome[x] = (int)t;
                    i.genome[x] = (int)u;
                }
                break;
            }
            case 512: {
                for (int x = 0; x < this.genome.length; ++x) {
                    long u;
                    long max;
                    long min;
                    long t;
                    do {
                        double alpha = state.random[thread].nextDouble() * (1.0 + 2.0 * s.lineDistance) - s.lineDistance;
                        double beta = state.random[thread].nextDouble() * (1.0 + 2.0 * s.lineDistance) - s.lineDistance;
                        min = s.minGene(x);
                        max = s.maxGene(x);
                        t = (long)Math.floor(alpha * (double)this.genome[x] + (1.0 - alpha) * (double)i.genome[x] + 0.5);
                        u = (long)Math.floor(beta * (double)i.genome[x] + (1.0 - beta) * (double)this.genome[x] + 0.5);
                    } while (t < min || t > max || u < min || u > max);
                    this.genome[x] = (int)t;
                    i.genome[x] = (int)u;
                }
                break;
            }
        }
    }

    public void split(int[] points, Object[] pieces) {
        int point0 = 0;
        int point1 = points[0];
        for (int x = 0; x < pieces.length; ++x) {
            pieces[x] = new int[point1 - point0];
            System.arraycopy(this.genome, point0, pieces[x], 0, point1 - point0);
            point0 = point1;
            point1 = x >= pieces.length - 2 ? this.genome.length : points[x + 1];
        }
    }

    public void join(Object[] pieces) {
        int sum = 0;
        for (int x = 0; x < pieces.length; ++x) {
            sum += ((int[])pieces[x]).length;
        }
        int runningsum = 0;
        int[] newgenome = new int[sum];
        for (int x = 0; x < pieces.length; ++x) {
            System.arraycopy(pieces[x], 0, newgenome, runningsum, ((int[])pieces[x]).length);
            runningsum += ((int[])pieces[x]).length;
        }
        this.genome = newgenome;
    }

    public int randomValueFromClosedInterval(int min, int max, MersenneTwisterFast random) {
        if (max - min < 0) {
            int l = 0;
            while ((l = random.nextInt()) < min || l > max) {
            }
            return l;
        }
        return min + random.nextInt(max - min + 1);
    }

    public void defaultMutate(EvolutionState state, int thread) {
        IntegerVectorSpecies s = (IntegerVectorSpecies)this.species;
        if ((double)s.mutationProbability > 0.0) {
            for (int x = 0; x < this.genome.length; ++x) {
                if (!state.random[thread].nextBoolean(s.mutationProbability)) continue;
                this.genome[x] = this.randomValueFromClosedInterval((int)s.minGene(x), (int)s.maxGene(x), state.random[thread]);
            }
        }
    }

    public void reset(EvolutionState state, int thread) {
        IntegerVectorSpecies s = (IntegerVectorSpecies)this.species;
        for (int x = 0; x < this.genome.length; ++x) {
            this.genome[x] = this.randomValueFromClosedInterval((int)s.minGene(x), (int)s.maxGene(x), state.random[thread]);
        }
    }

    public int hashCode() {
        int hash = this.getClass().hashCode();
        hash = hash << 1 | hash >>> 31;
        for (int x = 0; x < this.genome.length; ++x) {
            hash = (hash << 1 | hash >>> 31) ^ this.genome[x];
        }
        return hash;
    }

    public String genotypeToStringForHumans() {
        String s = "";
        for (int i = 0; i < this.genome.length; ++i) {
            s = s + " " + this.genome[i];
        }
        return s;
    }

    public String genotypeToString() {
        StringBuffer s = new StringBuffer();
        s.append(Code.encode(this.genome.length));
        for (int i = 0; i < this.genome.length; ++i) {
            s.append(Code.encode(this.genome[i]));
        }
        return s.toString();
    }

    protected void parseGenotype(EvolutionState state, LineNumberReader reader) throws IOException {
        String s = reader.readLine();
        DecodeReturn d = new DecodeReturn(s);
        Code.decode(d);
        int lll = (int)d.l;
        this.genome = new int[lll];
        for (int i = 0; i < this.genome.length; ++i) {
            Code.decode(d);
            this.genome[i] = (int)d.l;
        }
    }

    public boolean equals(Object ind) {
        if (!this.getClass().equals(ind.getClass())) {
            return false;
        }
        IntegerVectorIndividual i = (IntegerVectorIndividual)ind;
        if (this.genome.length != i.genome.length) {
            return false;
        }
        for (int j = 0; j < this.genome.length; ++j) {
            if (this.genome[j] == i.genome[j]) continue;
            return false;
        }
        return true;
    }

    public Object getGenome() {
        return this.genome;
    }

    public void setGenome(Object gen) {
        this.genome = (int[])gen;
    }

    public int genomeLength() {
        return this.genome.length;
    }

    public void writeGenotype(EvolutionState state, DataOutput dataOutput) throws IOException {
        dataOutput.writeInt(this.genome.length);
        for (int x = 0; x < this.genome.length; ++x) {
            dataOutput.writeInt(this.genome[x]);
        }
    }

    public void readGenotype(EvolutionState state, DataInput dataInput) throws IOException {
        int len = dataInput.readInt();
        if (this.genome == null || this.genome.length != len) {
            this.genome = new int[len];
        }
        for (int x = 0; x < this.genome.length; ++x) {
            this.genome[x] = dataInput.readInt();
        }
    }

    public void clamp() {
        IntegerVectorSpecies _species = (IntegerVectorSpecies)this.species;
        for (int i = 0; i < this.genomeLength(); ++i) {
            int minGene = (int)_species.minGene(i);
            if (this.genome[i] < minGene) {
                this.genome[i] = minGene;
                continue;
            }
            int maxGene = (int)_species.maxGene(i);
            if (this.genome[i] <= maxGene) continue;
            this.genome[i] = maxGene;
        }
    }

    public void setGenomeLength(int len) {
        int[] newGenome;
        System.arraycopy(this.genome, 0, newGenome, 0, this.genome.length < (newGenome = new int[len]).length ? this.genome.length : newGenome.length);
        this.genome = newGenome;
    }

    public boolean isInRange() {
        IntegerVectorSpecies _species = (IntegerVectorSpecies)this.species;
        for (int i = 0; i < this.genomeLength(); ++i) {
            if ((long)this.genome[i] >= _species.minGene(i) && (long)this.genome[i] <= _species.maxGene(i)) continue;
            return false;
        }
        return true;
    }

    public double distanceTo(Individual otherInd) {
        if (!(otherInd instanceof IntegerVectorIndividual)) {
            return super.distanceTo(otherInd);
        }
        IntegerVectorIndividual other = (IntegerVectorIndividual)otherInd;
        int[] otherGenome = other.genome;
        double sumSquaredDistance = 0.0;
        for (int i = 0; i < other.genomeLength(); ++i) {
            long dist = (long)this.genome[i] - (long)otherGenome[i];
            sumSquaredDistance += (double)(dist * dist);
        }
        return StrictMath.sqrt(sumSquaredDistance);
    }
}

