/*
 * Decompiled with CFR 0.152.
 */
package ec.vector;

import ec.EvolutionState;
import ec.util.Parameter;
import ec.vector.ByteVectorIndividual;
import ec.vector.IntegerVectorIndividual;
import ec.vector.LongVectorIndividual;
import ec.vector.ShortVectorIndividual;
import ec.vector.VectorSpecies;

public class IntegerVectorSpecies
extends VectorSpecies {
    public static final String P_MINGENE = "min-gene";
    public static final String P_MAXGENE = "max-gene";
    public static final String P_NUM_SEGMENTS = "num-segments";
    public static final String P_SEGMENT_TYPE = "segment-type";
    public static final String P_SEGMENT_START = "start";
    public static final String P_SEGMENT_END = "end";
    public static final String P_SEGMENT = "segment";
    public long[] minGenes;
    public long[] maxGenes;

    public long maxGene(int gene) {
        long[] m = this.maxGenes;
        if (m.length <= gene) {
            if (!this.dynamicInitialSize && !this.warned) {
                this.warnAboutGene(gene);
            }
            gene = m.length - 1;
        }
        return m[gene];
    }

    public long minGene(int gene) {
        long[] m = this.minGenes;
        if (m.length <= gene) {
            if (!this.dynamicInitialSize && !this.warned) {
                this.warnAboutGene(gene);
            }
            gene = m.length - 1;
        }
        return m[gene];
    }

    public boolean inNumericalTypeRange(long geneVal) {
        if (this.i_prototype instanceof ByteVectorIndividual) {
            return geneVal <= 127L && geneVal >= -128L;
        }
        if (this.i_prototype instanceof ShortVectorIndividual) {
            return geneVal <= 32767L && geneVal >= -32768L;
        }
        if (this.i_prototype instanceof IntegerVectorIndividual) {
            return geneVal <= Integer.MAX_VALUE && geneVal >= Integer.MIN_VALUE;
        }
        return this.i_prototype instanceof LongVectorIndividual;
    }

    public void setup(EvolutionState state, Parameter base) {
        int x;
        super.setup(state, base);
        Parameter def = this.defaultBase();
        this.minGenes = new long[this.genomeSize];
        this.maxGenes = new long[this.genomeSize];
        long minGene = state.parameters.getLongWithDefault(base.push(P_MINGENE), def.push(P_MINGENE), 0L);
        long maxGene = state.parameters.getLong(base.push(P_MAXGENE), def.push(P_MAXGENE), minGene);
        if (maxGene < minGene) {
            state.output.fatal("IntegerVectorSpecies must have a default min-gene which is <= the default max-gene", base.push(P_MAXGENE), def.push(P_MAXGENE));
        }
        for (int x2 = 0; x2 < this.genomeSize; ++x2) {
            this.minGenes[x2] = minGene;
            this.maxGenes[x2] = maxGene;
        }
        int numSegments = 0;
        if (state.parameters.exists(base.push(P_NUM_SEGMENTS), def.push(P_NUM_SEGMENTS))) {
            if (this.dynamicInitialSize) {
                state.output.warnOnce("Using dynamic initial sizing, but per-segment min/max gene declarations.  This is probably wrong.  You probably want to use global min/max declarations.", base.push(P_NUM_SEGMENTS), def.push(P_NUM_SEGMENTS));
            }
            if ((numSegments = state.parameters.getIntWithDefault(base.push(P_NUM_SEGMENTS), def.push(P_NUM_SEGMENTS), 0)) == 0) {
                state.output.warning("The number of genome segments has been defined to be equal to 0.\nHence, no genome segments will be defined.", base.push(P_NUM_SEGMENTS), def.push(P_NUM_SEGMENTS));
            } else if (numSegments < 0) {
                state.output.fatal("Invalid number of genome segments: " + numSegments + "\nIt must be a nonnegative value.", base.push(P_NUM_SEGMENTS), def.push(P_NUM_SEGMENTS));
            }
            String segmentType = state.parameters.getStringWithDefault(base.push(P_SEGMENT_TYPE), def.push(P_SEGMENT_TYPE), P_SEGMENT_START);
            if (segmentType.equalsIgnoreCase(P_SEGMENT_START)) {
                this.initializeGenomeSegmentsByStartIndices(state, base, def, numSegments, minGene, maxGene);
            } else if (segmentType.equalsIgnoreCase(P_SEGMENT_END)) {
                this.initializeGenomeSegmentsByEndIndices(state, base, def, numSegments, minGene, maxGene);
            } else {
                state.output.fatal("Invalid specification of genome segment type: " + segmentType + "\nThe " + P_SEGMENT_TYPE + " parameter must have the value of " + P_SEGMENT_START + " or " + P_SEGMENT_END, base.push(P_SEGMENT_TYPE), def.push(P_SEGMENT_TYPE));
            }
        }
        boolean foundStuff = false;
        boolean warnedMin = false;
        boolean warnedMax = false;
        for (x = 0; x < this.genomeSize; ++x) {
            if (!state.parameters.exists(base.push(P_MINGENE).push("" + x), base.push(P_MINGENE).push("" + x))) {
                if (foundStuff && !warnedMin) {
                    state.output.warning("IntegerVectorSpecies has missing min-gene values for some genes.\nThe first one is gene #" + x + ".", base.push(P_MINGENE).push("" + x), base.push(P_MINGENE).push("" + x));
                    warnedMin = true;
                }
            } else {
                if (this.dynamicInitialSize) {
                    state.output.warnOnce("Using dynamic initial sizing, but per-gene min/max gene declarations.  This is probably wrong.  You probably want to use global min/max declarations.", base.push(P_MINGENE).push("" + x), base.push(P_MINGENE).push("" + x));
                }
                this.minGenes[x] = state.parameters.getLongWithDefault(base.push(P_MINGENE).push("" + x), base.push(P_MINGENE).push("" + x), minGene);
                foundStuff = true;
            }
            if (!state.parameters.exists(base.push(P_MAXGENE).push("" + x), base.push(P_MAXGENE).push("" + x))) {
                if (!foundStuff || warnedMax) continue;
                state.output.warning("IntegerVectorSpecies has missing max-gene values for some genes.\nThe first one is gene #" + x + ".", base.push(P_MAXGENE).push("" + x), base.push(P_MAXGENE).push("" + x));
                warnedMax = true;
                continue;
            }
            if (this.dynamicInitialSize) {
                state.output.warnOnce("Using dynamic initial sizing, but per-gene min/max gene declarations.  This is probably wrong.  You probably want to use global min/max declarations.", base.push(P_MINGENE).push("" + x), base.push(P_MINGENE).push("" + x));
            }
            this.maxGenes[x] = state.parameters.getLongWithDefault(base.push(P_MAXGENE).push("" + x), base.push(P_MAXGENE).push("" + x), maxGene);
            foundStuff = true;
        }
        for (x = 0; x < this.genomeSize; ++x) {
            if (this.maxGenes[x] < this.minGenes[x]) {
                state.output.fatal("IntegerVectorSpecies must have a min-gene[" + x + "] which is <= the max-gene[" + x + "]");
            }
            if (!this.inNumericalTypeRange(this.minGenes[x])) {
                state.output.fatal("This IntegerVectorSpecies has a prototype of the kind: " + this.i_prototype.getClass().getName() + ", but doesn't have a min-gene[" + x + "] value within the range of this prototype's genome's data types");
            }
            if (this.inNumericalTypeRange(this.maxGenes[x])) continue;
            state.output.fatal("This IntegerVectorSpecies has a prototype of the kind: " + this.i_prototype.getClass().getName() + ", but doesn't have a max-gene[" + x + "] value within the range of this prototype's genome's data types");
        }
    }

    private void initializeGenomeSegmentsByStartIndices(EvolutionState state, Parameter base, Parameter def, int numSegments, long minGene, long maxGene) {
        boolean warnedMin = false;
        boolean warnedMax = false;
        long currentSegmentMinGeneValue = Long.MAX_VALUE;
        long currentSegmentMaxGeneValue = Long.MIN_VALUE;
        int previousSegmentEnd = this.genomeSize;
        int currentSegmentEnd = 0;
        for (int i = numSegments - 1; i >= 0; --i) {
            if (state.parameters.exists(base.push(P_SEGMENT).push("" + i).push(P_SEGMENT_START), def.push(P_SEGMENT).push("" + i).push(P_SEGMENT_START))) {
                currentSegmentEnd = state.parameters.getInt(base.push(P_SEGMENT).push("" + i).push(P_SEGMENT_START), def.push(P_SEGMENT).push("" + i).push(P_SEGMENT_START));
            } else {
                state.output.fatal("Genome segment " + i + " has not been defined!" + "\nYou must specify start indices for " + numSegments + " segment(s)", base.push(P_SEGMENT).push("" + i).push(P_SEGMENT_START), base.push(P_SEGMENT).push("" + i).push(P_SEGMENT_START));
            }
            if (currentSegmentEnd >= previousSegmentEnd || currentSegmentEnd < 0) {
                state.output.fatal("Invalid start index value for segment " + i + ": " + currentSegmentEnd + "\nThe value must be smaller than " + previousSegmentEnd + " and greater than or equal to  " + 0);
            }
            if (i == 0 && currentSegmentEnd != 0) {
                state.output.fatal("Invalid start index value for the first segment " + i + ": " + currentSegmentEnd + "\nThe value must be equal to " + 0);
            }
            if (!state.parameters.exists(base.push(P_SEGMENT).push("" + i).push(P_MINGENE), base.push(P_SEGMENT).push("" + i).push(P_MINGENE))) {
                if (!warnedMin) {
                    state.output.warning("IntegerVectorSpecies has missing min-gene values for some segments.\nThe first segment is #" + i + ".", base.push(P_SEGMENT).push("" + i), base.push(P_SEGMENT).push("" + i));
                    warnedMin = true;
                }
                currentSegmentMinGeneValue = minGene;
            } else {
                currentSegmentMinGeneValue = state.parameters.getLongWithDefault(base.push(P_SEGMENT).push("" + i).push(P_MINGENE), base.push(P_SEGMENT).push("" + i).push(P_MINGENE), minGene);
            }
            if (!state.parameters.exists(base.push(P_SEGMENT).push("" + i).push(P_MAXGENE), base.push(P_SEGMENT).push("" + i).push(P_MAXGENE))) {
                if (!warnedMax) {
                    state.output.warning("IntegerVectorSpecies has missing max-gene values for some segments.\nThe first segment is #" + i + ".", base.push(P_SEGMENT).push("" + i), base.push(P_SEGMENT).push("" + i));
                    warnedMax = true;
                }
                currentSegmentMaxGeneValue = maxGene;
            } else {
                currentSegmentMaxGeneValue = state.parameters.getLongWithDefault(base.push(P_SEGMENT).push("" + i).push(P_MAXGENE), base.push(P_SEGMENT).push("" + i).push(P_MAXGENE), maxGene);
            }
            if (currentSegmentMaxGeneValue < currentSegmentMinGeneValue) {
                state.output.fatal("IntegerVectorSpecies must have a min-gene value for segment " + i + " which is <= the max-gene value", base.push(P_SEGMENT).push("" + i).push(P_MAXGENE), base.push(P_SEGMENT).push("" + i).push(P_MAXGENE));
            }
            for (int j = previousSegmentEnd - 1; j >= currentSegmentEnd; --j) {
                this.minGenes[j] = currentSegmentMinGeneValue;
                this.maxGenes[j] = currentSegmentMaxGeneValue;
            }
            previousSegmentEnd = currentSegmentEnd;
        }
    }

    private void initializeGenomeSegmentsByEndIndices(EvolutionState state, Parameter base, Parameter def, int numSegments, long minGene, long maxGene) {
        boolean warnedMin = false;
        boolean warnedMax = false;
        long currentSegmentMinGeneValue = Long.MAX_VALUE;
        long currentSegmentMaxGeneValue = Long.MIN_VALUE;
        int previousSegmentEnd = -1;
        int currentSegmentEnd = 0;
        for (int i = 0; i < numSegments; ++i) {
            if (state.parameters.exists(base.push(P_SEGMENT).push("" + i).push(P_SEGMENT_END), def.push(P_SEGMENT).push("" + i).push(P_SEGMENT_END))) {
                currentSegmentEnd = state.parameters.getInt(base.push(P_SEGMENT).push("" + i).push(P_SEGMENT_END), def.push(P_SEGMENT).push("" + i).push(P_SEGMENT_END));
            } else {
                state.output.fatal("Genome segment " + i + " has not been defined!" + "\nYou must specify end indices for " + numSegments + " segment(s)", base.push(P_SEGMENT).push("" + i).push(P_SEGMENT_END), base.push(P_SEGMENT).push("" + i).push(P_SEGMENT_END));
            }
            if (currentSegmentEnd <= previousSegmentEnd || currentSegmentEnd >= this.genomeSize) {
                state.output.fatal("Invalid end index value for segment " + i + ": " + currentSegmentEnd + "\nThe value must be greater than " + previousSegmentEnd + " and smaller than " + this.genomeSize);
            }
            if (i == numSegments - 1 && currentSegmentEnd != this.genomeSize - 1) {
                state.output.fatal("Invalid end index value for the last segment " + i + ": " + currentSegmentEnd + "\nThe value must be equal to the index of the last gene in the genome:  " + (this.genomeSize - 1));
            }
            if (!state.parameters.exists(base.push(P_SEGMENT).push("" + i).push(P_MINGENE), base.push(P_SEGMENT).push("" + i).push(P_MINGENE))) {
                if (!warnedMin) {
                    state.output.warning("IntegerVectorSpecies has missing min-gene values for some segments.\nThe first segment is #" + i + ".", base.push(P_SEGMENT).push("" + i), base.push(P_SEGMENT).push("" + i));
                    warnedMin = true;
                }
                currentSegmentMinGeneValue = minGene;
            } else {
                currentSegmentMinGeneValue = state.parameters.getLongWithDefault(base.push(P_SEGMENT).push("" + i).push(P_MINGENE), base.push(P_SEGMENT).push("" + i).push(P_MINGENE), minGene);
            }
            if (!state.parameters.exists(base.push(P_SEGMENT).push("" + i).push(P_MAXGENE), base.push(P_SEGMENT).push("" + i).push(P_MAXGENE))) {
                if (!warnedMax) {
                    state.output.warning("IntegerVectorSpecies has missing max-gene values for some segments.\nThe first segment is #" + i + ".", base.push(P_SEGMENT).push("" + i), base.push(P_SEGMENT).push("" + i));
                    warnedMax = true;
                }
                currentSegmentMaxGeneValue = maxGene;
            } else {
                currentSegmentMaxGeneValue = state.parameters.getLongWithDefault(base.push(P_SEGMENT).push("" + i).push(P_MAXGENE), base.push(P_SEGMENT).push("" + i).push(P_MAXGENE), maxGene);
            }
            if (currentSegmentMaxGeneValue < currentSegmentMinGeneValue) {
                state.output.fatal("IntegerVectorSpecies must have a min-gene value for segment " + i + " which is <= the max-gene value", base.push(P_SEGMENT).push("" + i).push(P_MAXGENE), base.push(P_SEGMENT).push("" + i).push(P_MAXGENE));
            }
            for (int j = previousSegmentEnd + 1; j <= currentSegmentEnd; ++j) {
                this.minGenes[j] = currentSegmentMinGeneValue;
                this.maxGenes[j] = currentSegmentMaxGeneValue;
            }
            previousSegmentEnd = currentSegmentEnd;
        }
    }
}

