/*
 * Decompiled with CFR 0.152.
 */
package ec.vector;

import ec.EvolutionState;
import ec.Individual;
import ec.util.Code;
import ec.util.DecodeReturn;
import ec.util.Parameter;
import ec.vector.IntegerVectorSpecies;
import ec.vector.VectorDefaults;
import ec.vector.VectorIndividual;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.io.LineNumberReader;

public class ShortVectorIndividual
extends VectorIndividual {
    public static final String P_SHORTVECTORINDIVIDUAL = "short-vect-ind";
    public short[] genome;

    public Parameter defaultBase() {
        return VectorDefaults.base().push(P_SHORTVECTORINDIVIDUAL);
    }

    public Object clone() {
        ShortVectorIndividual myobj = (ShortVectorIndividual)super.clone();
        myobj.genome = (short[])this.genome.clone();
        return myobj;
    }

    public void setup(EvolutionState state, Parameter base) {
        super.setup(state, base);
        Parameter def = this.defaultBase();
        if (!(this.species instanceof IntegerVectorSpecies)) {
            state.output.fatal("ShortVectorIndividual requires an IntegerVectorSpecies", base, def);
        }
        IntegerVectorSpecies s = (IntegerVectorSpecies)this.species;
        this.genome = new short[s.genomeSize];
    }

    public void defaultCrossover(EvolutionState state, int thread, VectorIndividual ind) {
        IntegerVectorSpecies s = (IntegerVectorSpecies)this.species;
        ShortVectorIndividual i = (ShortVectorIndividual)ind;
        if (this.genome.length != i.genome.length) {
            state.output.fatal("Genome lengths are not the same for fixed-length vector crossover");
        }
        switch (s.crossoverType) {
            case 0: {
                int point = state.random[thread].nextInt(this.genome.length / s.chunksize + 1);
                for (int x = 0; x < point * s.chunksize; ++x) {
                    short tmp = i.genome[x];
                    i.genome[x] = this.genome[x];
                    this.genome[x] = tmp;
                }
                break;
            }
            case 1: {
                int point0 = state.random[thread].nextInt(this.genome.length / s.chunksize + 1);
                int point = state.random[thread].nextInt(this.genome.length / s.chunksize + 1);
                if (point0 > point) {
                    int p = point0;
                    point0 = point;
                    point = p;
                }
                for (int x = point0 * s.chunksize; x < point * s.chunksize; ++x) {
                    short tmp = i.genome[x];
                    i.genome[x] = this.genome[x];
                    this.genome[x] = tmp;
                }
                break;
            }
            case 128: {
                for (int x = 0; x < this.genome.length / s.chunksize; ++x) {
                    if (!state.random[thread].nextBoolean(s.crossoverProbability)) continue;
                    for (int y = x * s.chunksize; y < (x + 1) * s.chunksize; ++y) {
                        short tmp = i.genome[y];
                        i.genome[y] = this.genome[y];
                        this.genome[y] = tmp;
                    }
                }
                break;
            }
            case 256: {
                double alpha = state.random[thread].nextDouble() * (1.0 + 2.0 * s.lineDistance) - s.lineDistance;
                double beta = state.random[thread].nextDouble() * (1.0 + 2.0 * s.lineDistance) - s.lineDistance;
                for (int x = 0; x < this.genome.length; ++x) {
                    long min = s.minGene(x);
                    long max = s.maxGene(x);
                    long t = (long)Math.floor(alpha * (double)this.genome[x] + (1.0 - alpha) * (double)i.genome[x] + 0.5);
                    long u = (long)Math.floor(beta * (double)i.genome[x] + (1.0 - beta) * (double)this.genome[x] + 0.5);
                    if (t < min || t > max || u < min || u > max) continue;
                    this.genome[x] = (short)t;
                    i.genome[x] = (short)u;
                }
                break;
            }
            case 512: {
                for (int x = 0; x < this.genome.length; ++x) {
                    long u;
                    long max;
                    long min;
                    long t;
                    do {
                        double alpha = state.random[thread].nextDouble() * (1.0 + 2.0 * s.lineDistance) - s.lineDistance;
                        double beta = state.random[thread].nextDouble() * (1.0 + 2.0 * s.lineDistance) - s.lineDistance;
                        min = s.minGene(x);
                        max = s.maxGene(x);
                        t = (long)Math.floor(alpha * (double)this.genome[x] + (1.0 - alpha) * (double)i.genome[x] + 0.5);
                        u = (long)Math.floor(beta * (double)i.genome[x] + (1.0 - beta) * (double)this.genome[x] + 0.5);
                    } while (t < min || t > max || u < min || u > max);
                    this.genome[x] = (short)t;
                    i.genome[x] = (short)u;
                }
                break;
            }
        }
    }

    public void split(int[] points, Object[] pieces) {
        int point0 = 0;
        int point1 = points[0];
        for (int x = 0; x < pieces.length; ++x) {
            pieces[x] = new short[point1 - point0];
            System.arraycopy(this.genome, point0, pieces[x], 0, point1 - point0);
            point0 = point1;
            point1 = x >= pieces.length - 2 ? this.genome.length : points[x + 1];
        }
    }

    public void join(Object[] pieces) {
        int sum = 0;
        for (int x = 0; x < pieces.length; ++x) {
            sum += ((short[])pieces[x]).length;
        }
        int runningsum = 0;
        short[] newgenome = new short[sum];
        for (int x = 0; x < pieces.length; ++x) {
            System.arraycopy(pieces[x], 0, newgenome, runningsum, ((short[])pieces[x]).length);
            runningsum += ((short[])pieces[x]).length;
        }
        this.genome = newgenome;
    }

    public void defaultMutate(EvolutionState state, int thread) {
        IntegerVectorSpecies s = (IntegerVectorSpecies)this.species;
        if ((double)s.mutationProbability > 0.0) {
            for (int x = 0; x < this.genome.length; ++x) {
                if (!state.random[thread].nextBoolean(s.mutationProbability)) continue;
                this.genome[x] = (short)((int)s.minGene(x) + state.random[thread].nextInt((int)s.maxGene(x) - (int)s.minGene(x) + 1));
            }
        }
    }

    public void reset(EvolutionState state, int thread) {
        IntegerVectorSpecies s = (IntegerVectorSpecies)this.species;
        for (int x = 0; x < this.genome.length; ++x) {
            this.genome[x] = (short)((int)s.minGene(x) + state.random[thread].nextInt((int)s.maxGene(x) - (int)s.minGene(x) + 1));
        }
    }

    public int hashCode() {
        int hash = this.getClass().hashCode();
        hash = hash << 1 | hash >>> 31;
        for (int x = 0; x < this.genome.length; ++x) {
            hash = (hash << 1 | hash >>> 31) ^ this.genome[x];
        }
        return hash;
    }

    public String genotypeToStringForHumans() {
        String s = "";
        for (int i = 0; i < this.genome.length; ++i) {
            s = s + " " + this.genome[i];
        }
        return s;
    }

    public String genotypeToString() {
        StringBuffer s = new StringBuffer();
        s.append(Code.encode(this.genome.length));
        for (int i = 0; i < this.genome.length; ++i) {
            s.append(Code.encode(this.genome[i]));
        }
        return s.toString();
    }

    protected void parseGenotype(EvolutionState state, LineNumberReader reader) throws IOException {
        String s = reader.readLine();
        DecodeReturn d = new DecodeReturn(s);
        Code.decode(d);
        int lll = (int)d.l;
        this.genome = new short[lll];
        for (int i = 0; i < this.genome.length; ++i) {
            Code.decode(d);
            this.genome[i] = (short)d.l;
        }
    }

    public boolean equals(Object ind) {
        if (!this.getClass().equals(ind.getClass())) {
            return false;
        }
        ShortVectorIndividual i = (ShortVectorIndividual)ind;
        if (this.genome.length != i.genome.length) {
            return false;
        }
        for (int j = 0; j < this.genome.length; ++j) {
            if (this.genome[j] == i.genome[j]) continue;
            return false;
        }
        return true;
    }

    public Object getGenome() {
        return this.genome;
    }

    public void setGenome(Object gen) {
        this.genome = (short[])gen;
    }

    public int genomeLength() {
        return this.genome.length;
    }

    public void writeGenotype(EvolutionState state, DataOutput dataOutput) throws IOException {
        dataOutput.writeInt(this.genome.length);
        for (int x = 0; x < this.genome.length; ++x) {
            dataOutput.writeShort(this.genome[x]);
        }
    }

    public void readGenotype(EvolutionState state, DataInput dataInput) throws IOException {
        int len = dataInput.readInt();
        if (this.genome == null || this.genome.length != len) {
            this.genome = new short[len];
        }
        for (int x = 0; x < this.genome.length; ++x) {
            this.genome[x] = dataInput.readShort();
        }
    }

    public void clamp() {
        IntegerVectorSpecies _species = (IntegerVectorSpecies)this.species;
        for (int i = 0; i < this.genomeLength(); ++i) {
            short minGene = (short)_species.minGene(i);
            if (this.genome[i] < minGene) {
                this.genome[i] = minGene;
                continue;
            }
            short maxGene = (short)_species.maxGene(i);
            if (this.genome[i] <= maxGene) continue;
            this.genome[i] = maxGene;
        }
    }

    public void setGenomeLength(int len) {
        short[] newGenome;
        System.arraycopy(this.genome, 0, newGenome, 0, this.genome.length < (newGenome = new short[len]).length ? this.genome.length : newGenome.length);
        this.genome = newGenome;
    }

    public boolean isInRange() {
        IntegerVectorSpecies _species = (IntegerVectorSpecies)this.species;
        for (int i = 0; i < this.genomeLength(); ++i) {
            if ((long)this.genome[i] >= _species.minGene(i) && (long)this.genome[i] <= _species.maxGene(i)) continue;
            return false;
        }
        return true;
    }

    public double distanceTo(Individual otherInd) {
        if (!(otherInd instanceof ShortVectorIndividual)) {
            return super.distanceTo(otherInd);
        }
        ShortVectorIndividual other = (ShortVectorIndividual)otherInd;
        short[] otherGenome = other.genome;
        double sumSquaredDistance = 0.0;
        for (int i = 0; i < other.genomeLength(); ++i) {
            long dist = (long)this.genome[i] - (long)otherGenome[i];
            sumSquaredDistance += (double)(dist * dist);
        }
        return StrictMath.sqrt(sumSquaredDistance);
    }
}

