/*
 * Decompiled with CFR 0.152.
 */
package ec;

import ec.EvolutionState;
import ec.Individual;
import ec.Prototype;
import ec.util.Parameter;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.io.LineNumberReader;
import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.Arrays;

public abstract class Fitness
implements Prototype,
Comparable {
    public ArrayList trials = null;
    public Individual[] context = null;
    public static final String P_FITNESS = "fitness";
    public static final String FITNESS_PREAMBLE = "Fitness: ";

    public void setContext(Individual[] cont, int index) {
        Individual ind = cont[index];
        cont[index] = null;
        this.setContext(cont);
        cont[index] = ind;
    }

    public void setContext(Individual[] cont) {
        if (cont == null) {
            this.context = null;
        } else {
            this.context = new Individual[cont.length];
            for (int i = 0; i < cont.length; ++i) {
                if (cont[i] == null) {
                    this.context[i] = null;
                    continue;
                }
                Individual[] c = cont[i].fitness.context;
                cont[i].fitness.context = null;
                this.context[i] = (Individual)cont[i].clone();
                cont[i].fitness.context = c;
            }
        }
    }

    public Individual[] getContext() {
        return this.context;
    }

    public abstract double fitness();

    public abstract boolean isIdealFitness();

    public abstract boolean equivalentTo(Fitness var1);

    public abstract boolean betterThan(Fitness var1);

    public void printFitnessForHumans(EvolutionState state, int log) {
        this.printFitnessForHumans(state, log, 3000);
    }

    public void printFitnessForHumans(EvolutionState state, int log, int verbosity) {
        String s = this.fitnessToStringForHumans();
        if (this.context != null) {
            for (int i = 0; i < this.context.length; ++i) {
                if (this.context[i] == null) continue;
                s = s + "\nCollaborator " + i + ": ";
                Individual[] c = this.context[i].fitness.context;
                this.context[i].fitness.context = null;
                s = s + this.context[i].genotypeToStringForHumans();
                this.context[i].fitness.context = c;
            }
        }
        state.output.println(s, verbosity, log);
    }

    public void printFitness(EvolutionState state, int log) {
        this.printFitness(state, log, 3000);
    }

    public void printFitness(EvolutionState state, int log, int verbosity) {
        state.output.println(this.fitnessToString(), verbosity, log);
    }

    public void printFitness(EvolutionState state, PrintWriter writer) {
        writer.println(this.fitnessToString());
    }

    public void readFitness(EvolutionState state, LineNumberReader reader) throws IOException {
        state.output.fatal("readFitness(EvolutionState, DataOutput)  not implemented in " + this.getClass());
    }

    public String fitnessToStringForHumans() {
        return this.toString();
    }

    public String fitnessToString() {
        return this.toString();
    }

    public void writeFitness(EvolutionState state, DataOutput dataOutput) throws IOException {
        state.output.fatal("writeFitness(EvolutionState, DataOutput) not implemented in " + this.getClass());
    }

    public void writeTrials(EvolutionState state, DataOutput dataOutput) throws IOException {
        if (this.trials == null) {
            dataOutput.writeInt(-1);
        } else {
            int len = this.trials.size();
            dataOutput.writeInt(len);
            for (int i = 0; i < len; ++i) {
                dataOutput.writeDouble((Double)this.trials.get(i));
            }
        }
    }

    public void readFitness(EvolutionState state, DataInput dataInput) throws IOException {
        state.output.fatal("readFitness(EvolutionState, DataOutput) not implemented in " + this.getClass());
    }

    public void readTrials(EvolutionState state, DataInput dataInput) throws IOException {
        int len = dataInput.readInt();
        if (len >= 0) {
            this.trials = new ArrayList(len);
            for (int i = 0; i < len; ++i) {
                this.trials.add(new Double(dataInput.readDouble()));
            }
        }
    }

    public boolean contextIsBetterThan(Fitness other) {
        if (other.trials == null) {
            return true;
        }
        if (this.trials == null) {
            return false;
        }
        return this.bestTrial(this.trials) < this.bestTrial(other.trials);
    }

    double bestTrial(ArrayList l) {
        if (l == null || l.size() == 0) {
            return Double.NEGATIVE_INFINITY;
        }
        double best = (Double)l.get(0);
        int len = l.size();
        for (int i = 1; i < len; ++i) {
            double next = (Double)l.get(i);
            if (!(next > best)) continue;
            best = next;
        }
        return best;
    }

    public void merge(EvolutionState state, Fitness other) {
        if (other.trials == null) {
            return;
        }
        if (this.trials == null) {
            this.trials = other.trials;
            this.context = other.getContext();
        } else {
            if (!this.contextIsBetterThan(other)) {
                this.context = other.getContext();
            }
            this.trials.addAll(other.trials);
        }
    }

    public Object clone() {
        try {
            Fitness f = (Fitness)super.clone();
            if (f.trials != null) {
                f.trials = new ArrayList(this.trials);
            }
            f.setContext(f.getContext());
            return f;
        }
        catch (CloneNotSupportedException e) {
            throw new InternalError();
        }
    }

    public void setup(EvolutionState state, Parameter base) {
    }

    public int compareTo(Object o) {
        Fitness other = (Fitness)o;
        if (this.betterThan(other)) {
            return -1;
        }
        if (other.betterThan(this)) {
            return 1;
        }
        return 0;
    }

    public void setToBestOf(EvolutionState state, Fitness[] fitnesses) {
        Object[] f2 = (Fitness[])fitnesses.clone();
        Arrays.sort(f2);
        this.setToMeanOf(state, new Fitness[]{f2[0]});
    }

    public void setToMeanOf(EvolutionState state, Fitness[] fitnesses) {
        state.output.fatal("setToMeanOf(EvolutionState, Fitness[]) not implemented in " + this.getClass());
    }

    public void setToMedianOf(EvolutionState state, Fitness[] fitnesses) {
        Object[] f2 = (Fitness[])fitnesses.clone();
        Arrays.sort(f2);
        if (f2.length % 2 == 1) {
            this.setToMeanOf(state, new Fitness[]{f2[f2.length / 2]});
        } else {
            this.setToMeanOf(state, new Fitness[]{f2[f2.length / 2 - 1], f2[f2.length / 2]});
        }
    }
}

