/*
 * Decompiled with CFR 0.152.
 */
package ec.app.gpsemantics;

import ec.EvolutionState;
import ec.Individual;
import ec.app.gpsemantics.func.SemanticNode;
import ec.gp.GPIndividual;
import ec.gp.GPNode;
import ec.gp.GPProblem;
import ec.gp.GPTree;
import ec.simple.SimpleFitness;
import ec.simple.SimpleProblemForm;
import ec.util.Parameter;
import java.util.ArrayList;

public class Semantic
extends GPProblem
implements SimpleProblemForm {
    static final String P_PROBLEM_NAME = "problem_name";
    static final String P_SIZE = "size";
    static final String P_ORDER = "Order";
    static final String P_MAJORITY = "Majority";
    String problemName;
    int problemSize;

    public void setup(EvolutionState state, Parameter base) {
        super.setup(state, base);
        Parameter fsSize = new Parameter("gp").push("fs").push("0").push(P_SIZE);
        int numFuncs = state.parameters.getInt(fsSize, null, 1);
        this.problemSize = (numFuncs - 1) / 2;
        this.problemName = state.parameters.getString(base.push(P_PROBLEM_NAME), base.push(P_ORDER));
        if (!this.problemName.equals(P_ORDER) && !this.problemName.equals(P_MAJORITY)) {
            state.output.error("The problem name is unrecognized", base.push(P_PROBLEM_NAME));
        }
        System.out.println("Problem name " + this.problemName);
        System.out.println("Problem size " + this.problemSize);
        state.output.exitIfErrors();
    }

    public void evaluate(EvolutionState state, Individual ind, int subpopulation, int threadnum) {
        if (!ind.evaluated) {
            ArrayList output = this.getSemanticOutput(((GPIndividual)ind).trees[0]);
            double score = 0.0;
            for (int i = 0; i < output.size(); ++i) {
                SemanticNode n = (SemanticNode)output.get(i);
                if (n.value() != 'X') continue;
                score += 1.0;
            }
            SimpleFitness f = (SimpleFitness)ind.fitness;
            f.setFitness(state, score, false);
            ind.evaluated = true;
        }
    }

    ArrayList getSemanticOutput(GPTree t) {
        int i;
        ArrayList<SemanticNode> p = new ArrayList<SemanticNode>();
        ArrayList<GPNode> nodes = new ArrayList<GPNode>();
        int nterminals = t.child.numNodes(1);
        for (i = 0; i < nterminals; ++i) {
            nodes.add(t.child.nodeInPosition(i, 1));
        }
        if (this.problemName.equals(P_ORDER)) {
            for (i = 0; i < nodes.size(); ++i) {
                SemanticNode node = (SemanticNode)nodes.get(i);
                if (this.nodeSameIndexExists(p, node.index())) continue;
                p.add(node);
            }
        } else {
            for (int n = 0; n < this.problemSize; ++n) {
                int xCount = 0;
                int nCount = 0;
                int lastXNode = -1;
                for (int i2 = 0; i2 < nodes.size(); ++i2) {
                    SemanticNode node = (SemanticNode)nodes.get(i2);
                    if (node.value() == 'X' && node.index() == n) {
                        ++xCount;
                        lastXNode = i2;
                        continue;
                    }
                    if (node.value() != 'N' || node.index() != n) continue;
                    ++nCount;
                }
                if (xCount < nCount || xCount <= 0) continue;
                p.add((SemanticNode)nodes.get(lastXNode));
            }
        }
        return p;
    }

    boolean nodeSameIndexExists(ArrayList p, int n) {
        for (int i = 0; i < p.size(); ++i) {
            if (((SemanticNode)p.get(i)).index() != n) continue;
            return true;
        }
        return false;
    }

    String phenotypeToString(ArrayList p) {
        String retval = "";
        for (int i = 0; i < p.size(); ++i) {
            retval = retval + p.get(i).toString() + " ";
        }
        return retval;
    }

    public void describe(EvolutionState state, Individual ind, int subpopulation, int threadnum, int log) {
        state.output.println("\n\nBest Individual: output = " + this.phenotypeToString(this.getSemanticOutput(((GPIndividual)ind).trees[0])), log);
    }
}

