/*
 * Decompiled with CFR 0.152.
 */
package ec.app.nk;

import ec.EvolutionState;
import ec.Individual;
import ec.Problem;
import ec.simple.SimpleFitness;
import ec.simple.SimpleProblemForm;
import ec.util.Parameter;
import ec.vector.BitVectorIndividual;
import java.util.HashMap;

public class NK
extends Problem
implements SimpleProblemForm {
    public static final String P_N = "n";
    public static final String P_K = "k";
    public static final String P_ADJACENT = "adjacent";
    int k;
    boolean adjacentNeighborhoods;
    HashMap oldValues;

    public void setup(EvolutionState state, Parameter base) {
        super.setup(state, base);
        this.k = state.parameters.getInt(base.push(P_K), null, 1);
        if (this.k < 0 || this.k > 31) {
            state.output.fatal("Value of k must be between 0 and 31", base.push(P_K));
        }
        this.adjacentNeighborhoods = state.parameters.getBoolean(base.push(P_ADJACENT), null, true);
        this.oldValues = new HashMap();
    }

    public void evaluate(EvolutionState state, Individual ind, int subpopulation, int threadnum) {
        BitVectorIndividual ind2 = (BitVectorIndividual)ind;
        double fitness = 0.0;
        int n = ind2.genome.length;
        for (int i = 0; i < n; ++i) {
            boolean[] tmpInd = new boolean[this.k + 1];
            tmpInd[0] = ind2.genome[i];
            double val = 0.0;
            if (this.adjacentNeighborhoods) {
                int offset = n - this.k / 2;
                for (int j = 0; j < this.k; ++j) {
                    tmpInd[j + 1] = ind2.genome[(j + i + offset) % n];
                }
            } else {
                for (int l = 0; l < this.k; ++l) {
                    int j;
                    while ((j = state.random[0].nextInt(this.k)) == i) {
                    }
                    tmpInd[l + 1] = ind2.genome[j];
                }
            }
            if (this.oldValues.containsKey(tmpInd)) {
                val = (Double)this.oldValues.get(tmpInd);
            } else {
                double tmp = 0.0;
                for (int j = 0; j < tmpInd.length; ++j) {
                    if (!tmpInd[j]) continue;
                    tmp += (double)(1 << j);
                }
                val = tmp / 2.147483647E9;
                this.oldValues.put(tmpInd, new Double(val));
            }
            fitness += val;
        }
        ((SimpleFitness)ind2.fitness).setFitness(state, fitness /= (double)n, false);
        ind2.evaluated = true;
    }
}

