/*
 * Decompiled with CFR 0.152.
 */
package ec.app.ordertree;

import ec.EvolutionState;
import ec.Individual;
import ec.app.ordertree.func.OrderTreeNode;
import ec.gp.GPIndividual;
import ec.gp.GPNode;
import ec.gp.GPProblem;
import ec.simple.SimpleFitness;
import ec.simple.SimpleProblemForm;
import ec.util.Parameter;

public class OrderTree
extends GPProblem
implements SimpleProblemForm {
    double fitness;
    static final String P_CONTRIBUTION_TYPE = "contribution-type";
    static final int CONTRIBUTION_UNIT = 0;
    static final int CONTRIBUTION_VALUE = 1;
    static final int CONTRIBUTION_SQUARE = 2;
    static final int CONTRIBUTION_EXPONENTIAL = 3;
    int fitnessContributionType;

    public void setup(EvolutionState state, Parameter base) {
        super.setup(state, base);
        this.fitnessContributionType = state.parameters.getInt(base.push(P_CONTRIBUTION_TYPE), null, 1);
        if (this.fitnessContributionType < 0 || this.fitnessContributionType > 3) {
            state.output.fatal("Fitness Contribution Type must be an integer greater than 0 and less th an 4", base.push(P_CONTRIBUTION_TYPE));
        }
        state.output.exitIfErrors();
    }

    public void evaluate(EvolutionState state, Individual ind, int subpopulation, int threadnum) {
        if (!ind.evaluated) {
            this.fitness = 0.0;
            this.nodeCal(((GPIndividual)ind).trees[0].child, state);
            SimpleFitness f = (SimpleFitness)ind.fitness;
            f.setFitness(state, this.fitness, false);
            ind.evaluated = true;
        }
    }

    double fitnessContribution(double value, EvolutionState state) {
        switch (this.fitnessContributionType) {
            case 0: {
                return 1.0;
            }
            case 1: {
                return value;
            }
            case 2: {
                return value * value;
            }
            case 3: {
                return Math.pow(3.0, value);
            }
        }
        state.output.fatal("Unexpected fitness contribution type.");
        return -1.0;
    }

    void nodeCal(GPNode p, EvolutionState state) {
        int pval = ((OrderTreeNode)p).value();
        for (int i = 0; i < p.children.length; ++i) {
            GPNode c = p.children[i];
            int cval = ((OrderTreeNode)c).value();
            if (pval < cval) {
                this.fitness += this.fitnessContribution(cval, state);
                this.nodeCal(c, state);
                continue;
            }
            if (pval != cval) continue;
            boolean found = false;
            while (c.children.length > 0 && cval == pval && !found) {
                c = c.children[0];
                cval = ((OrderTreeNode)c).value();
                if (pval >= cval) continue;
                found = true;
            }
            if (!found) continue;
            this.fitness += this.fitnessContribution(cval, state);
            this.nodeCal(c, state);
        }
    }
}

