/*
 * Decompiled with CFR 0.152.
 */
package ec.app.tutorial4;

import ec.EvolutionState;
import ec.Individual;
import ec.app.tutorial4.DoubleData;
import ec.gp.GPIndividual;
import ec.gp.GPProblem;
import ec.gp.koza.KozaFitness;
import ec.simple.SimpleProblemForm;
import ec.util.Parameter;

public class MultiValuedRegression
extends GPProblem
implements SimpleProblemForm {
    private static final long serialVersionUID = 1L;
    public double currentX;
    public double currentY;

    public void setup(EvolutionState state, Parameter base) {
        super.setup(state, base);
        if (!(this.input instanceof DoubleData)) {
            state.output.fatal("GPData class must subclass from " + DoubleData.class, base.push("data"), null);
        }
    }

    public void evaluate(EvolutionState state, Individual ind, int subpopulation, int threadnum) {
        if (!ind.evaluated) {
            DoubleData input = (DoubleData)this.input;
            int hits = 0;
            double sum = 0.0;
            for (int y = 0; y < 10; ++y) {
                this.currentX = state.random[threadnum].nextDouble();
                this.currentY = state.random[threadnum].nextDouble();
                double expectedResult = this.currentX * this.currentX * this.currentY + this.currentX * this.currentY + this.currentY;
                ((GPIndividual)ind).trees[0].child.eval(state, threadnum, input, this.stack, (GPIndividual)ind, this);
                double result = Math.abs(expectedResult - input.x);
                if (result <= 0.01) {
                    ++hits;
                }
                sum += result;
            }
            KozaFitness f = (KozaFitness)ind.fitness;
            f.setStandardizedFitness(state, sum);
            f.hits = hits;
            ind.evaluated = true;
        }
    }
}

