/*
 * Decompiled with CFR 0.152.
 */
package ec.display;

import ec.display.Console;
import ec.util.Parameter;
import ec.util.ParameterDatabase;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.event.FocusAdapter;
import java.awt.event.FocusEvent;
import java.util.Set;
import javax.swing.DefaultCellEditor;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JComboBox;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JSplitPane;
import javax.swing.JTable;
import javax.swing.JTree;
import javax.swing.event.TableModelEvent;
import javax.swing.event.TableModelListener;
import javax.swing.event.TreeSelectionEvent;
import javax.swing.event.TreeSelectionListener;
import javax.swing.table.DefaultTableModel;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.DefaultTreeModel;
import javax.swing.tree.TreeNode;
import javax.swing.tree.TreePath;

public class ParametersPanel
extends JPanel {
    private final Console console;
    private JScrollPane parameterTreeScrollPane = null;
    private JTree parameterTree = null;
    private JScrollPane parameterTableScrollPane = null;
    private JTable parameterTable = null;
    private JSplitPane jSplitPane = null;

    private JScrollPane getParameterTreeScrollPane() {
        if (this.parameterTreeScrollPane == null) {
            this.parameterTreeScrollPane = new JScrollPane();
            this.parameterTreeScrollPane.setViewportView(this.getParameterTree());
            this.parameterTreeScrollPane.setPreferredSize(new Dimension(150, 363));
        }
        return this.parameterTreeScrollPane;
    }

    private JTree getParameterTree() {
        if (this.parameterTree == null) {
            DefaultMutableTreeNode root = new DefaultMutableTreeNode();
            DefaultTreeModel model = new DefaultTreeModel(root);
            this.parameterTree = new JTree(model);
            this.parameterTree.setRootVisible(false);
            this.parameterTree.setShowsRootHandles(false);
            this.parameterTree.addTreeSelectionListener(new TreeSelectionListener(){

                public void valueChanged(TreeSelectionEvent e) {
                    DefaultTableModel tableModel = (DefaultTableModel)ParametersPanel.this.parameterTable.getModel();
                    int rows = tableModel.getRowCount();
                    for (int row = rows - 1; row >= 0; --row) {
                        tableModel.removeRow(row);
                    }
                    TreePath path = e.getPath();
                    Object[] oPath = path.getPath();
                    StringBuilder sBuff = new StringBuilder();
                    for (int i = 1; i < oPath.length; ++i) {
                        sBuff.append(oPath[i]);
                        if (i >= oPath.length - 1) continue;
                        sBuff.append('.');
                    }
                    Object[] newRow = new String[]{"", "", ""};
                    DefaultMutableTreeNode selected = (DefaultMutableTreeNode)oPath[oPath.length - 1];
                    if (!selected.equals(oPath[0])) {
                        newRow[0] = sBuff.toString();
                        Parameter param = new Parameter(newRow[0]);
                        newRow[1] = ((ParametersPanel)ParametersPanel.this).console.parameters.getString(param, null);
                        ParameterDatabase p = ((ParametersPanel)ParametersPanel.this).console.parameters.getLocation(param);
                        newRow[2] = p == null ? "" : p.getLabel();
                        if (newRow[1] != null) {
                            tableModel.addRow(newRow);
                        }
                    }
                    if (!newRow[0].equals("")) {
                        newRow[0] = newRow[0] + ".";
                    }
                    if (!selected.isLeaf()) {
                        int children = selected.getChildCount();
                        for (int ch = 0; ch < children; ++ch) {
                            TreeNode child = selected.getChildAt(ch);
                            Object[] childRow = new String[3];
                            childRow[0] = newRow[0] + child;
                            Parameter param = new Parameter(childRow[0]);
                            childRow[1] = ((ParametersPanel)ParametersPanel.this).console.parameters.getString(param, null);
                            ParameterDatabase p = ((ParametersPanel)ParametersPanel.this).console.parameters.getLocation(param);
                            childRow[2] = p == null ? "" : p.getLabel();
                            if (childRow[1] == null) continue;
                            tableModel.addRow(childRow);
                        }
                    }
                }
            });
        }
        return this.parameterTree;
    }

    private JScrollPane getParameterTableScrollPane() {
        if (this.parameterTableScrollPane == null) {
            this.parameterTableScrollPane = new JScrollPane();
            this.parameterTableScrollPane.setViewportView(this.getParameterTable());
        }
        return this.parameterTableScrollPane;
    }

    private JTable getParameterTable() {
        if (this.parameterTable == null) {
            Object[] cn = new String[]{"Parameter", "Value", "Source"};
            DefaultTableModel model = new DefaultTableModel(cn, 0);
            model.addTableModelListener(new TableModelListener(){

                public void tableChanged(TableModelEvent evt) {
                    if (evt.getColumn() == 1 && evt.getType() == 0) {
                        int row = evt.getFirstRow();
                        DefaultTableModel model = (DefaultTableModel)evt.getSource();
                        String key = (String)model.getValueAt(row, 0);
                        String value = (String)model.getValueAt(row, 1);
                        Parameter parameter = new Parameter(key);
                        if (!((ParametersPanel)ParametersPanel.this).console.parameters.getString(parameter, null).equals(value)) {
                            System.out.println("setting parameter " + parameter + " to " + value);
                            ((ParametersPanel)ParametersPanel.this).console.parameters.set(parameter, value);
                        }
                    }
                }
            });
            this.parameterTable = new JTable(model);
            this.parameterTable.setSelectionMode(0);
            this.parameterTable.setAutoResizeMode(0);
            this.parameterTable.getColumnModel().getColumn(0).setPreferredWidth(150);
            this.parameterTable.getColumnModel().getColumn(1).setPreferredWidth(150);
            this.parameterTable.getColumnModel().getColumn(2).setPreferredWidth(450);
            final JComboBox valueEditor = new JComboBox();
            this.parameterTable.getColumnModel().getColumn(1).setCellEditor(new DefaultCellEditor(valueEditor));
            valueEditor.addFocusListener(new FocusAdapter(){

                public void focusGained(FocusEvent evt) {
                    int row = ParametersPanel.this.parameterTable.getSelectedRow();
                    String pName = (String)ParametersPanel.this.parameterTable.getValueAt(row, 0);
                    Set values = ((ParametersPanel)ParametersPanel.this).console.parameters.getShadowedValues(new Parameter(pName));
                    DefaultComboBoxModel<Object> model = new DefaultComboBoxModel<Object>(values.toArray());
                    valueEditor.setModel(model);
                }
            });
        }
        return this.parameterTable;
    }

    private JSplitPane getJSplitPane() {
        if (this.jSplitPane == null) {
            this.jSplitPane = new JSplitPane();
            this.jSplitPane.setLeftComponent(this.getParameterTreeScrollPane());
            this.jSplitPane.setRightComponent(this.getParameterTableScrollPane());
            this.jSplitPane.setDividerSize(5);
            this.jSplitPane.setDividerLocation(200);
        }
        return this.jSplitPane;
    }

    public ParametersPanel(Console console) {
        this.initialize();
        this.console = console;
    }

    private void initialize() {
        this.setLayout(new BorderLayout());
        this.setSize(645, 321);
        this.add((Component)this.getJSplitPane(), "Center");
    }

    void loadParameters() {
        this.parameterTree.setModel(this.console.parameters.buildTreeModel());
        this.parameterTree.setRootVisible(true);
    }
}

