/*
 * Decompiled with CFR 0.152.
 */
package ec.es;

import ec.Breeder;
import ec.BreedingPipeline;
import ec.EvolutionState;
import ec.Individual;
import ec.Population;
import ec.es.ESDefaults;
import ec.es.MuLambdaBreederThread;
import ec.util.Parameter;
import java.util.Arrays;
import java.util.Comparator;

public class MuCommaLambdaBreeder
extends Breeder {
    public static final String P_MU = "mu";
    public static final String P_MU_FRACTION = "mu-fraction";
    public static final String P_LAMBDA = "lambda";
    public int[] mu;
    public int[] lambda;
    public Population parentPopulation;
    public byte[] comparison;
    public static final byte C_OVER_ONE_FIFTH_BETTER = 1;
    public static final byte C_UNDER_ONE_FIFTH_BETTER = -1;
    public static final byte C_EXACTLY_ONE_FIFTH_BETTER = 0;
    public int[] count;
    int[] children;
    int[] parents;

    public int maximumMuLambdaDivisor() {
        return 2;
    }

    public void setup(EvolutionState state, Parameter base) {
        Parameter p = new Parameter("pop").push("subpops");
        int size = state.parameters.getInt(p, null, 1);
        this.mu = new int[size];
        this.lambda = new int[size];
        this.comparison = new byte[size];
        for (int x = 0; x < size; ++x) {
            Parameter pp = new Parameter("pop").push("subpop").push("" + x).push("size");
            int ppval = state.parameters.getInt(pp, null, 1);
            if (state.parameters.exists(ESDefaults.base().push(P_LAMBDA).push("" + x), null)) {
                this.lambda[x] = state.parameters.getInt(ESDefaults.base().push(P_LAMBDA).push("" + x), null, 1);
                if (this.lambda[x] == 0) {
                    state.output.error("lambda must be an integer >= 1", ESDefaults.base().push(P_LAMBDA).push("" + x));
                }
            } else {
                state.output.warning("lambda not specified for subpopulation " + x + ", setting it to the subopulation size, that is, " + ppval + ".", ESDefaults.base().push(P_LAMBDA).push("" + x), null);
                this.lambda[x] = ppval;
                if (this.lambda[x] == 0) {
                    state.output.error("Subpouplation Size must be >= 1", pp, null);
                }
            }
            if (state.parameters.exists(ESDefaults.base().push(P_MU).push("" + x), null)) {
                if (state.parameters.exists(ESDefaults.base().push(P_MU_FRACTION).push("" + x), null)) {
                    state.output.warning("Defined both a mu and mu-fraction for subpopulation " + x + ".  Only mu will be used. ", ESDefaults.base().push(P_MU).push("" + x), ESDefaults.base().push(P_MU_FRACTION).push("" + x));
                }
                this.mu[x] = state.parameters.getInt(ESDefaults.base().push(P_MU).push("" + x), null, 1);
                if (this.mu[x] == 0) {
                    state.output.error("mu must be an integer >= 1", ESDefaults.base().push(P_MU).push("" + x), null);
                    continue;
                }
                if (this.lambda[x] % this.mu[x] != 0) {
                    if (this.mu[x] > this.lambda[x] / this.maximumMuLambdaDivisor()) {
                        state.output.warning("mu (" + this.mu[x] + ") for subpopulation " + x + " is greater than lambda (" + this.lambda[x] + ") / " + this.maximumMuLambdaDivisor() + ".  Mu will be set to half of lambda, that is, " + this.lambda[x] / this.maximumMuLambdaDivisor() + ".");
                        this.mu[x] = this.lambda[x] / this.maximumMuLambdaDivisor();
                    }
                    if (this.lambda[x] % this.mu[x] == 0) continue;
                    state.output.error("mu must be a divisor of lambda", ESDefaults.base().push(P_MU).push("" + x));
                    continue;
                }
                if (this.mu[x] <= ppval) continue;
                state.output.warning("mu is presently > the initial subpopulation size.  Mu will be set to the subpopulation size, that is, " + ppval + ".", ESDefaults.base().push(P_MU).push("" + x), null);
                this.mu[x] = ppval;
                continue;
            }
            if (state.parameters.exists(ESDefaults.base().push(P_MU_FRACTION).push("" + x), null)) {
                int m;
                double mufrac = state.parameters.getDoubleWithMax(ESDefaults.base().push(P_MU_FRACTION).push("" + x), null, 0.0, 1.0 / (double)this.maximumMuLambdaDivisor());
                if (mufrac < 0.0) {
                    state.output.fatal("Mu-Fraction must be a value between 0.0 and " + 1.0 / (double)this.maximumMuLambdaDivisor(), ESDefaults.base().push(P_MU_FRACTION).push("" + x), null);
                }
                this.mu[x] = m = (int)Math.max((double)this.lambda[x] * mufrac, 1.0);
                double val = (double)this.lambda[x] / (double)this.mu[x];
                while (val != (double)((int)val)) {
                    int n = x;
                    this.mu[n] = this.mu[n] - 1;
                    val = (double)this.lambda[x] / (double)this.mu[x];
                }
                state.output.message("Mu-Fraction " + mufrac + " yields a mu of " + m + ", adjusted to " + this.mu[x]);
                continue;
            }
            state.output.fatal("Neither a Mu or a Mu-Fraction was provided for subpopulation " + x, ESDefaults.base().push(P_MU).push("" + x), ESDefaults.base().push(P_MU_FRACTION).push("" + x));
        }
        state.output.exitIfErrors();
    }

    public Population setToLambda(Population pop, EvolutionState state) {
        for (int x = 0; x < pop.subpops.length; ++x) {
            int s = this.lambda[x];
            if (pop.subpops[x].individuals.length == s) continue;
            Individual[] newinds = new Individual[s];
            System.arraycopy(pop.subpops[x].individuals, 0, newinds, 0, s < pop.subpops[x].individuals.length ? s : pop.subpops[x].individuals.length);
            pop.subpops[x].individuals = newinds;
        }
        return pop;
    }

    public Population breedPopulation(EvolutionState state) {
        int x;
        if (this.parentPopulation != null) {
            for (x = 0; x < state.population.subpops.length; ++x) {
                int numChildrenBetter = 0;
                for (int i = 0; i < this.lambda[x]; ++i) {
                    int parent = i / (this.lambda[x] / this.mu[x]);
                    if (!state.population.subpops[x].individuals[i].fitness.betterThan(this.parentPopulation.subpops[x].individuals[parent].fitness)) continue;
                    ++numChildrenBetter;
                }
                this.comparison[x] = (double)numChildrenBetter > (double)this.lambda[x] / 5.0 ? 1 : ((double)numChildrenBetter < (double)this.lambda[x] / 5.0 ? -1 : 0);
            }
        }
        this.parentPopulation = state.population;
        if (this.mu.length != state.population.subpops.length) {
            state.output.fatal("For some reason the number of subpops is different than was specified in the file (conflicting with Mu and Lambda storage).", null);
        }
        for (x = 0; x < state.population.subpops.length; ++x) {
            if (state.population.subpops[0].individuals.length >= this.mu[x]) continue;
            state.output.error("Subpopulation " + x + " must be a multiple of the equivalent mu (that is, " + this.mu[x] + ").");
        }
        state.output.exitIfErrors();
        for (x = 0; x < state.population.subpops.length; ++x) {
            Individual[] i = state.population.subpops[x].individuals;
            Arrays.sort(i, new Comparator(){

                public int compare(Object o1, Object o2) {
                    Individual a = (Individual)o1;
                    Individual b = (Individual)o2;
                    if (b.fitness.betterThan(a.fitness)) {
                        return 1;
                    }
                    if (a.fitness.betterThan(b.fitness)) {
                        return -1;
                    }
                    return 0;
                }
            });
        }
        Population newpop = this.setToLambda((Population)state.population.emptyClone(), state);
        this.count = new int[state.breedthreads];
        int numThreads = 0;
        for (int x2 = 0; x2 < state.population.subpops.length; ++x2) {
            numThreads = Math.max(numThreads, this.lambda[x2]);
        }
        if ((numThreads = Math.min(numThreads, state.breedthreads)) < state.breedthreads) {
            state.output.warnOnce("Largest lambda size (" + numThreads + ") is smaller than number of breedthreads (" + state.breedthreads + "), so fewer breedthreads will be created.");
        }
        int[][] numinds = new int[numThreads][state.population.subpops.length];
        int[][] from = new int[numThreads][state.population.subpops.length];
        for (int x3 = 0; x3 < state.population.subpops.length; ++x3) {
            int length = this.lambda[x3];
            int individualsPerThread = length / numThreads;
            int slop = length - numThreads * individualsPerThread;
            int currentFrom = 0;
            for (int y = 0; y < numThreads; ++y) {
                if (slop > 0) {
                    numinds[y][x3] = individualsPerThread + 1;
                    --slop;
                } else {
                    numinds[y][x3] = individualsPerThread;
                }
                if (numinds[y][x3] == 0) {
                    state.output.warnOnce("More threads exist than can be used to breed some subpopulations (first example: subpopulation " + x3 + ")");
                }
                from[y][x3] = currentFrom;
                currentFrom += numinds[y][x3];
            }
        }
        if (numThreads == 1) {
            this.breedPopChunk(newpop, state, numinds[0], from[0], 0);
        } else {
            int y;
            Thread[] t = new Thread[numThreads];
            for (y = 0; y < numThreads; ++y) {
                MuLambdaBreederThread r = new MuLambdaBreederThread();
                r.threadnum = y;
                r.newpop = newpop;
                r.numinds = numinds[y];
                r.from = from[y];
                r.me = this;
                r.state = state;
                t[y] = new Thread(r);
                t[y].start();
            }
            for (y = 0; y < numThreads; ++y) {
                try {
                    t[y].join();
                    continue;
                }
                catch (InterruptedException e) {
                    state.output.fatal("Whoa! The main breeding thread got interrupted!  Dying...");
                }
            }
        }
        return this.postProcess(newpop, state.population, state);
    }

    public Population postProcess(Population newpop, Population oldpop, EvolutionState state) {
        return newpop;
    }

    public void breedPopChunk(Population newpop, EvolutionState state, int[] numinds, int[] from, int threadnum) {
        for (int subpop = 0; subpop < newpop.subpops.length; ++subpop) {
            this.count[threadnum] = 0;
            BreedingPipeline bp = (BreedingPipeline)newpop.subpops[subpop].species.pipe_prototype.clone();
            if (!bp.produces(state, newpop, subpop, threadnum)) {
                state.output.fatal("The Breeding Pipeline of subpopulation " + subpop + " does not produce individuals of the expected species " + newpop.subpops[subpop].species.getClass().getName() + " or fitness " + newpop.subpops[subpop].species.f_prototype);
            }
            bp.prepareToProduce(state, subpop, threadnum);
            if (this.count[threadnum] == 0) {
                state.output.warnOnce("Whoa!  Breeding Pipeline for subpop " + subpop + " doesn't have an ESSelection, but is being used by MuCommaLambdaBreeder or MuPlusLambdaBreeder.  That's probably not right.");
            }
            this.count[threadnum] = 0;
            int upperbound = from[subpop] + numinds[subpop];
            for (int x = from[subpop]; x < upperbound; ++x) {
                if (bp.produce(1, 1, x, subpop, newpop.subpops[subpop].individuals, state, threadnum) != 1) {
                    state.output.fatal("Whoa! Breeding Pipeline for subpop " + subpop + " is not producing one individual at a time, as is required by the MuLambda strategies.");
                }
                int n = threadnum;
                this.count[n] = this.count[n] + 1;
            }
            bp.finishProducing(state, subpop, threadnum);
        }
    }
}

