/*
 * Decompiled with CFR 0.152.
 */
package ec.multiobjective.spea2;

import ec.EvolutionState;
import ec.Fitness;
import ec.multiobjective.MultiObjectiveFitness;
import ec.util.Code;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.io.LineNumberReader;

public class SPEA2MultiObjectiveFitness
extends MultiObjectiveFitness {
    public static final String SPEA2_FITNESS_PREAMBLE = "Fitness: ";
    public static final String SPEA2_STRENGTH_PREAMBLE = "Strength: ";
    public static final String SPEA2_DISTANCE_PREAMBLE = "Distance: ";
    public double strength;
    public double kthNNDistance;
    public double fitness;

    public String[] getAuxilliaryFitnessNames() {
        return new String[]{"Strength", "Raw Fitness", "Kth NN Distance"};
    }

    public double[] getAuxilliaryFitnessValues() {
        return new double[]{this.strength, this.fitness, this.kthNNDistance};
    }

    public String fitnessToString() {
        return super.fitnessToString() + "\n" + SPEA2_FITNESS_PREAMBLE + Code.encode(this.fitness) + "\n" + SPEA2_STRENGTH_PREAMBLE + Code.encode(this.strength) + "\n" + SPEA2_DISTANCE_PREAMBLE + Code.encode(this.kthNNDistance);
    }

    public String fitnessToStringForHumans() {
        return super.fitnessToStringForHumans() + "\n" + SPEA2_STRENGTH_PREAMBLE + this.strength + "\n" + SPEA2_DISTANCE_PREAMBLE + this.kthNNDistance + " " + SPEA2_FITNESS_PREAMBLE + this.fitness;
    }

    public void readFitness(EvolutionState state, LineNumberReader reader) throws IOException {
        super.readFitness(state, reader);
        this.fitness = Code.readDoubleWithPreamble(SPEA2_FITNESS_PREAMBLE, state, reader);
        this.strength = Code.readDoubleWithPreamble(SPEA2_STRENGTH_PREAMBLE, state, reader);
        this.kthNNDistance = Code.readDoubleWithPreamble(SPEA2_DISTANCE_PREAMBLE, state, reader);
    }

    public void writeFitness(EvolutionState state, DataOutput dataOutput) throws IOException {
        super.writeFitness(state, dataOutput);
        dataOutput.writeDouble(this.fitness);
        dataOutput.writeDouble(this.strength);
        dataOutput.writeDouble(this.fitness);
        dataOutput.writeDouble(this.kthNNDistance);
        this.writeTrials(state, dataOutput);
    }

    public void readFitness(EvolutionState state, DataInput dataInput) throws IOException {
        super.readFitness(state, dataInput);
        this.fitness = dataInput.readDouble();
        this.strength = dataInput.readDouble();
        this.fitness = dataInput.readDouble();
        this.kthNNDistance = dataInput.readDouble();
        this.readTrials(state, dataInput);
    }

    public boolean equivalentTo(Fitness _fitness) {
        return this.fitness == ((SPEA2MultiObjectiveFitness)_fitness).fitness;
    }

    public boolean betterThan(Fitness _fitness) {
        return this.fitness < ((SPEA2MultiObjectiveFitness)_fitness).fitness;
    }
}

