/*
 * Decompiled with CFR 0.152.
 */
package ec.rule;

import ec.EvolutionState;
import ec.Prototype;
import ec.rule.RuleConstraints;
import ec.rule.RuleDefaults;
import ec.rule.RuleInitializer;
import ec.util.Parameter;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.io.LineNumberReader;
import java.io.PrintWriter;

public abstract class Rule
implements Prototype,
Comparable {
    public static final String P_RULE = "rule";
    public static final String P_CONSTRAINTS = "constraints";
    public byte constraints;

    public final RuleConstraints constraints(RuleInitializer initializer) {
        return initializer.ruleConstraints[this.constraints];
    }

    public abstract int hashCode();

    public boolean equals(Object other) {
        return this.compareTo(other) == 0;
    }

    public abstract void reset(EvolutionState var1, int var2);

    public void mutate(EvolutionState state, int thread) {
        this.reset(state, thread);
    }

    public void printRuleForHumans(EvolutionState state, int log) {
        this.printRuleForHumans(state, log, 0);
    }

    public void printRuleForHumans(EvolutionState state, int log, int verbosity) {
        state.output.println(this.printRuleToStringForHumans(), log);
    }

    public String printRuleToStringForHumans() {
        return this.toString();
    }

    public String printRuleToString(EvolutionState state) {
        return this.printRuleToString();
    }

    public String printRuleToString() {
        return this.toString();
    }

    public void readRuleFromString(String string, EvolutionState state) {
        state.output.error("readRuleFromString(string,state) unimplemented in " + this.getClass());
    }

    public void printRule(EvolutionState state, int log) {
        this.printRule(state, log, 0);
    }

    public void printRule(EvolutionState state, int log, int verbosity) {
        state.output.println(this.printRuleToString(state), log);
    }

    public void printRule(EvolutionState state, PrintWriter writer) {
        writer.println(this.printRuleToString(state));
    }

    public void readRule(EvolutionState state, LineNumberReader reader) throws IOException {
        this.readRuleFromString(reader.readLine(), state);
    }

    public void writeRule(EvolutionState state, DataOutput dataOutput) throws IOException {
        state.output.fatal("writeRule(EvolutionState, DataOutput) not implemented in " + this.getClass());
    }

    public void readRule(EvolutionState state, DataInput dataInput) throws IOException {
        state.output.fatal("readRule(EvolutionState, DataInput) not implemented in " + this.getClass());
    }

    public Parameter defaultBase() {
        return RuleDefaults.base().push(P_RULE);
    }

    public Object clone() {
        try {
            return super.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new InternalError();
        }
    }

    public void setup(EvolutionState state, Parameter base) {
        String constraintname = state.parameters.getString(base.push(P_CONSTRAINTS), this.defaultBase().push(P_CONSTRAINTS));
        if (constraintname == null) {
            state.output.fatal("No RuleConstraints name given", base.push(P_CONSTRAINTS), this.defaultBase().push(P_CONSTRAINTS));
        }
        this.constraints = RuleConstraints.constraintsFor((String)constraintname, (EvolutionState)state).constraintNumber;
        state.output.exitIfErrors();
    }

    public abstract int compareTo(Object var1);
}

